/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.common.schedule;

import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScheduledThreadPoolBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ScheduledThreadPoolBuilder.class);

    public static ScheduledThreadPoolExecutor newScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory) {
        return new ScheduledThreadPoolExecutor(corePoolSize, threadFactory){

            @Override
            protected void afterExecute(Runnable runnable, Throwable throwable) {
                super.afterExecute(runnable, throwable);
                String threadName = Thread.currentThread().getName();
                if (throwable == null && runnable instanceof Future) {
                    try {
                        Future future = (Future)((Object)runnable);
                        if (future.isCancelled()) {
                            logger.info("thread:{} is cancelled!", (Object)threadName);
                            Thread.currentThread().interrupt();
                        } else if (future.isDone()) {
                            future.get();
                            logger.info("thread:{} execute completed!", (Object)threadName);
                        }
                    }
                    catch (InterruptedException ex) {
                        logger.error("thread:{} interrupted!", (Object)threadName, (Object)ex);
                    }
                    catch (Error | Exception ex) {
                        logger.error("thread:{} execute failed!", (Object)threadName, (Object)ex);
                    }
                } else if (throwable != null) {
                    logger.error("thread:{} execute failed!", (Object)threadName, (Object)throwable);
                }
            }
        };
    }
}

