/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.common.util;

import com.dtstep.lighthouse.common.util.StringUtil;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class JsonUtil {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final Pattern DATE_TIME_PATTERN;
    private static final Pattern DATE_PATTERN;
    private static final Pattern TIME_PATTERN;

    public static ObjectNode createObjectNode() {
        return objectMapper.createObjectNode();
    }

    public static ArrayNode createArrayNode() {
        return objectMapper.createArrayNode();
    }

    public static <T> String toJSONString(T t) {
        if (t == null) {
            return null;
        }
        if (t instanceof String) {
            return t.toString();
        }
        if (t instanceof Number) {
            return t.toString();
        }
        try {
            return objectMapper.writeValueAsString(t);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static JsonNode readTree(String str) throws JsonProcessingException {
        if (StringUtil.isEmpty(str)) {
            return null;
        }
        return objectMapper.readTree(str);
    }

    public static ArrayNode valueToTree(Object o) throws Exception {
        return o == null ? null : (ArrayNode)objectMapper.valueToTree(o);
    }

    public static <T> T toJavaObject(String value, Class<T> clazz) {
        return (T)(StringUtils.isNotBlank((CharSequence)value) ? JsonUtil.toJavaObject(value, clazz, () -> null) : null);
    }

    private static <T> T toJavaObject(String value, Class<T> tClass, Supplier<T> defaultSupplier) {
        try {
            if (StringUtils.isBlank((CharSequence)value)) {
                return defaultSupplier.get();
            }
            return (T)objectMapper.readValue(value, tClass);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return defaultSupplier.get();
        }
    }

    public static <T> T readValue(String value, TypeReference<T> t) throws Exception {
        return (T)objectMapper.readValue(value, t);
    }

    public static <T> List<T> toJavaObjectList(String value, Class<T> tClass) {
        return StringUtils.isNotBlank((CharSequence)value) ? JsonUtil.toJavaObjectList(value, tClass, () -> null) : null;
    }

    public static <T> List<T> toJavaObjectList(Object obj, Class<T> tClass) {
        return obj != null ? JsonUtil.toJavaObjectList(JsonUtil.toJSONString(obj), tClass, () -> null) : null;
    }

    public static <T> List<T> toJavaObjectList(String value, Class<T> tClass, Supplier<List<T>> defaultSupplier) {
        try {
            if (StringUtils.isBlank((CharSequence)value)) {
                return defaultSupplier.get();
            }
            JavaType javaType = objectMapper.getTypeFactory().constructParametricType(List.class, new Class[]{tClass});
            return (List)objectMapper.readValue(value, javaType);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return defaultSupplier.get();
        }
    }

    public static Map<String, Object> toMap(String value) {
        return StringUtils.isNotBlank((CharSequence)value) ? JsonUtil.toMap(value, () -> null) : null;
    }

    private static LinkedHashMap toMap(String value, Supplier<LinkedHashMap<String, Object>> defaultSupplier) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return defaultSupplier.get();
        }
        try {
            return JsonUtil.toJavaObject(value, LinkedHashMap.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultSupplier.get();
        }
    }

    private static <T> Map<String, T> toMap2(String value, Supplier<Map<String, T>> defaultSupplier) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return defaultSupplier.get();
        }
        try {
            return JsonUtil.toJavaObject(value, LinkedHashMap.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultSupplier.get();
        }
    }

    public static List<Object> toList(String value) {
        return StringUtils.isNotBlank((CharSequence)value) ? JsonUtil.toList(value, () -> null) : null;
    }

    private static List<Object> toList(String value, Supplier<List<Object>> defaultSuppler) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return defaultSuppler.get();
        }
        try {
            return JsonUtil.toJavaObject(value, List.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultSuppler.get();
        }
    }

    static {
        SimpleModule module = new SimpleModule();
        objectMapper.registerModule((Module)module);
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        objectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        objectMapper.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
        objectMapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.getSerializerProvider().setNullKeySerializer((JsonSerializer)new NullKeySerializer());
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, true);
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeToEpochSerializer());
        simpleModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeFromEpochDeserializer());
        simpleModule.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeToEpochSerializer());
        simpleModule.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeFromEpochDeserializer());
        objectMapper.registerModule((Module)simpleModule);
        DATE_TIME_PATTERN = Pattern.compile("\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}");
        DATE_PATTERN = Pattern.compile("\\d{4}-\\d{2}-\\d{2}");
        TIME_PATTERN = Pattern.compile("\\d{2}:\\d{2}:\\d{2}");
    }

    public static class LocalTimeFromEpochDeserializer
    extends JsonDeserializer<LocalTime> {
        public LocalTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String text = p.getText();
            if (TIME_PATTERN.matcher(text).matches()) {
                return LocalTime.parse(text, DateTimeFormatter.ofPattern("HH:mm:ss"));
            }
            throw new IOException();
        }
    }

    public static class LocalDateTimeFromEpochDeserializer
    extends JsonDeserializer<LocalDateTime> {
        public LocalDateTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String text = p.getText();
            if (DATE_TIME_PATTERN.matcher(text).matches()) {
                LocalDate localDate = LocalDate.parse(text, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                return localDate.atStartOfDay();
            }
            if (DATE_PATTERN.matcher(text).matches()) {
                LocalDate localDate = LocalDate.parse(text, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                return localDate.atStartOfDay();
            }
            long epoch = Long.parseLong(text);
            return LocalDateTime.ofInstant(Instant.ofEpochSecond(epoch), ZoneId.systemDefault());
        }
    }

    public static class LocalDateToEpochSerializer
    extends JsonSerializer<LocalDate> {
        public void serialize(LocalDate value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (value != null) {
                long timestamp = value.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
                gen.writeNumber(timestamp);
            }
        }
    }

    public static class LocalTimeToEpochSerializer
    extends JsonSerializer<LocalTime> {
        public void serialize(LocalTime value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (value != null) {
                gen.writeString(value.format(DateTimeFormatter.ofPattern("HH:mm:ss")));
            }
        }
    }

    public static class LocalDateTimeToEpochSerializer
    extends JsonSerializer<LocalDateTime> {
        public void serialize(LocalDateTime value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (value != null) {
                long timestamp = value.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
                gen.writeNumber(timestamp);
            }
        }
    }

    static class NullKeySerializer
    extends JsonSerializer<Object> {
        NullKeySerializer() {
        }

        public void serialize(Object nullKey, JsonGenerator jsonGenerator, SerializerProvider unused) throws IOException {
            jsonGenerator.writeFieldName("null");
        }
    }
}

