/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.common.util;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;
import jodd.util.Base64;

public final class ZipUtil {
    public static String zipJson(String str) throws Exception {
        if (null == str || str.length() <= 0) {
            return str;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(out);
        gzip.write(str.getBytes(StandardCharsets.UTF_8));
        gzip.close();
        return out.toString("ISO-8859-1");
    }

    public static String zip(String unzip) {
        Deflater deflater = new Deflater(9);
        deflater.setInput(unzip.getBytes());
        deflater.finish();
        byte[] bytes = new byte[256];
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(256);
        while (!deflater.finished()) {
            int length = deflater.deflate(bytes);
            outputStream.write(bytes, 0, length);
        }
        deflater.end();
        return Base64.encodeToString((byte[])outputStream.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String unzip(String zip) {
        byte[] decode = Base64.decode((String)zip);
        Inflater inflater = new Inflater();
        inflater.setInput(decode);
        byte[] bytes = new byte[256];
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(256);
        try {
            while (!inflater.finished()) {
                int length = inflater.inflate(bytes);
                outputStream.write(bytes, 0, length);
            }
        }
        catch (DataFormatException e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            inflater.end();
        }
        return outputStream.toString();
    }
}

