/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.config;

import com.dtstep.lighthouse.common.enums.UserStateEnum;
import com.dtstep.lighthouse.common.util.StringUtil;
import com.dtstep.lighthouse.insights.config.RepeatableRequestWrapper;
import com.dtstep.lighthouse.insights.config.SeedAuthenticationToken;
import com.dtstep.lighthouse.insights.service.SystemEnvService;
import com.dtstep.lighthouse.insights.service.UserService;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class AuthenticationTokenFilter
extends OncePerRequestFilter {
    @Autowired
    private SystemEnvService systemEnvService;
    @Autowired
    private UserService userService;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        Jws jws;
        String authToken = request.getHeader("accessKey");
        if (StringUtil.isEmptyOrNullStr((String)authToken)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String secretKey = this.systemEnvService.getParam("sign_key");
        try {
            jws = Jwts.parser().setSigningKey(secretKey).parseClaimsJws(authToken);
        }
        catch (Exception ex) {
            this.logger.warn((Object)"JWT signature verification failed!");
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (jws == null) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        Long expired = (Long)((Claims)jws.getBody()).get((Object)"expired");
        if (expired == null || expired <= System.currentTimeMillis()) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        Integer id = (Integer)((Claims)jws.getBody()).get((Object)"id");
        UserStateEnum userStateEnum = this.userService.queryUserState(id);
        if (userStateEnum != UserStateEnum.USER_NORMAL) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String seed = (String)((Claims)jws.getBody()).get((Object)"seed");
        SeedAuthenticationToken authentication = new SeedAuthenticationToken(id, seed);
        authentication.setDetails((Object)new WebAuthenticationDetailsSource().buildDetails(request));
        SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
        HttpServletRequest effectiveRequest = isMultipart ? request : new RepeatableRequestWrapper(request);
        filterChain.doFilter((ServletRequest)effectiveRequest, (ServletResponse)response);
    }
}

