/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.config;

import com.dtstep.lighthouse.common.enums.RoleTypeEnum;
import com.dtstep.lighthouse.common.exception.PermissionException;
import com.dtstep.lighthouse.common.modal.Role;
import com.dtstep.lighthouse.common.util.JsonUtil;
import com.dtstep.lighthouse.common.util.StringUtil;
import com.dtstep.lighthouse.insights.config.CallerKeyAuthenticationToken;
import com.dtstep.lighthouse.insights.config.SeedAuthenticationToken;
import com.dtstep.lighthouse.insights.controller.annotation.AuthPermission;
import com.dtstep.lighthouse.insights.service.PermissionService;
import com.dtstep.lighthouse.insights.service.RoleService;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;

@Component
public class PermissionInterceptor
implements HandlerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(PermissionInterceptor.class);
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private RoleService roleService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        HandlerMethod handlerMethod;
        Method method;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        logger.info("Request URI:" + request.getRequestURI());
        if (handler instanceof ResourceHttpRequestHandler) {
            return true;
        }
        if (handler instanceof HandlerMethod && (authentication instanceof CallerKeyAuthenticationToken || authentication instanceof SeedAuthenticationToken) && (method = (handlerMethod = (HandlerMethod)handler).getMethod()).isAnnotationPresent(AuthPermission.class)) {
            AuthPermission[] authPermissions;
            boolean flag = false;
            for (AuthPermission authPermission : authPermissions = (AuthPermission[])method.getDeclaredAnnotationsByType(AuthPermission.class)) {
                if (!this.hasPermission(authPermission, request)) continue;
                flag = true;
                break;
            }
            if (!flag) {
                throw new PermissionException();
            }
        }
        return true;
    }

    private boolean hasPermission(AuthPermission authPermission, HttpServletRequest request) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        RoleTypeEnum roleTypeEnum = authPermission.roleTypeEnum();
        if (authentication.getClass() == SeedAuthenticationToken.class) {
            int id;
            Integer userId = ((SeedAuthenticationToken)authentication).getUserId();
            Role role = null;
            if (roleTypeEnum == RoleTypeEnum.OPT_MANAGE_PERMISSION) {
                role = this.roleService.cacheQueryRole(roleTypeEnum, Integer.valueOf(0));
            } else if (roleTypeEnum == RoleTypeEnum.FULL_MANAGE_PERMISSION) {
                role = this.roleService.cacheQueryRole(roleTypeEnum, Integer.valueOf(0));
            } else if ((roleTypeEnum == RoleTypeEnum.PROJECT_MANAGE_PERMISSION || roleTypeEnum == RoleTypeEnum.GROUP_MANAGE_PERMISSION || roleTypeEnum == RoleTypeEnum.STAT_MANAGE_PERMISSION || roleTypeEnum == RoleTypeEnum.METRIC_MANAGE_PERMISSION || roleTypeEnum == RoleTypeEnum.VIEW_MANAGE_PERMISSION || roleTypeEnum == RoleTypeEnum.CALLER_MANAGER_PERMISSION) && (id = this.getRelateParam(request, authPermission.relationParam())) != 0) {
                role = this.roleService.cacheQueryRole(roleTypeEnum, Integer.valueOf(id));
            }
            Validate.notNull((Object)role);
            return this.permissionService.checkUserPermission(userId, role.getId());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getRelateParam(HttpServletRequest request, String relateParam) {
        int id = 0;
        ServletInputStream inputStream = null;
        try {
            inputStream = request.getInputStream();
            String requestBody = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            if (StringUtil.isNotEmpty((String)requestBody)) {
                JsonNode objectNode = JsonUtil.readTree((String)requestBody);
                int n = id = objectNode.get(relateParam).asInt();
                return n;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return id;
    }
}

