/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.config;

import com.dtstep.lighthouse.insights.config.AuthenticationTokenFilter;
import com.dtstep.lighthouse.insights.config.DefaultAccessDeniedHandler;
import com.dtstep.lighthouse.insights.config.DefaultAuthenticationProvider;
import com.dtstep.lighthouse.insights.config.DefaultUnauthorizedHandler;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.configuration.AuthenticationConfiguration;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
public class SecurityConfig {
    @Autowired
    private DefaultUnauthorizedHandler defaultUnauthorizedHandler;
    @Autowired
    private DefaultAccessDeniedHandler defaultAccessDeniedHandler;
    @Autowired
    private AuthenticationTokenFilter authenticationTokenFilter;

    @Bean
    public AuthenticationManager authenticationManager(AuthenticationConfiguration authConfig) throws Exception {
        return authConfig.getAuthenticationManager();
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    public DefaultAuthenticationProvider authenticationProvider() {
        return new DefaultAuthenticationProvider();
    }

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity httpSecurity) throws Exception {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)httpSecurity.csrf().disable()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).authorizeRequests().antMatchers(new String[]{"/license", "/user/login", "/user/register", "/department/structure", "/refreshKey"})).permitAll().antMatchers(HttpMethod.OPTIONS)).permitAll().anyRequest()).authenticated();
        httpSecurity.headers().cacheControl();
        httpSecurity.authenticationProvider((AuthenticationProvider)this.authenticationProvider());
        httpSecurity.addFilterBefore((Filter)this.authenticationTokenFilter, UsernamePasswordAuthenticationFilter.class);
        httpSecurity.exceptionHandling().accessDeniedHandler((AccessDeniedHandler)this.defaultAccessDeniedHandler).authenticationEntryPoint((AuthenticationEntryPoint)this.defaultUnauthorizedHandler);
        return (SecurityFilterChain)httpSecurity.build();
    }
}

