/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.config;

import com.dtstep.lighthouse.insights.config.LocalDateTimeSerdeConfig;
import com.dtstep.lighthouse.insights.config.PermissionInterceptor;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.DefaultServletHandlerConfigurer;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@EnableWebMvc
public class WebConfig
implements WebMvcConfigurer {
    @Autowired
    private PermissionInterceptor permissionInterceptor;

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.permissionInterceptor);
    }

    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**").allowedOrigins(new String[]{"*"}).allowedMethods(new String[]{"GET", "POST", "PUT", "DELETE"}).maxAge(3600L);
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/**"}).addResourceLocations(new String[]{"classpath:/static"});
    }

    public void configureDefaultServletHandling(DefaultServletHandlerConfigurer configurer) {
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, true);
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerdeConfig.LocalDateTimeToEpochSerializer());
        simpleModule.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateTimeSerdeConfig.LocalDateToEpochSerializer());
        simpleModule.addSerializer(LocalTime.class, (JsonSerializer)new LocalDateTimeSerdeConfig.LocalTimeToEpochSerializer());
        simpleModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeSerdeConfig.LocalDateTimeFromEpochDeserializer());
        simpleModule.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateTimeSerdeConfig.LocalDateFromEpochDeserializer());
        simpleModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerdeConfig.LocalDateTimeToEpochSerializer());
        simpleModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeSerdeConfig.LocalDateTimeFromEpochDeserializer());
        simpleModule.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalDateTimeSerdeConfig.LocalTimeFromEpochDeserializer());
        objectMapper.registerModule((Module)simpleModule);
        converters.add((HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter(objectMapper));
    }
}

