/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.controller;

import com.dtstep.lighthouse.common.entity.ListData;
import com.dtstep.lighthouse.common.entity.ResultCode;
import com.dtstep.lighthouse.common.entity.ServiceResult;
import com.dtstep.lighthouse.common.enums.CallerStateEnum;
import com.dtstep.lighthouse.common.enums.RoleTypeEnum;
import com.dtstep.lighthouse.common.modal.Caller;
import com.dtstep.lighthouse.common.modal.CallerQueryParam;
import com.dtstep.lighthouse.common.modal.IDParam;
import com.dtstep.lighthouse.common.modal.ListSearchObject;
import com.dtstep.lighthouse.common.modal.Pagination;
import com.dtstep.lighthouse.insights.controller.annotation.AuthPermission;
import com.dtstep.lighthouse.insights.dto.CallerCreateParam;
import com.dtstep.lighthouse.insights.dto.CallerUpdateParam;
import com.dtstep.lighthouse.insights.dto.ChangeCallerStateParam;
import com.dtstep.lighthouse.insights.dto.PermissionGrantParam;
import com.dtstep.lighthouse.insights.dto.PermissionReleaseParam;
import com.dtstep.lighthouse.insights.service.BaseService;
import com.dtstep.lighthouse.insights.service.CallerService;
import com.dtstep.lighthouse.insights.vo.CallerVO;
import com.dtstep.lighthouse.insights.vo.ResultData;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ControllerAdvice
public class CallerController {
    private static final Logger logger = LoggerFactory.getLogger(CallerController.class);
    @Autowired
    private CallerService callerService;
    @Autowired
    private BaseService baseService;

    @RequestMapping(value={"/caller/create"})
    public ResultData<Integer> createView(@Validated @RequestBody CallerCreateParam createParam) throws Exception {
        Caller caller = new Caller();
        caller.setName(createParam.getName());
        caller.setDesc(createParam.getDesc());
        caller.setDepartmentId(createParam.getDepartmentId());
        ServiceResult serviceResult = this.callerService.create(caller);
        return ResultData.result((ResultCode)serviceResult.getResultCode());
    }

    @AuthPermission(roleTypeEnum=RoleTypeEnum.CALLER_MANAGER_PERMISSION, relationParam="id")
    @RequestMapping(value={"/caller/update"})
    public ResultData<Integer> update(@Validated @RequestBody CallerUpdateParam updateParam) throws Exception {
        Integer id = updateParam.getId();
        CallerVO caller = this.callerService.queryById(id);
        Validate.notNull((Object)caller);
        caller.setName(updateParam.getName());
        caller.setDesc(updateParam.getDesc());
        int result = this.callerService.update((Caller)caller);
        if (result > 0) {
            return ResultData.success((Object)result);
        }
        return ResultData.result((ResultCode)ResultCode.systemError);
    }

    @RequestMapping(value={"/caller/queryById"})
    public ResultData<CallerVO> queryById(@Validated @RequestBody IDParam idParam) throws Exception {
        Integer id = idParam.getId();
        CallerVO caller = this.callerService.queryById(id);
        if (caller == null) {
            return ResultData.result((ResultCode)ResultCode.elementNotFound);
        }
        return ResultData.success((Object)caller);
    }

    @RequestMapping(value={"/caller/list"})
    public ResultData<ListData<CallerVO>> list(@Validated @RequestBody ListSearchObject<CallerQueryParam> searchObject) throws Exception {
        CallerQueryParam queryParam = (CallerQueryParam)searchObject.getQueryParamOrDefault((Object)new CallerQueryParam());
        Pagination pagination = searchObject.getPagination();
        ListData listData = this.callerService.queryList(queryParam, Integer.valueOf(pagination.getPageNum()), Integer.valueOf(pagination.getPageSize()));
        return ResultData.success((Object)listData);
    }

    @AuthPermission(roleTypeEnum=RoleTypeEnum.CALLER_MANAGER_PERMISSION, relationParam="id")
    @RequestMapping(value={"/caller/deleteById"})
    public ResultData<Integer> deleteById(@Validated @RequestBody IDParam idParam) throws Exception {
        Integer id = idParam.getId();
        this.callerService.deleteById(id);
        return ResultData.success();
    }

    @AuthPermission(roleTypeEnum=RoleTypeEnum.CALLER_MANAGER_PERMISSION, relationParam="id")
    @RequestMapping(value={"/caller/getSecretKey"})
    public ResultData<String> getSecretKey(@Validated @RequestBody IDParam idParam) throws Exception {
        Integer id = idParam.getId();
        String secretKey = this.callerService.getSecretKey(id);
        return ResultData.success((Object)secretKey);
    }

    @AuthPermission(roleTypeEnum=RoleTypeEnum.CALLER_MANAGER_PERMISSION, relationParam="resourceId")
    @RequestMapping(value={"/caller/grant"})
    public ResultData<Integer> grant(@Validated @RequestBody PermissionGrantParam grantParam) throws Exception {
        ResultCode resultCode = this.callerService.batchGrantPermissions(grantParam);
        return ResultData.result((ResultCode)resultCode);
    }

    @AuthPermission(roleTypeEnum=RoleTypeEnum.CALLER_MANAGER_PERMISSION, relationParam="resourceId")
    @RequestMapping(value={"/caller/release"})
    public ResultData<Integer> release(@Validated @RequestBody PermissionReleaseParam releaseParam) throws Exception {
        ResultCode resultCode = this.callerService.releasePermission(releaseParam);
        return ResultData.result((ResultCode)resultCode);
    }

    @AuthPermission(roleTypeEnum=RoleTypeEnum.OPT_MANAGE_PERMISSION)
    @RequestMapping(value={"/caller/changeState"})
    public ResultData<Integer> changeState(@Validated @RequestBody ChangeCallerStateParam changeParam) throws Exception {
        Integer id = changeParam.getId();
        CallerStateEnum callerStateEnum = changeParam.getState();
        Validate.notNull((Object)id);
        Validate.notNull((Object)callerStateEnum);
        CallerVO dbCaller = this.callerService.queryById(id);
        Validate.notNull((Object)dbCaller);
        Caller caller = new Caller();
        caller.setState(callerStateEnum);
        caller.setId(id);
        int result = this.callerService.update(caller);
        if (id > 0) {
            return ResultData.success((Object)id);
        }
        return ResultData.result((ResultCode)ResultCode.systemError);
    }
}

