/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.controller;

import com.dtstep.lighthouse.common.entity.Owner;
import com.dtstep.lighthouse.common.entity.ResultCode;
import com.dtstep.lighthouse.common.entity.ServiceResult;
import com.dtstep.lighthouse.common.entity.stat.StatExtEntity;
import com.dtstep.lighthouse.common.enums.PrivateTypeEnum;
import com.dtstep.lighthouse.common.enums.RoleTypeEnum;
import com.dtstep.lighthouse.common.modal.LimitDataObject;
import com.dtstep.lighthouse.common.modal.Role;
import com.dtstep.lighthouse.common.modal.StatDataObject;
import com.dtstep.lighthouse.core.batch.BatchAdapter;
import com.dtstep.lighthouse.core.builtin.BuiltinLoader;
import com.dtstep.lighthouse.insights.config.SoftEdition;
import com.dtstep.lighthouse.insights.dto.DataStatQueryParam;
import com.dtstep.lighthouse.insights.dto.LimitStatQueryParam;
import com.dtstep.lighthouse.insights.service.BaseService;
import com.dtstep.lighthouse.insights.service.DataService;
import com.dtstep.lighthouse.insights.service.PermissionService;
import com.dtstep.lighthouse.insights.service.RoleService;
import com.dtstep.lighthouse.insights.service.StatService;
import com.dtstep.lighthouse.insights.vo.ResultData;
import com.dtstep.lighthouse.insights.vo.StatVO;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ControllerAdvice
public class DataController {
    @Autowired
    private DataService dataService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private BaseService baseService;
    @Autowired
    private StatService statService;
    @Autowired
    private SoftEdition softEdition;

    @RequestMapping(value={"/data/stat"})
    public ResultData<List<StatDataObject>> dataQuery(@Validated @RequestBody DataStatQueryParam queryParam) throws Exception {
        Role accessRole;
        boolean hasAccessPermission;
        Role manageRole;
        Owner owner;
        boolean hasManagePermission;
        int statId = queryParam.getStatId();
        StatVO stat = this.statService.queryById(Integer.valueOf(statId));
        Validate.notNull((Object)stat);
        if (this.softEdition.isPro() && !BuiltinLoader.isBuiltinStat((int)statId) && stat.getPrivateType() == PrivateTypeEnum.Private && !(hasManagePermission = this.permissionService.checkOwnerPermission(owner = this.baseService.getCurrentOwner(), (manageRole = this.roleService.queryRole(RoleTypeEnum.STAT_MANAGE_PERMISSION, Integer.valueOf(statId))).getId())) && !(hasAccessPermission = this.permissionService.checkOwnerPermission(owner, (accessRole = this.roleService.queryRole(RoleTypeEnum.STAT_ACCESS_PERMISSION, Integer.valueOf(statId))).getId()))) {
            return ResultData.result((ResultCode)ResultCode.accessDenied);
        }
        List dimensList = this.dataService.dimensArrangement((StatExtEntity)stat, queryParam.getDimensParams());
        if (stat.getTemplateEntity().getDimensArray().length > 0 && CollectionUtils.isEmpty((Collection)dimensList)) {
            return ResultData.result((ResultCode)ResultCode.dataQueryMissingDimensParams);
        }
        ServiceResult serviceResult = this.dataService.dataQuery((StatExtEntity)stat, queryParam.getStartTime(), queryParam.getEndTime(), dimensList);
        if (serviceResult.isSuccess()) {
            return ResultData.success((Object)((List)serviceResult.getData()));
        }
        return ResultData.result((ResultCode)serviceResult.getResultCode());
    }

    @RequestMapping(value={"/data/limit"})
    public ResultData<List<LimitDataObject>> limitQuery(@Validated @RequestBody LimitStatQueryParam queryParam) throws Exception {
        Role accessRole;
        boolean hasAccessPermission;
        Role manageRole;
        Owner owner;
        boolean hasManagePermission;
        int statId = queryParam.getStatId();
        StatVO stat = this.statService.queryById(Integer.valueOf(statId));
        Validate.notNull((Object)stat);
        if (this.softEdition.isPro() && !BuiltinLoader.isBuiltinStat((int)statId) && stat.getPrivateType() == PrivateTypeEnum.Private && !(hasManagePermission = this.permissionService.checkOwnerPermission(owner = this.baseService.getCurrentOwner(), (manageRole = this.roleService.queryRole(RoleTypeEnum.STAT_MANAGE_PERMISSION, Integer.valueOf(statId))).getId())) && !(hasAccessPermission = this.permissionService.checkOwnerPermission(owner, (accessRole = this.roleService.queryRole(RoleTypeEnum.STAT_ACCESS_PERMISSION, Integer.valueOf(statId))).getId()))) {
            return ResultData.result((ResultCode)ResultCode.accessDenied);
        }
        List batchTimeList = queryParam.getBatchTimeList();
        if (CollectionUtils.isEmpty((Collection)batchTimeList)) {
            batchTimeList = BatchAdapter.queryBatchTimeList((String)stat.getTimeparam(), (long)0L, (long)System.currentTimeMillis(), (int)10);
        }
        List objectList = this.dataService.limitQuery((StatExtEntity)stat, batchTimeList);
        return ResultData.success((Object)objectList);
    }
}

