/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.controller;

import com.dtstep.lighthouse.common.entity.ResultCode;
import com.dtstep.lighthouse.common.exception.AuthorizeException;
import com.dtstep.lighthouse.common.exception.PermissionException;
import com.dtstep.lighthouse.insights.vo.ResultData;
import javax.servlet.http.HttpServletRequest;
import javax.validation.UnexpectedTypeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class DefaultExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultExceptionHandler.class);

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseBody
    public Object globalErrorHandler(HttpServletRequest request, MethodArgumentNotValidException e) {
        logger.error("globalErrorHandler", (Throwable)e);
        return ResultData.result((ResultCode)ResultCode.paramValidateFailed);
    }

    @ExceptionHandler(value={PermissionException.class})
    @ResponseBody
    public Object globalPermissionExceptionHandler(HttpServletRequest request, PermissionException e) {
        return ResultData.result((ResultCode)ResultCode.accessDenied);
    }

    @ExceptionHandler(value={AuthorizeException.class})
    @ResponseBody
    public Object globalAuthorizeExceptionHandler(HttpServletRequest request, AuthorizeException e) {
        logger.warn("System is not authorized!");
        return ResultData.result((ResultCode)ResultCode.systemUnauthorized);
    }

    @ExceptionHandler(value={UnexpectedTypeException.class})
    @ResponseBody
    public Object globalErrorHandler(HttpServletRequest request, UnexpectedTypeException e) {
        logger.error("globalErrorHandler", (Throwable)e);
        return ResultData.result((ResultCode)ResultCode.paramValidateFailed);
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseBody
    public Object globalHttpRequestMethodNotSupportedErrorHandler(HttpServletRequest request, HttpRequestMethodNotSupportedException e) {
        logger.error("HttpRequest Method Not Supported!", (Throwable)e);
        String method = e.getMethod();
        return ResultData.result((ResultCode)ResultCode.methodNotAllowed, (Object[])new Object[]{method});
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public Object handleException(Exception ex) {
        logger.error("System Error!", (Throwable)ex);
        return ResultData.result((ResultCode)ResultCode.systemError);
    }
}

