/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.controller;

import com.dtstep.lighthouse.common.entity.ListData;
import com.dtstep.lighthouse.common.entity.ResultCode;
import com.dtstep.lighthouse.common.entity.ServiceResult;
import com.dtstep.lighthouse.common.enums.RoleTypeEnum;
import com.dtstep.lighthouse.common.modal.IDParam;
import com.dtstep.lighthouse.common.modal.ListSearchObject;
import com.dtstep.lighthouse.common.modal.Pagination;
import com.dtstep.lighthouse.common.modal.Project;
import com.dtstep.lighthouse.common.modal.TreeNode;
import com.dtstep.lighthouse.insights.controller.annotation.AuthPermission;
import com.dtstep.lighthouse.insights.dto.PermissionGrantParam;
import com.dtstep.lighthouse.insights.dto.PermissionReleaseParam;
import com.dtstep.lighthouse.insights.dto.ProjectCreateParam;
import com.dtstep.lighthouse.insights.dto.ProjectQueryParam;
import com.dtstep.lighthouse.insights.dto.QueryParam;
import com.dtstep.lighthouse.insights.service.GroupService;
import com.dtstep.lighthouse.insights.service.ProjectService;
import com.dtstep.lighthouse.insights.vo.ProjectVO;
import com.dtstep.lighthouse.insights.vo.ResultData;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ControllerAdvice
public class ProjectController {
    private static final Logger logger = LoggerFactory.getLogger(ProjectController.class);
    @Autowired
    private ProjectService projectService;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private GroupService groupService;

    @RequestMapping(value={"/project/create"})
    public ResultData<Integer> create(@Validated @RequestBody ProjectCreateParam createParam) throws Exception {
        Project project = new Project();
        project.setTitle(createParam.getTitle());
        project.setDepartmentId(createParam.getDepartmentId());
        project.setPrivateType(createParam.getPrivateType());
        project.setDesc(createParam.getDesc());
        ServiceResult createResult = this.projectService.create(project);
        if (!createResult.isSuccess()) {
            return ResultData.result((ResultCode)createResult.getResultCode());
        }
        int id = (Integer)createResult.getData();
        PermissionGrantParam grantParam = new PermissionGrantParam();
        grantParam.setResourceId(Integer.valueOf(id));
        grantParam.setRoleType(RoleTypeEnum.PROJECT_ACCESS_PERMISSION);
        grantParam.setUsersPermissions(createParam.getUsersPermission());
        grantParam.setDepartmentsPermissions(createParam.getDepartmentsPermission());
        this.projectService.batchGrantPermissions(grantParam);
        return ResultData.success((Object)id);
    }

    @RequestMapping(value={"/project/queryById"})
    public ResultData<ProjectVO> queryById(@RequestBody QueryParam queryParam) throws Exception {
        ProjectVO projectVO = this.projectService.queryById(queryParam.getId());
        if (projectVO == null) {
            return ResultData.result((ResultCode)ResultCode.elementNotFound);
        }
        TreeNode structure = this.projectService.getStructure((Project)projectVO);
        projectVO.setStructure(structure);
        return ResultData.success((Object)projectVO);
    }

    @PostMapping(value={"/project/list"})
    public ResultData<ListData<ProjectVO>> queryList(@Validated @RequestBody ListSearchObject<ProjectQueryParam> searchObject) {
        ProjectQueryParam queryParam = (ProjectQueryParam)searchObject.getQueryParamOrDefault((Object)new ProjectQueryParam());
        Pagination pagination = searchObject.getPagination();
        ListData listData = this.projectService.queryList(queryParam, Integer.valueOf(pagination.getPageNum()), Integer.valueOf(pagination.getPageSize()));
        return ResultData.success((Object)listData);
    }

    @AuthPermission(roleTypeEnum=RoleTypeEnum.PROJECT_MANAGE_PERMISSION, relationParam="id")
    @RequestMapping(value={"/project/updateById"})
    public ResultData<Integer> updateById(@Validated @RequestBody Project updateParam) {
        int id = this.projectService.update(updateParam);
        if (id > 0) {
            return ResultData.success((Object)id);
        }
        return ResultData.result((ResultCode)ResultCode.systemError);
    }

    @AuthPermission(roleTypeEnum=RoleTypeEnum.PROJECT_MANAGE_PERMISSION, relationParam="id")
    @RequestMapping(value={"/project/deleteById"})
    public ResultData<Integer> deleteById(@Validated @RequestBody IDParam idParam) {
        Integer id = idParam.getId();
        ServiceResult result = this.projectService.deleteById(id);
        return ResultData.result((ServiceResult)result);
    }

    @AuthPermission(roleTypeEnum=RoleTypeEnum.PROJECT_MANAGE_PERMISSION, relationParam="resourceId")
    @RequestMapping(value={"/project/grant"})
    public ResultData<Integer> grant(@Validated @RequestBody PermissionGrantParam grantParam) throws Exception {
        ResultCode resultCode = this.projectService.batchGrantPermissions(grantParam);
        return ResultData.result((ResultCode)resultCode);
    }

    @AuthPermission(roleTypeEnum=RoleTypeEnum.PROJECT_MANAGE_PERMISSION, relationParam="resourceId")
    @RequestMapping(value={"/project/release"})
    public ResultData<Integer> release(@Validated @RequestBody PermissionReleaseParam releaseParam) throws Exception {
        ResultCode resultCode = this.projectService.releasePermission(releaseParam);
        return ResultData.result((ResultCode)resultCode);
    }

    @RequestMapping(value={"/project/starById"})
    public ResultData<Integer> starById(@Validated @RequestBody IDParam idParam) {
        Integer id = idParam.getId();
        ProjectVO project = this.projectService.queryById(id);
        Validate.notNull((Object)project);
        ResultCode resultCode = this.projectService.star((Project)project);
        return ResultData.result((ResultCode)resultCode);
    }

    @RequestMapping(value={"/project/unStarById"})
    public ResultData<Integer> unStarById(@Validated @RequestBody IDParam idParam) {
        Integer id = idParam.getId();
        ProjectVO project = this.projectService.queryById(id);
        Validate.notNull((Object)project);
        ResultCode resultCode = this.projectService.unStar((Project)project);
        return ResultData.result((ResultCode)resultCode);
    }

    @RequestMapping(value={"/project/queryStarList"})
    public ResultData<List<ProjectVO>> queryStarList() {
        List list = this.projectService.queryStarList();
        return ResultData.success((Object)list);
    }
}

