/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.controller;

import com.dtstep.lighthouse.common.entity.ListData;
import com.dtstep.lighthouse.common.modal.IDParam;
import com.dtstep.lighthouse.common.modal.ListSearchObject;
import com.dtstep.lighthouse.common.modal.Record;
import com.dtstep.lighthouse.insights.dto.RecordQueryParam;
import com.dtstep.lighthouse.insights.service.RecordService;
import com.dtstep.lighthouse.insights.vo.ResultData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ControllerAdvice
public class RecordsController {
    @Autowired
    private RecordService recordService;

    @PostMapping(value={"/record/list"})
    public ResultData<ListData<Record>> queryList(@Validated @RequestBody ListSearchObject<RecordQueryParam> searchObject) {
        RecordQueryParam queryParam = (RecordQueryParam)searchObject.getQueryParamOrDefault((Object)new RecordQueryParam());
        Integer pageNum = searchObject.getPagination().getPageNum();
        Integer pageSize = searchObject.getPagination().getPageSize();
        ListData listData = this.recordService.queryList(queryParam, pageNum, pageSize);
        return ResultData.success((Object)listData);
    }

    @PostMapping(value={"/record/statLimitList"})
    public ResultData<ListData<Record>> queryStatLimitList(@Validated @RequestBody ListSearchObject<IDParam> searchObject) {
        IDParam idParam = (IDParam)searchObject.getQueryParams();
        Integer statId = idParam.getId();
        Integer pageNum = searchObject.getPagination().getPageNum();
        Integer pageSize = searchObject.getPagination().getPageSize();
        ListData listData = this.recordService.queryStatLimitList(statId, pageNum, pageSize);
        return ResultData.success((Object)listData);
    }
}

