/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.controller;

import com.dtstep.lighthouse.common.entity.ResultCode;
import com.dtstep.lighthouse.common.entity.ServiceResult;
import com.dtstep.lighthouse.common.entity.message.LightMessage;
import com.dtstep.lighthouse.common.entity.stat.TemplateEntity;
import com.dtstep.lighthouse.common.entity.state.StatState;
import com.dtstep.lighthouse.common.enums.RoleTypeEnum;
import com.dtstep.lighthouse.common.enums.SwitchStateEnum;
import com.dtstep.lighthouse.common.modal.DebugParam;
import com.dtstep.lighthouse.common.modal.Group;
import com.dtstep.lighthouse.common.modal.IDParam;
import com.dtstep.lighthouse.common.util.DateUtil;
import com.dtstep.lighthouse.common.util.JsonUtil;
import com.dtstep.lighthouse.core.expression.embed.AviatorHandler;
import com.dtstep.lighthouse.core.formula.FormulaCalculate;
import com.dtstep.lighthouse.core.preparing.handler.valid.MessageValid;
import com.dtstep.lighthouse.core.redis.RedisClient;
import com.dtstep.lighthouse.insights.controller.annotation.AuthPermission;
import com.dtstep.lighthouse.insights.dto.TrackParam;
import com.dtstep.lighthouse.insights.service.GroupService;
import com.dtstep.lighthouse.insights.service.StatService;
import com.dtstep.lighthouse.insights.vo.GroupVO;
import com.dtstep.lighthouse.insights.vo.ResultData;
import com.dtstep.lighthouse.insights.vo.StatVO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ControllerAdvice
public class TrackController {
    @Autowired
    private GroupService groupService;
    @Autowired
    private StatService statService;

    @AuthPermission(roleTypeEnum=RoleTypeEnum.GROUP_MANAGE_PERMISSION, relationParam="id")
    @PostMapping(value={"/track/enableDebugMode"})
    public ResultData<DebugParam> enableDebugMode(@Validated @RequestBody IDParam idParam) throws Exception {
        Integer id = idParam.getId();
        GroupVO groupVO = this.groupService.queryById(id);
        if (groupVO.getDebugMode() == SwitchStateEnum.OPEN && groupVO.getDebugParam().getEndTime() - System.currentTimeMillis() > TimeUnit.MINUTES.toMillis(10L)) {
            DebugParam debugPram = groupVO.getDebugParam();
            return ResultData.result((ServiceResult)ServiceResult.result((ResultCode)ResultCode.debugModeSwitchAlreadyTurnON, (Object)debugPram));
        }
        DebugParam debugPram = new DebugParam();
        long now = System.currentTimeMillis();
        debugPram.setStartTime(now);
        debugPram.setEndTime(DateUtil.getMinuteAfter((long)now, (int)30));
        groupVO.setDebugParam(debugPram);
        groupVO.setDebugMode(SwitchStateEnum.OPEN);
        groupVO.setRefreshTime(DateUtil.timestampToLocalDateTime((long)now));
        this.groupService.update((Group)groupVO);
        return ResultData.success((Object)debugPram);
    }

    @AuthPermission(roleTypeEnum=RoleTypeEnum.GROUP_MANAGE_PERMISSION, relationParam="id")
    @PostMapping(value={"/track/disableDebugMode"})
    public ResultData<Integer> disableDebugMode(@Validated @RequestBody IDParam idParam) throws Exception {
        Integer id = idParam.getId();
        GroupVO groupVO = this.groupService.queryById(id);
        groupVO.setDebugMode(SwitchStateEnum.CLOSE);
        groupVO.setRefreshTime(LocalDateTime.now());
        this.groupService.update((Group)groupVO);
        return ResultData.success();
    }

    @AuthPermission(roleTypeEnum=RoleTypeEnum.GROUP_MANAGE_PERMISSION, relationParam="groupId")
    @PostMapping(value={"/track/messages"})
    public ResultData<List<LinkedHashMap<String, Object>>> messages(@Validated @RequestBody TrackParam trackParam) throws Exception {
        Integer groupId = trackParam.getGroupId();
        Integer statId = trackParam.getStatId();
        GroupVO groupVO = this.groupService.queryById(groupId);
        Validate.notNull((Object)groupVO);
        if (groupVO.getDebugMode() == SwitchStateEnum.CLOSE) {
            return ResultData.result((ResultCode)ResultCode.trackDebugModeExpired);
        }
        DebugParam debugParam = groupVO.getDebugParam();
        String key = "group_track_" + groupId;
        ArrayList list = RedisClient.getInstance().lrange(key, 0, 500);
        if (list == null) {
            list = new ArrayList();
        }
        ArrayList resultList = new ArrayList();
        StatVO statExtEntity = this.statService.queryById(statId);
        Validate.notNull((Object)statExtEntity);
        TemplateEntity templateEntity = statExtEntity.getTemplateEntity();
        GroupVO group = this.groupService.queryById(statExtEntity.getGroupId());
        for (int i = 0; i < list.size(); ++i) {
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
            LightMessage message = (LightMessage)JsonUtil.toJavaObject((String)((String)list.get(i)), LightMessage.class);
            assert (message != null);
            long messageTime = message.getTime();
            if (messageTime > debugParam.getEndTime() || messageTime < debugParam.getStartTime()) continue;
            linkedHashMap.put("No", i + 1);
            linkedHashMap.put("messageTime", messageTime);
            linkedHashMap.put("processTime", message.getSystemTime());
            long batchTime = DateUtil.batchTime((int)statExtEntity.getTimeParamInterval(), (TimeUnit)statExtEntity.getTimeUnit(), (long)messageTime);
            linkedHashMap.put("batchTime", batchTime);
            Map paramMap = message.getParamMap();
            Set relatedColumns = statExtEntity.getRelatedColumnSet();
            for (String dimens : relatedColumns) {
                linkedHashMap.put(dimens, paramMap.get(dimens));
            }
            linkedHashMap.put("repeat", message.getRepeat());
            String params = paramMap.entrySet().stream().map(z -> (String)z.getKey() + " = " + (String)z.getValue()).collect(Collectors.joining(";"));
            linkedHashMap.put("params", params);
            boolean valid = MessageValid.valid((int)group.getId(), (LightMessage)message, (List)group.getColumns());
            linkedHashMap.put("valid", String.valueOf(valid));
            if (valid) {
                List statStates = templateEntity.getStatStateList();
                HashMap envMap = new HashMap(message.getParamMap());
                String formula = templateEntity.getCompleteStat();
                boolean isNil = false;
                for (StatState statState : statStates) {
                    long result = FormulaCalculate.calculate((StatState)statState, envMap, (long)batchTime);
                    if (result == 999999999999999997L || result == 999999999999999998L) {
                        isNil = true;
                        linkedHashMap.put(statState.getStateBody(), "Nil");
                        continue;
                    }
                    BigDecimal stateValue = BigDecimal.valueOf(result).divide(BigDecimal.valueOf(1000.0), 3, RoundingMode.HALF_UP).stripTrailingZeros();
                    linkedHashMap.put(statState.getStateBody(), stateValue.toPlainString());
                    formula = formula.replace(statState.getStateBody(), stateValue.toPlainString());
                }
                if (isNil) {
                    linkedHashMap.put("result", "Nil");
                } else {
                    Object statValue = AviatorHandler.execute((String)formula);
                    if (statValue != null) {
                        if (statValue.getClass() == BigDecimal.class) {
                            BigDecimal bigDecimal = ((BigDecimal)statValue).stripTrailingZeros();
                            linkedHashMap.put("result", bigDecimal.toPlainString());
                        } else {
                            linkedHashMap.put("result", new BigDecimal(statValue.toString()).setScale(3, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString());
                        }
                    }
                }
            } else {
                linkedHashMap.put("result", "Invalid");
            }
            resultList.add(linkedHashMap);
        }
        return ResultData.success(resultList);
    }
}

