/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.init;

import com.dtstep.lighthouse.insights.service.InitService;
import com.dtstep.lighthouse.insights.service.SystemEnvService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;

@Configuration
@ComponentScan(value={"com.dtstep.lighthouse"})
public class InitialListener
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(InitialListener.class);
    @Autowired
    private SystemEnvService systemEnvService;
    @Autowired
    private InitService initService;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        try {
            this.systemEnvService.generateSignKeyIfNotExist();
        }
        catch (Exception ex) {
            logger.error("failed to generate sign key!", (Throwable)ex);
            System.exit(-1);
        }
        try {
            this.initService.initRole();
        }
        catch (Exception ex) {
            logger.error("Exception in initializing system roles!", (Throwable)ex);
            System.exit(-1);
        }
        try {
            this.initService.initDefaultDomain();
        }
        catch (Exception ex) {
            logger.error("Exception in initialization default domain info!", (Throwable)ex);
            System.exit(-1);
        }
        try {
            this.initService.initDepartment();
        }
        catch (Exception ex) {
            logger.error("Exception in initializing department info!", (Throwable)ex);
            System.exit(-1);
        }
        try {
            this.initService.initAdmin();
        }
        catch (Exception ex) {
            logger.error("Admin account initialization failed!", (Throwable)ex);
            System.exit(-1);
        }
        try {
            this.initService.initStorageEngine();
        }
        catch (Exception ex) {
            logger.error("Storage database initialization failed!", (Throwable)ex);
            System.exit(-1);
        }
        try {
            this.initService.createCMDBTablesIfNotExist();
            this.initService.createCMDBColumnsIfNotExist();
            this.initService.createCMDBIndexIfNotExist();
        }
        catch (Exception ex) {
            logger.error("CMDB database upgrade failed!", (Throwable)ex);
            System.exit(-1);
        }
        logger.info("service init success!");
    }
}

