/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.service.impl;

import com.dtstep.lighthouse.common.enums.ResourceTypeEnum;
import com.dtstep.lighthouse.common.modal.Domain;
import com.dtstep.lighthouse.common.modal.ResourceDto;
import com.dtstep.lighthouse.insights.dao.DomainDao;
import com.dtstep.lighthouse.insights.service.DomainService;
import com.dtstep.lighthouse.insights.service.ResourceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class DomainServiceImpl
implements DomainService {
    @Autowired
    private DomainDao domainDao;
    @Autowired
    private ResourceService resourceService;

    public int create(Domain domain) {
        this.domainDao.insert(domain);
        int id = domain.getId();
        this.resourceService.addResourceCallback(ResourceDto.newResource((ResourceTypeEnum)ResourceTypeEnum.Domain, (Integer)id, (ResourceTypeEnum)ResourceTypeEnum.System, (Integer)0));
        return id;
    }

    @Cacheable(value={"NormalPeriod"}, key="#targetClass + '_' + 'queryById' + '_' + #id", cacheManager="caffeineCacheManager", unless="#result == null")
    public Domain queryById(Integer id) {
        return this.domainDao.queryById(id);
    }

    @Cacheable(value={"NormalPeriod"}, key="#targetClass + '_' + 'queryDefault'", cacheManager="caffeineCacheManager", unless="#result == null")
    public Domain queryDefault() {
        return this.domainDao.queryDefault();
    }
}

