/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.service.impl;

import com.dtstep.lighthouse.common.entity.view.StatValue;
import com.dtstep.lighthouse.common.enums.UserStateEnum;
import com.dtstep.lighthouse.common.modal.DBStatistics;
import com.dtstep.lighthouse.common.modal.Department;
import com.dtstep.lighthouse.common.util.DateUtil;
import com.dtstep.lighthouse.insights.dto.MetricSetQueryParam;
import com.dtstep.lighthouse.insights.dto.ProjectQueryParam;
import com.dtstep.lighthouse.insights.dto.StatQueryParam;
import com.dtstep.lighthouse.insights.dto.UserQueryParam;
import com.dtstep.lighthouse.insights.service.DepartmentService;
import com.dtstep.lighthouse.insights.service.HomePageService;
import com.dtstep.lighthouse.insights.service.MetricSetService;
import com.dtstep.lighthouse.insights.service.OrderService;
import com.dtstep.lighthouse.insights.service.ProjectService;
import com.dtstep.lighthouse.insights.service.StatService;
import com.dtstep.lighthouse.insights.service.UserService;
import com.dtstep.lighthouse.insights.vo.HomeVO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class HomePageServiceImpl
implements HomePageService {
    @Autowired
    private ProjectService projectService;
    @Autowired
    private StatService statService;
    @Autowired
    private MetricSetService metricSetService;
    @Autowired
    private UserService userService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private DepartmentService departmentService;

    @Cacheable(value={"NormalPeriod"}, key="#targetClass + '_' + 'queryOverview'", cacheManager="caffeineCacheManager", unless="#result == null")
    public HomeVO queryOverview() {
        ProjectQueryParam totalProjectQueryParam = new ProjectQueryParam();
        int projectCount = this.projectService.count(totalProjectQueryParam);
        long timestamp = DateUtil.getDayBefore((long)System.currentTimeMillis(), (int)1);
        long ytdStartTime = DateUtil.getDayStartTime((long)timestamp);
        long ytdEndTime = DateUtil.getDayEndTime((long)timestamp);
        ProjectQueryParam ytdProjectQueryParam = new ProjectQueryParam();
        ytdProjectQueryParam.setCreateStartTime(DateUtil.timestampToLocalDateTime((long)ytdStartTime));
        ytdProjectQueryParam.setCreateEndTime(DateUtil.timestampToLocalDateTime((long)ytdEndTime));
        int ytdProjectCount = this.projectService.count(ytdProjectQueryParam);
        StatQueryParam totalStatQueryParam = new StatQueryParam();
        int statCount = this.statService.count(totalStatQueryParam);
        StatQueryParam ytdStatQueryParam = new StatQueryParam();
        ytdStatQueryParam.setCreateStartTime(DateUtil.timestampToLocalDateTime((long)ytdStartTime));
        ytdStatQueryParam.setCreateEndTime(DateUtil.timestampToLocalDateTime((long)ytdEndTime));
        int ytdStatCount = this.statService.count(ytdStatQueryParam);
        MetricSetQueryParam totalMetricQueryParam = new MetricSetQueryParam();
        int metricCount = this.metricSetService.count(totalMetricQueryParam);
        MetricSetQueryParam ytdMetricQueryParam = new MetricSetQueryParam();
        ytdMetricQueryParam.setCreateStartTime(DateUtil.timestampToLocalDateTime((long)ytdStartTime));
        ytdMetricQueryParam.setCreateEndTime(DateUtil.timestampToLocalDateTime((long)ytdEndTime));
        int ytdMetricCount = this.metricSetService.count(ytdMetricQueryParam);
        UserQueryParam userQueryParam = new UserQueryParam();
        userQueryParam.setStates(List.of(Integer.valueOf(UserStateEnum.USER_NORMAL.getState())));
        int userCount = this.userService.count(userQueryParam);
        List statistics = this.statService.getTopDepartmentStatSize();
        ArrayList<StatValue> valueList = new ArrayList<StatValue>();
        List allDepartments = this.departmentService.queryAll();
        Map<Integer, Department> departmentMap = allDepartments.stream().collect(Collectors.toMap(Department::getId, x -> x));
        for (DBStatistics dbStatistics : statistics) {
            if (dbStatistics.getK() == null) continue;
            int departmentId = dbStatistics.getK();
            int count = dbStatistics.getV();
            StatValue statValue = new StatValue();
            Department department = departmentMap.getOrDefault(departmentId, null);
            if (department == null) continue;
            statValue.setDimensValue(department.getName());
            statValue.setValue((Object)count);
            valueList.add(statValue);
        }
        HomeVO homeVO = new HomeVO();
        homeVO.setProjectCount(Integer.valueOf(projectCount));
        homeVO.setYtdProjectCount(Integer.valueOf(ytdProjectCount));
        homeVO.setStatCount(Integer.valueOf(statCount));
        homeVO.setYtdStatCount(Integer.valueOf(ytdStatCount));
        homeVO.setMetricCount(Integer.valueOf(metricCount));
        homeVO.setYtdMetricCount(Integer.valueOf(ytdMetricCount));
        homeVO.setUserCount(Integer.valueOf(userCount));
        homeVO.setDepartmentStatCount(valueList);
        return homeVO;
    }
}

