/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.service.impl;

import com.dtstep.lighthouse.common.enums.OwnerTypeEnum;
import com.dtstep.lighthouse.common.enums.RoleTypeEnum;
import com.dtstep.lighthouse.common.modal.Department;
import com.dtstep.lighthouse.common.modal.Domain;
import com.dtstep.lighthouse.common.modal.Role;
import com.dtstep.lighthouse.common.modal.User;
import com.dtstep.lighthouse.common.random.RandomID;
import com.dtstep.lighthouse.common.util.Md5Util;
import com.dtstep.lighthouse.core.storage.cmdb.CMDBStorageEngine;
import com.dtstep.lighthouse.core.storage.cmdb.CMDBStorageEngineProxy;
import com.dtstep.lighthouse.core.storage.warehouse.WarehouseStorageEngine;
import com.dtstep.lighthouse.core.storage.warehouse.WarehouseStorageEngineProxy;
import com.dtstep.lighthouse.core.tools.CMDBUtil;
import com.dtstep.lighthouse.insights.service.DepartmentService;
import com.dtstep.lighthouse.insights.service.DomainService;
import com.dtstep.lighthouse.insights.service.InitService;
import com.dtstep.lighthouse.insights.service.PermissionService;
import com.dtstep.lighthouse.insights.service.ResourceService;
import com.dtstep.lighthouse.insights.service.RoleService;
import com.dtstep.lighthouse.insights.service.UserService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InitServiceImpl
implements InitService {
    private static final Logger logger = LoggerFactory.getLogger(InitServiceImpl.class);
    @Autowired
    private UserService userService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private DomainService domainService;

    @Transactional
    public void initRole() {
        int result;
        Role parentRole;
        int result2;
        if (!this.roleService.isRoleExist(RoleTypeEnum.FULL_MANAGE_PERMISSION, Integer.valueOf(0))) {
            Role fullManageRole = new Role(RoleTypeEnum.FULL_MANAGE_PERMISSION, Integer.valueOf(0));
            result2 = this.roleService.create(fullManageRole);
            Validate.isTrue((result2 > 0 ? 1 : 0) != 0);
        }
        if (!this.roleService.isRoleExist(RoleTypeEnum.FULL_ACCESS_PERMISSION, Integer.valueOf(0))) {
            Role fullAccessRole = new Role(RoleTypeEnum.FULL_ACCESS_PERMISSION, Integer.valueOf(0));
            result2 = this.roleService.create(fullAccessRole);
            Validate.isTrue((result2 > 0 ? 1 : 0) != 0);
        }
        if (!this.roleService.isRoleExist(RoleTypeEnum.OPT_MANAGE_PERMISSION, Integer.valueOf(0))) {
            parentRole = this.roleService.cacheQueryRole(RoleTypeEnum.FULL_MANAGE_PERMISSION, Integer.valueOf(0));
            Role optManageRole = new Role(RoleTypeEnum.OPT_MANAGE_PERMISSION, Integer.valueOf(0), parentRole.getId());
            result = this.roleService.create(optManageRole);
            Validate.isTrue((result > 0 ? 1 : 0) != 0);
        }
        if (!this.roleService.isRoleExist(RoleTypeEnum.OPT_ACCESS_PERMISSION, Integer.valueOf(0))) {
            parentRole = this.roleService.cacheQueryRole(RoleTypeEnum.FULL_ACCESS_PERMISSION, Integer.valueOf(0));
            Role optAccessRole = new Role(RoleTypeEnum.OPT_ACCESS_PERMISSION, Integer.valueOf(0), parentRole.getId());
            result = this.roleService.create(optAccessRole);
            Validate.isTrue((result > 0 ? 1 : 0) != 0);
        }
    }

    @Transactional
    public void initDepartment() {
        int level = this.departmentService.getChildLevel(Integer.valueOf(0));
        if (level == 0) {
            Department department = new Department();
            department.setName("First Department");
            department.setPid(Integer.valueOf(0));
            int result = this.departmentService.create(department);
            Validate.isTrue((result > 0 ? 1 : 0) != 0);
        }
    }

    @Transactional
    public void initAdmin() throws Exception {
        if (!this.userService.isUserNameExist("admin")) {
            List departmentList = this.departmentService.queryAll();
            Validate.notNull((Object)departmentList);
            User user = new User();
            user.setUsername("admin");
            user.setDepartmentId(((Department)departmentList.get(0)).getId());
            user.setPassword(Md5Util.getMD5((String)"123456"));
            this.userService.create(user, false);
            int adminId = user.getId();
            Validate.isTrue((adminId != 0 ? 1 : 0) != 0);
            int result = this.resourceService.grantPermission(Integer.valueOf(adminId), OwnerTypeEnum.USER, Integer.valueOf(0), RoleTypeEnum.OPT_MANAGE_PERMISSION);
            Validate.isTrue((result > 0 ? 1 : 0) != 0);
        } else {
            User user = this.userService.queryAllInfoByUserName("admin");
            Role role = this.roleService.cacheQueryRole(RoleTypeEnum.OPT_MANAGE_PERMISSION, Integer.valueOf(0));
            Validate.notNull((Object)role);
            if (!this.permissionService.existPermission(user.getId(), OwnerTypeEnum.USER, role.getId())) {
                int result = this.permissionService.grantPermission(user.getId(), OwnerTypeEnum.USER, role.getId());
                Validate.isTrue((result > 0 ? 1 : 0) != 0);
            }
        }
    }

    @Transactional
    public void initDefaultDomain() throws Exception {
        Domain defaultDomain = this.domainService.queryDefault();
        if (defaultDomain == null) {
            Domain domain = new Domain();
            LocalDateTime localDateTime = LocalDateTime.now();
            domain.setCreateTime(localDateTime);
            domain.setUpdateTime(localDateTime);
            domain.setName("Default-Domain-" + System.currentTimeMillis());
            domain.setDefaultTokenPrefix(RandomID.id((int)3));
            int result = this.domainService.create(domain);
            Validate.isTrue((result > 0 ? 1 : 0) != 0);
        }
    }

    public void initStorageEngine() throws Exception {
        String sysStatTableName;
        WarehouseStorageEngine dbEngine = WarehouseStorageEngineProxy.getInstance();
        String namespace = dbEngine.getDefaultNamespace();
        dbEngine.createNamespaceIfNotExist(namespace);
        String dimensTableName = "ldp_dimens_records";
        if (!dbEngine.isTableExist(dimensTableName)) {
            dbEngine.createDimensTable(dimensTableName);
        }
        if (!dbEngine.isTableExist(sysStatTableName = "ldp_system_result")) {
            dbEngine.createResultTable(sysStatTableName);
        }
    }

    public void createCMDBTablesIfNotExist() throws Exception {
        String ldpHome = System.getenv("LDP_HOME");
        String upgradeSqlFile = ldpHome + "/conf/ldp_upgrade.sql";
        File sqlFile = new File(upgradeSqlFile);
        if (!sqlFile.exists()) {
            logger.info("cmdb database update file does not exist.");
            return;
        }
        CMDBStorageEngine storageEngine = CMDBStorageEngineProxy.getInstance();
        Connection conn = null;
        Statement stmt = null;
        try {
            String line;
            conn = (Connection)storageEngine.getConnection();
            conn.setAutoCommit(false);
            stmt = conn.createStatement();
            BufferedReader br = new BufferedReader(new FileReader(upgradeSqlFile));
            StringBuilder sql = new StringBuilder();
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith("--") || line.startsWith("//") || line.startsWith("/*")) continue;
                sql.append(line);
                if (!line.endsWith(";")) continue;
                try {
                    stmt.execute(sql.toString());
                }
                catch (SQLException ex) {
                    logger.error("execute cmdb upgrade error!", (Throwable)ex);
                }
                sql.setLength(0);
            }
            conn.commit();
            br.close();
        }
        catch (IOException | SQLException e) {
            logger.error("execute update cmdb error!", (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            throw e;
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
    }

    public void createCMDBColumnsIfNotExist() throws Exception {
        CMDBUtil.addColumnIfNotExist((String)"ldp_relations", (String)"config", (String)"MEDIUMTEXT");
        CMDBUtil.addColumnIfNotExist((String)"ldp_views", (String)"caller_id", (String)"INT");
        CMDBUtil.addColumnIfNotExist((String)"ldp_views", (String)"sharelink_enabled", (String)"TINYINT(1)");
    }

    public void createCMDBIndexIfNotExist() throws Exception {
        CMDBUtil.addIndexIfNotExist((String)"ldp_alarms", (String)"index_uniqueCode", (String)"unique_code");
    }
}

