/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.service.impl;

import com.dtstep.lighthouse.common.entity.ListData;
import com.dtstep.lighthouse.common.entity.ResultCode;
import com.dtstep.lighthouse.common.enums.OwnerTypeEnum;
import com.dtstep.lighthouse.common.enums.PrivateTypeEnum;
import com.dtstep.lighthouse.common.enums.RelationTypeEnum;
import com.dtstep.lighthouse.common.enums.ResourceTypeEnum;
import com.dtstep.lighthouse.common.enums.RoleTypeEnum;
import com.dtstep.lighthouse.common.modal.Domain;
import com.dtstep.lighthouse.common.modal.FlatTreeNode;
import com.dtstep.lighthouse.common.modal.Indicator;
import com.dtstep.lighthouse.common.modal.MetricBindElement;
import com.dtstep.lighthouse.common.modal.MetricSet;
import com.dtstep.lighthouse.common.modal.Permission;
import com.dtstep.lighthouse.common.modal.PermissionEnum;
import com.dtstep.lighthouse.common.modal.Relation;
import com.dtstep.lighthouse.common.modal.ResourceDto;
import com.dtstep.lighthouse.common.modal.Role;
import com.dtstep.lighthouse.common.modal.RolePair;
import com.dtstep.lighthouse.common.modal.TreeNode;
import com.dtstep.lighthouse.common.modal.User;
import com.dtstep.lighthouse.common.modal.View;
import com.dtstep.lighthouse.common.random.RandomID;
import com.dtstep.lighthouse.common.util.Md5Util;
import com.dtstep.lighthouse.common.util.StringUtil;
import com.dtstep.lighthouse.insights.config.SoftEdition;
import com.dtstep.lighthouse.insights.dao.GroupDao;
import com.dtstep.lighthouse.insights.dao.MetricSetDao;
import com.dtstep.lighthouse.insights.dao.PermissionDao;
import com.dtstep.lighthouse.insights.dao.ProjectDao;
import com.dtstep.lighthouse.insights.dao.RelationDao;
import com.dtstep.lighthouse.insights.dao.StatDao;
import com.dtstep.lighthouse.insights.dao.ViewDao;
import com.dtstep.lighthouse.insights.dto.MetricBindParam;
import com.dtstep.lighthouse.insights.dto.MetricBindRemoveParam;
import com.dtstep.lighthouse.insights.dto.MetricPendQueryParam;
import com.dtstep.lighthouse.insights.dto.MetricSetQueryParam;
import com.dtstep.lighthouse.insights.dto.MetricUpdateStructureParam;
import com.dtstep.lighthouse.insights.dto.PermissionGrantParam;
import com.dtstep.lighthouse.insights.dto.PermissionReleaseParam;
import com.dtstep.lighthouse.insights.dto.RelationDeleteParam;
import com.dtstep.lighthouse.insights.dto.RelationQueryParam;
import com.dtstep.lighthouse.insights.service.BaseService;
import com.dtstep.lighthouse.insights.service.DomainService;
import com.dtstep.lighthouse.insights.service.MetricSetService;
import com.dtstep.lighthouse.insights.service.PermissionService;
import com.dtstep.lighthouse.insights.service.ProjectService;
import com.dtstep.lighthouse.insights.service.RelationService;
import com.dtstep.lighthouse.insights.service.ResourceService;
import com.dtstep.lighthouse.insights.service.RoleService;
import com.dtstep.lighthouse.insights.service.StatService;
import com.dtstep.lighthouse.insights.service.UserService;
import com.dtstep.lighthouse.insights.vo.MetricSetVO;
import com.dtstep.lighthouse.insights.vo.ProjectVO;
import com.dtstep.lighthouse.insights.vo.StatVO;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.lang.invoke.CallSite;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MetricSetServiceImpl
implements MetricSetService {
    private static final Logger logger = LoggerFactory.getLogger(MetricSetServiceImpl.class);
    @Autowired
    private MetricSetDao metricSetDao;
    @Autowired
    private BaseService baseService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private PermissionDao permissionDao;
    @Autowired
    private UserService userService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private StatService statService;
    @Autowired
    private RelationService relationService;
    @Autowired
    private DomainService domainService;
    @Autowired
    private RelationDao relationDao;
    @Autowired
    private GroupDao groupDao;
    @Autowired
    private StatDao statDao;
    @Autowired
    private ProjectDao projectDao;
    @Autowired
    private ViewDao viewDao;
    @Autowired
    private SoftEdition softEdition;

    @Transactional
    public int create(MetricSet metricSet) {
        LocalDateTime localDateTime = LocalDateTime.now();
        metricSet.setCreateTime(localDateTime);
        metricSet.setUpdateTime(localDateTime);
        metricSet.setCreateUserId(this.baseService.getCurrentUserId());
        this.metricSetDao.insert(metricSet);
        int id = metricSet.getId();
        Domain domain = this.domainService.queryDefault();
        RolePair rolePair = this.resourceService.addResourceCallback(ResourceDto.newResource((ResourceTypeEnum)ResourceTypeEnum.MetricSet, (Integer)id, (ResourceTypeEnum)ResourceTypeEnum.Domain, (Integer)domain.getId()));
        Integer manageRoleId = rolePair.getManageRoleId();
        int currentUserId = this.baseService.getCurrentUserId();
        Permission adminPermission = new Permission(Integer.valueOf(currentUserId), OwnerTypeEnum.USER, manageRoleId);
        this.permissionService.create(adminPermission);
        return id;
    }

    @Transactional
    public ResultCode batchGrantPermissions(PermissionGrantParam grantParam) throws Exception {
        Integer roleId;
        Role role;
        Integer resourceId = grantParam.getResourceId();
        MetricSet metricSet = this.metricSetDao.queryById(resourceId);
        RoleTypeEnum roleTypeEnum = grantParam.getRoleType();
        Validate.notNull((Object)metricSet);
        HashSet adminsSet = new HashSet();
        if (roleTypeEnum == RoleTypeEnum.METRIC_MANAGE_PERMISSION) {
            role = this.roleService.queryRole(RoleTypeEnum.METRIC_MANAGE_PERMISSION, resourceId);
            roleId = role.getId();
            List adminIds = this.permissionService.queryUserPermissionsByRoleId(roleId, Integer.valueOf(5));
            adminsSet.addAll(adminIds);
        } else if (roleTypeEnum == RoleTypeEnum.METRIC_ACCESS_PERMISSION) {
            role = this.roleService.queryRole(RoleTypeEnum.METRIC_ACCESS_PERMISSION, resourceId);
            roleId = role.getId();
        } else {
            throw new Exception();
        }
        if (roleTypeEnum == RoleTypeEnum.METRIC_ACCESS_PERMISSION && metricSet.getPrivateType() == PrivateTypeEnum.Public) {
            return ResultCode.grantPermissionPublicLimit;
        }
        List departmentIdList = grantParam.getDepartmentsPermissions();
        List userIdList = grantParam.getUsersPermissions();
        if (CollectionUtils.isNotEmpty((Collection)departmentIdList)) {
            for (Integer tempDepartmentId : departmentIdList) {
                Validate.isTrue((roleTypeEnum == RoleTypeEnum.METRIC_ACCESS_PERMISSION ? 1 : 0) != 0);
                this.permissionService.grantPermission(tempDepartmentId, OwnerTypeEnum.DEPARTMENT, roleId);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)userIdList)) {
            if (roleTypeEnum == RoleTypeEnum.METRIC_MANAGE_PERMISSION) {
                adminsSet.addAll(userIdList);
            }
            if (adminsSet.size() > 3) {
                return ResultCode.grantPermissionAdminExceedLimit;
            }
            for (Integer userId : userIdList) {
                this.permissionService.grantPermission(userId, OwnerTypeEnum.USER, roleId);
            }
        }
        return ResultCode.success;
    }

    public ResultCode releasePermission(PermissionReleaseParam releaseParam) throws Exception {
        List adminIds;
        int currentUserId = this.baseService.getCurrentUserId();
        Integer resourceId = releaseParam.getResourceId();
        Integer permissionId = releaseParam.getPermissionId();
        Permission permission = this.permissionService.queryById(permissionId);
        Integer ownerId = permission.getOwnerId();
        Integer roleId = permission.getRoleId();
        if (releaseParam.getRoleType() == RoleTypeEnum.METRIC_MANAGE_PERMISSION && (adminIds = this.permissionDao.queryUserPermissionsByRoleId(roleId, Integer.valueOf(3))).size() <= 1) {
            return ResultCode.releasePermissionAdminAtLeastOne;
        }
        if (ownerId == currentUserId) {
            return ResultCode.releasePermissionCurrentNotAllowed;
        }
        Role role = this.roleService.queryById(roleId);
        Validate.isTrue((role.getResourceId().intValue() == resourceId.intValue() ? 1 : 0) != 0);
        this.permissionService.releasePermission(permissionId);
        return ResultCode.success;
    }

    public int update(MetricSet metricSet) {
        LocalDateTime localDateTime = LocalDateTime.now();
        metricSet.setUpdateTime(localDateTime);
        int result = this.metricSetDao.update(metricSet);
        Domain domain = this.domainService.queryDefault();
        this.resourceService.updateResourcePidCallback(ResourceDto.newResource((ResourceTypeEnum)ResourceTypeEnum.MetricSet, (Integer)metricSet.getId(), (ResourceTypeEnum)ResourceTypeEnum.Domain, (Integer)domain.getId()));
        return result;
    }

    private MetricSetVO translate(MetricSet metricSet) {
        if (metricSet == null) {
            return null;
        }
        MetricSetVO metricSetVO = new MetricSetVO(metricSet);
        Role manageRole = this.roleService.cacheQueryRole(RoleTypeEnum.METRIC_MANAGE_PERMISSION, metricSet.getId());
        Role accessRole = this.roleService.queryRole(RoleTypeEnum.METRIC_ACCESS_PERMISSION, metricSet.getId());
        int currentUserId = this.baseService.getCurrentUserId();
        if (this.permissionService.checkUserPermission(Integer.valueOf(currentUserId), manageRole.getId())) {
            metricSetVO.addPermission(PermissionEnum.ManageAble);
            metricSetVO.addPermission(PermissionEnum.AccessAble);
        } else if (this.softEdition.isOpenSource() || metricSetVO.getPrivateType() == PrivateTypeEnum.Public || this.permissionService.checkUserPermission(Integer.valueOf(currentUserId), accessRole.getId())) {
            metricSetVO.addPermission(PermissionEnum.AccessAble);
        }
        Integer userId = metricSet.getCreateUserId();
        if (userId != null) {
            User user = this.userService.cacheQueryById(userId.intValue());
            metricSetVO.setCreateUser(user);
        }
        return metricSetVO;
    }

    public MetricSetVO queryById(Integer id) {
        MetricSet metricSet = this.metricSetDao.queryById(id);
        if (metricSet == null) {
            return null;
        }
        MetricSetVO metricSetVO = this.translate(metricSet);
        Role manageRole = this.roleService.cacheQueryRole(RoleTypeEnum.METRIC_MANAGE_PERMISSION, metricSet.getId());
        List adminIds = this.permissionService.queryUserPermissionsByRoleId(manageRole.getId(), Integer.valueOf(3));
        if (CollectionUtils.isNotEmpty((Collection)adminIds)) {
            List admins = adminIds.stream().map(z -> this.userService.cacheQueryById(z.intValue())).collect(Collectors.toList());
            metricSetVO.setAdmins(admins);
        }
        List relationList = this.relationDao.queryList(metricSetVO.getId(), RelationTypeEnum.MetricSetBindRelation);
        ArrayList<MetricBindElement> elements = new ArrayList<MetricBindElement>();
        for (Relation relation : relationList) {
            MetricBindElement bindElement = new MetricBindElement();
            bindElement.setResourceId(relation.getResourceId());
            bindElement.setResourceType(relation.getResourceType());
            elements.add(bindElement);
        }
        metricSetVO.setBindElements(elements);
        return metricSetVO;
    }

    public int binded(MetricBindParam bindParam) throws Exception {
        List metricIds = bindParam.getMetricIds();
        List bindElements = bindParam.getBindElements();
        ArrayList<Relation> relationList = new ArrayList<Relation>();
        LocalDateTime localDateTime = LocalDateTime.now();
        for (Integer metricId : metricIds) {
            boolean isExist;
            String hash;
            Object projectId2;
            List projectIds = bindElements.stream().filter(x -> x.getResourceType() == ResourceTypeEnum.Project).map(MetricBindElement::getResourceId).collect(Collectors.toList());
            for (Object projectId2 : projectIds) {
                ProjectVO project = this.projectService.queryById((Integer)projectId2);
                if (project == null) continue;
                Relation relation = new Relation();
                hash = Md5Util.getMD5((String)(metricId + "_" + RelationTypeEnum.MetricSetBindRelation.getRelationType() + "_" + (Integer)projectId2 + "_" + ResourceTypeEnum.Project.getResourceType()));
                isExist = this.relationService.isExist(hash);
                if (isExist) continue;
                relation.setSubjectId(metricId);
                relation.setRelationType(RelationTypeEnum.MetricSetBindRelation);
                relation.setResourceId((Integer)projectId2);
                relation.setResourceType(ResourceTypeEnum.Project);
                relation.setHash(hash);
                relation.setCreateTime(localDateTime);
                relation.setUpdateTime(localDateTime);
                relationList.add(relation);
            }
            List statIds = bindElements.stream().filter(x -> x.getResourceType() == ResourceTypeEnum.Stat).map(MetricBindElement::getResourceId).collect(Collectors.toList());
            projectId2 = statIds.iterator();
            while (projectId2.hasNext()) {
                Integer statId = (Integer)projectId2.next();
                StatVO stat = this.statService.queryById(statId);
                if (stat == null || (isExist = this.relationService.isExist(hash = Md5Util.getMD5((String)(metricId + "_" + RelationTypeEnum.MetricSetBindRelation.getRelationType() + "_" + statId + "_" + ResourceTypeEnum.Stat.getResourceType()))))) continue;
                Relation relation = new Relation();
                relation.setSubjectId(metricId);
                relation.setRelationType(RelationTypeEnum.MetricSetBindRelation);
                relation.setResourceId(statId);
                relation.setResourceType(ResourceTypeEnum.Stat);
                relation.setHash(hash);
                relation.setCreateTime(localDateTime);
                relation.setUpdateTime(localDateTime);
                relationList.add(relation);
            }
            List viewIds = bindElements.stream().filter(x -> x.getResourceType() == ResourceTypeEnum.View).map(MetricBindElement::getResourceId).collect(Collectors.toList());
            for (Integer viewId : viewIds) {
                String hash2;
                boolean isExist2;
                View view = this.viewDao.queryById(viewId);
                if (view == null || (isExist2 = this.relationService.isExist(hash2 = Md5Util.getMD5((String)(metricId + "_" + RelationTypeEnum.MetricSetBindRelation.getRelationType() + "_" + viewId + "_" + ResourceTypeEnum.View.getResourceType()))))) continue;
                Relation relation = new Relation();
                relation.setSubjectId(metricId);
                relation.setRelationType(RelationTypeEnum.MetricSetBindRelation);
                relation.setResourceId(viewId);
                relation.setResourceType(ResourceTypeEnum.View);
                relation.setHash(hash2);
                relation.setCreateTime(localDateTime);
                relation.setUpdateTime(localDateTime);
                relationList.add(relation);
            }
        }
        int result = 0;
        if (CollectionUtils.isNotEmpty(relationList)) {
            result = this.relationService.batchCreate(relationList);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListData<MetricSetVO> queryList(MetricSetQueryParam queryParam, Integer pageNum, Integer pageSize) {
        queryParam.setOwnerId(this.baseService.getCurrentUserId());
        PageHelper.startPage((int)pageNum, (int)pageSize);
        PageInfo pageInfo = null;
        try {
            List metricSetList = this.metricSetDao.queryList(queryParam);
            pageInfo = new PageInfo(metricSetList);
        }
        finally {
            PageHelper.clearPage();
        }
        ArrayList<MetricSetVO> voList = new ArrayList<MetricSetVO>();
        for (MetricSet metricSet : pageInfo.getList()) {
            try {
                MetricSetVO metricSetVO = this.translate(metricSet);
                voList.add(metricSetVO);
            }
            catch (Exception ex) {
                logger.error("translate item info error,id:{}", (Object)metricSet.getId(), (Object)ex);
            }
        }
        return ListData.newInstance(voList, (long)pageInfo.getTotal(), (int)pageNum, (int)pageSize);
    }

    public TreeNode getStructure(MetricSetVO metricSet) throws Exception {
        Validate.notNull((Object)metricSet);
        TreeNode structure = metricSet.getStructure();
        if (structure == null || CollectionUtils.isEmpty((Collection)structure.getChildren())) {
            structure = this.combineDefaultStructure(metricSet);
            metricSet.setCustomStructure(false);
        } else {
            metricSet.setCustomStructure(true);
        }
        return structure;
    }

    private TreeNode combineDefaultStructure(MetricSetVO metricSet) {
        ArrayList keyList = new ArrayList();
        String rootKey = RandomID.id((int)10, keyList);
        TreeNode rootNode = new TreeNode(rootKey, metricSet.getTitle(), (Object)metricSet.getId(), "metric");
        RelationQueryParam queryParam = new RelationQueryParam();
        queryParam.setSubjectId(metricSet.getId());
        queryParam.setRelationType(RelationTypeEnum.MetricSetBindRelation);
        List relationList = this.relationDao.queryJoinList(queryParam);
        List projectIdList = relationList.stream().filter(x -> x.getResourceType() == ResourceTypeEnum.Project).map(Relation::getResourceId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(projectIdList)) {
            HashMap<CallSite, TreeNode> nodesMap = new HashMap<CallSite, TreeNode>();
            List flatTreeNodes = this.projectDao.queryNodeList(projectIdList);
            for (FlatTreeNode flatNode : flatTreeNodes) {
                String key = RandomID.id((int)10, keyList);
                TreeNode treeNode = new TreeNode(key, flatNode.getTitle(), (Object)flatNode.getId(), flatNode.getType());
                nodesMap.put((CallSite)((Object)(flatNode.getType() + "_" + flatNode.getId())), treeNode);
            }
            for (FlatTreeNode flatNode : flatTreeNodes) {
                TreeNode parentNode;
                TreeNode currentNode = (TreeNode)nodesMap.get(flatNode.getType() + "_" + flatNode.getId());
                if (flatNode.getType().equals("group")) {
                    parentNode = (TreeNode)nodesMap.get("project_" + flatNode.getPid());
                    parentNode.addChild(currentNode);
                    continue;
                }
                if (!flatNode.getType().equals("stat")) continue;
                parentNode = (TreeNode)nodesMap.get("group_" + flatNode.getPid());
                parentNode.addChild(currentNode);
            }
            for (TreeNode treeNode : nodesMap.values()) {
                if (!treeNode.getType().equals("project")) continue;
                rootNode.addChild(treeNode);
            }
        }
        for (Relation relation : relationList) {
            String key;
            TreeNode treeNode;
            if (relation.getResourceType() == ResourceTypeEnum.Stat) {
                key = RandomID.id((int)10, keyList);
                if (!StringUtil.isNotEmpty((String)relation.getResourceTitle())) continue;
                treeNode = new TreeNode(key, relation.getResourceTitle(), (Object)relation.getResourceId(), "stat");
                rootNode.addChild(treeNode);
                continue;
            }
            if (relation.getResourceType() != ResourceTypeEnum.View) continue;
            key = RandomID.id((int)10, keyList);
            if (!StringUtil.isNotEmpty((String)relation.getResourceTitle())) continue;
            treeNode = new TreeNode(key, relation.getResourceTitle(), (Object)relation.getResourceId(), "view");
            rootNode.addChild(treeNode);
        }
        return rootNode;
    }

    public int bindRemove(MetricBindRemoveParam removeParam) {
        Integer relationId = removeParam.getRelationId();
        Relation relation = this.relationDao.queryById(relationId);
        Validate.isTrue((relation.getSubjectId().intValue() == removeParam.getId().intValue() ? 1 : 0) != 0);
        return this.relationDao.deleteById(relationId);
    }

    @Transactional
    public int delete(MetricSet metricSet) {
        Integer metricId = metricSet.getId();
        RelationDeleteParam userStarRelation = new RelationDeleteParam();
        userStarRelation.setRelationType(RelationTypeEnum.UserStarMetricSetRelation);
        userStarRelation.setResourceId(metricId);
        userStarRelation.setResourceType(ResourceTypeEnum.MetricSet);
        this.relationService.delete(userStarRelation);
        RelationDeleteParam metricBindRelation = new RelationDeleteParam();
        metricBindRelation.setRelationType(RelationTypeEnum.MetricSetBindRelation);
        metricBindRelation.setSubjectId(metricId);
        this.relationService.delete(metricBindRelation);
        return this.metricSetDao.deleteById(metricSet.getId());
    }

    public ResultCode star(MetricSet metricSet) {
        int currentUserId = this.baseService.getCurrentUserId();
        RelationQueryParam countParam = new RelationQueryParam();
        countParam.setSubjectId(Integer.valueOf(currentUserId));
        countParam.setRelationType(RelationTypeEnum.UserStarMetricSetRelation);
        int count = this.relationService.count(countParam);
        if (count > 100) {
            return ResultCode.userStarMetricLimitExceed;
        }
        Relation relation = new Relation();
        relation.setSubjectId(Integer.valueOf(currentUserId));
        relation.setRelationType(RelationTypeEnum.UserStarMetricSetRelation);
        relation.setResourceId(metricSet.getId());
        relation.setResourceType(ResourceTypeEnum.MetricSet);
        return this.relationService.create(relation);
    }

    public ResultCode unStar(MetricSet metricSet) {
        int currentUserId = this.baseService.getCurrentUserId();
        RelationDeleteParam relationDeleteParam = new RelationDeleteParam();
        relationDeleteParam.setSubjectId(Integer.valueOf(currentUserId));
        relationDeleteParam.setRelationType(RelationTypeEnum.UserStarMetricSetRelation);
        relationDeleteParam.setResourceId(metricSet.getId());
        relationDeleteParam.setResourceType(ResourceTypeEnum.MetricSet);
        this.relationService.delete(relationDeleteParam);
        return ResultCode.success;
    }

    public ResultCode updateStructure(MetricUpdateStructureParam updateStructureParam) {
        TreeNode treeNode = updateStructureParam.getStructure();
        this.modifyStructure(List.of(treeNode));
        MetricSet metricSet = new MetricSet();
        metricSet.setId(updateStructureParam.getId());
        metricSet.setStructure(treeNode);
        this.metricSetDao.update(metricSet);
        return CollectionUtils.isEmpty((Collection)treeNode.getChildren()) ? ResultCode.metricStructureReset : ResultCode.success;
    }

    private void modifyStructure(List<TreeNode> nodeList) {
        for (TreeNode treeNode : nodeList) {
            if (treeNode.getType() == null || treeNode.getType().equals("project") || treeNode.getType().equals("group")) {
                treeNode.setType("dir");
            }
            if (!CollectionUtils.isNotEmpty((Collection)treeNode.getChildren())) continue;
            this.modifyStructure(treeNode.getChildren());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListData<Indicator> queryIndicatorList(MetricPendQueryParam queryParam, Integer pageNum, Integer pageSize) {
        PageInfo pageInfo;
        PageHelper.startPage((int)pageNum, (int)pageSize);
        try {
            List ids = this.metricSetDao.queryIndicatorList(queryParam.getId());
            pageInfo = new PageInfo(ids);
        }
        finally {
            PageHelper.clearPage();
        }
        return ListData.newInstance((List)pageInfo.getList(), (long)pageInfo.getTotal(), (int)pageNum, (int)pageSize);
    }

    private static List<Integer> getCurrentStatIds(List<TreeNode> nodes) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        for (TreeNode node : nodes) {
            if (node.getType().equals("stat")) {
                values.add((Integer)node.getValue());
            }
            if (!CollectionUtils.isNotEmpty((Collection)node.getChildren())) continue;
            values.addAll(MetricSetServiceImpl.getCurrentStatIds((List)node.getChildren()));
        }
        return values;
    }

    public List<MetricSetVO> queryStarList() {
        int currentUserId = this.baseService.getCurrentUserId();
        List relationList = this.relationDao.queryList(Integer.valueOf(currentUserId), RelationTypeEnum.UserStarMetricSetRelation);
        List ids = relationList.stream().map(Relation::getResourceId).collect(Collectors.toList());
        ArrayList<MetricSetVO> voList = new ArrayList<MetricSetVO>();
        if (CollectionUtils.isNotEmpty(ids)) {
            MetricSetQueryParam queryParam = new MetricSetQueryParam();
            queryParam.setIds(ids);
            List metricSetList = this.metricSetDao.queryList(queryParam);
            for (MetricSet metricSet : metricSetList) {
                try {
                    MetricSetVO metricSetVO = this.translate(metricSet);
                    voList.add(metricSetVO);
                }
                catch (Exception ex) {
                    logger.error("translate item info error,id:{}", (Object)metricSet.getId(), (Object)ex);
                }
            }
        }
        voList.sort(Comparator.comparingInt(e -> ids.indexOf(e.getId())));
        return voList;
    }

    public int count(MetricSetQueryParam queryParam) {
        return this.metricSetDao.count(queryParam);
    }
}

