/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.service.impl;

import com.dtstep.lighthouse.common.entity.ListData;
import com.dtstep.lighthouse.common.entity.ResultCode;
import com.dtstep.lighthouse.common.entity.ServiceResult;
import com.dtstep.lighthouse.common.enums.OwnerTypeEnum;
import com.dtstep.lighthouse.common.enums.PrivateTypeEnum;
import com.dtstep.lighthouse.common.enums.RelationTypeEnum;
import com.dtstep.lighthouse.common.enums.ResourceTypeEnum;
import com.dtstep.lighthouse.common.enums.RoleTypeEnum;
import com.dtstep.lighthouse.common.modal.Group;
import com.dtstep.lighthouse.common.modal.Permission;
import com.dtstep.lighthouse.common.modal.PermissionEnum;
import com.dtstep.lighthouse.common.modal.Project;
import com.dtstep.lighthouse.common.modal.Relation;
import com.dtstep.lighthouse.common.modal.ResourceDto;
import com.dtstep.lighthouse.common.modal.Role;
import com.dtstep.lighthouse.common.modal.RolePair;
import com.dtstep.lighthouse.common.modal.Stat;
import com.dtstep.lighthouse.common.modal.TreeNode;
import com.dtstep.lighthouse.core.builtin.BuiltinLoader;
import com.dtstep.lighthouse.insights.config.SoftEdition;
import com.dtstep.lighthouse.insights.dao.DepartmentDao;
import com.dtstep.lighthouse.insights.dao.GroupDao;
import com.dtstep.lighthouse.insights.dao.PermissionDao;
import com.dtstep.lighthouse.insights.dao.ProjectDao;
import com.dtstep.lighthouse.insights.dao.RelationDao;
import com.dtstep.lighthouse.insights.dao.StatDao;
import com.dtstep.lighthouse.insights.dto.GroupQueryParam;
import com.dtstep.lighthouse.insights.dto.PermissionGrantParam;
import com.dtstep.lighthouse.insights.dto.PermissionReleaseParam;
import com.dtstep.lighthouse.insights.dto.ProjectQueryParam;
import com.dtstep.lighthouse.insights.dto.RelationDeleteParam;
import com.dtstep.lighthouse.insights.dto.RelationQueryParam;
import com.dtstep.lighthouse.insights.service.BaseService;
import com.dtstep.lighthouse.insights.service.PermissionService;
import com.dtstep.lighthouse.insights.service.ProjectService;
import com.dtstep.lighthouse.insights.service.RelationService;
import com.dtstep.lighthouse.insights.service.ResourceService;
import com.dtstep.lighthouse.insights.service.RoleService;
import com.dtstep.lighthouse.insights.service.UserService;
import com.dtstep.lighthouse.insights.vo.ProjectVO;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.lang.invoke.CallSite;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProjectServiceImpl
implements ProjectService {
    private static final Logger logger = LoggerFactory.getLogger(ProjectServiceImpl.class);
    @Autowired
    private ProjectDao projectDao;
    @Autowired
    private DepartmentDao departmentDao;
    @Autowired
    private BaseService baseService;
    @Autowired
    private GroupDao groupDao;
    @Autowired
    private RoleService roleService;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private UserService userService;
    @Autowired
    private StatDao statDao;
    @Autowired
    private RelationService relationService;
    @Autowired
    private RelationDao relationDao;
    @Autowired
    private PermissionDao permissionDao;
    @Autowired
    private SoftEdition softEdition;

    @Transactional
    public ServiceResult<Integer> create(Project project) {
        LocalDateTime localDateTime = LocalDateTime.now();
        project.setUpdateTime(localDateTime);
        project.setCreateTime(localDateTime);
        this.projectDao.insert(project);
        int id = project.getId();
        Integer departmentId = project.getDepartmentId();
        RolePair rolePair = this.resourceService.addResourceCallback(ResourceDto.newResource((ResourceTypeEnum)ResourceTypeEnum.Project, (Integer)id, (ResourceTypeEnum)ResourceTypeEnum.Department, (Integer)departmentId));
        Integer manageRoleId = rolePair.getManageRoleId();
        int currentUserId = this.baseService.getCurrentUserId();
        Permission adminPermission = new Permission(Integer.valueOf(currentUserId), OwnerTypeEnum.USER, manageRoleId);
        this.permissionService.create(adminPermission);
        return ServiceResult.success((Object)project.getId());
    }

    public ResultCode batchGrantPermissions(PermissionGrantParam grantParam) throws Exception {
        Integer roleId;
        Role role;
        Integer resourceId = grantParam.getResourceId();
        Project project = this.projectDao.queryById(resourceId);
        RoleTypeEnum roleTypeEnum = grantParam.getRoleType();
        Validate.notNull((Object)project);
        HashSet adminsSet = new HashSet();
        if (roleTypeEnum == RoleTypeEnum.PROJECT_MANAGE_PERMISSION) {
            role = this.roleService.queryRole(RoleTypeEnum.PROJECT_MANAGE_PERMISSION, resourceId);
            roleId = role.getId();
            List adminIds = this.permissionService.queryUserPermissionsByRoleId(roleId, Integer.valueOf(5));
            adminsSet.addAll(adminIds);
        } else if (roleTypeEnum == RoleTypeEnum.PROJECT_ACCESS_PERMISSION) {
            role = this.roleService.queryRole(RoleTypeEnum.PROJECT_ACCESS_PERMISSION, resourceId);
            roleId = role.getId();
        } else {
            throw new Exception();
        }
        if (roleTypeEnum == RoleTypeEnum.PROJECT_ACCESS_PERMISSION && project.getPrivateType() == PrivateTypeEnum.Public) {
            return ResultCode.grantPermissionPublicLimit;
        }
        List departmentIdList = grantParam.getDepartmentsPermissions();
        List userIdList = grantParam.getUsersPermissions();
        if (CollectionUtils.isNotEmpty((Collection)departmentIdList)) {
            for (Integer tempDepartmentId : departmentIdList) {
                Validate.isTrue((roleTypeEnum == RoleTypeEnum.PROJECT_ACCESS_PERMISSION ? 1 : 0) != 0);
                this.permissionService.grantPermission(tempDepartmentId, OwnerTypeEnum.DEPARTMENT, roleId);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)userIdList)) {
            if (roleTypeEnum == RoleTypeEnum.PROJECT_MANAGE_PERMISSION) {
                adminsSet.addAll(userIdList);
            }
            if (adminsSet.size() > 3) {
                return ResultCode.grantPermissionAdminExceedLimit;
            }
            for (Integer userId : userIdList) {
                this.permissionService.grantPermission(userId, OwnerTypeEnum.USER, roleId);
            }
        }
        return ResultCode.success;
    }

    public ResultCode releasePermission(PermissionReleaseParam releaseParam) throws Exception {
        List adminIds;
        int currentUserId = this.baseService.getCurrentUserId();
        Integer resourceId = releaseParam.getResourceId();
        Integer permissionId = releaseParam.getPermissionId();
        Permission permission = this.permissionService.queryById(permissionId);
        Integer ownerId = permission.getOwnerId();
        Integer roleId = permission.getRoleId();
        if (releaseParam.getRoleType() == RoleTypeEnum.PROJECT_MANAGE_PERMISSION && (adminIds = this.permissionDao.queryUserPermissionsByRoleId(roleId, Integer.valueOf(3))).size() <= 1) {
            return ResultCode.releasePermissionAdminAtLeastOne;
        }
        if (ownerId == currentUserId) {
            return ResultCode.releasePermissionCurrentNotAllowed;
        }
        Role role = this.roleService.queryById(roleId);
        Validate.isTrue((role.getResourceId().intValue() == resourceId.intValue() ? 1 : 0) != 0);
        this.permissionService.releasePermission(permissionId);
        return ResultCode.success;
    }

    @Transactional
    public int update(Project project) {
        this.resourceService.updateResourcePidCallback(ResourceDto.newResource((ResourceTypeEnum)ResourceTypeEnum.Project, (Integer)project.getId(), (ResourceTypeEnum)ResourceTypeEnum.Department, (Integer)project.getDepartmentId()));
        return this.projectDao.update(project);
    }

    public ProjectVO queryById(Integer id) {
        Project project = BuiltinLoader.isBuiltinProject((int)id) ? BuiltinLoader.getBuiltinProject() : this.projectDao.queryById(id);
        if (project == null) {
            return null;
        }
        return this.translate(project);
    }

    @Cacheable(value={"NormalPeriod"}, key="#targetClass + '_' + 'queryById' + '_' + #id", cacheManager="caffeineCacheManager", unless="#result == null")
    public ProjectVO cacheQueryById(Integer id) {
        return this.queryById(id);
    }

    private ProjectVO translate(Project project) {
        ProjectVO projectVO = new ProjectVO(project);
        if (BuiltinLoader.isBuiltinProject((int)project.getId())) {
            projectVO.addPermission(PermissionEnum.AccessAble);
        } else {
            int currentUserId = this.baseService.getCurrentUserId();
            Role manageRole = this.roleService.cacheQueryRole(RoleTypeEnum.PROJECT_MANAGE_PERMISSION, project.getId());
            Role accessRole = this.roleService.cacheQueryRole(RoleTypeEnum.PROJECT_ACCESS_PERMISSION, project.getId());
            List adminIds = this.permissionService.queryUserPermissionsByRoleId(manageRole.getId(), Integer.valueOf(3));
            if (CollectionUtils.isNotEmpty((Collection)adminIds)) {
                List admins = adminIds.stream().map(z -> this.userService.cacheQueryById(z.intValue())).collect(Collectors.toList());
                projectVO.setAdmins(admins);
            }
            if (this.permissionService.checkUserPermission(Integer.valueOf(currentUserId), manageRole.getId())) {
                projectVO.addPermission(PermissionEnum.ManageAble);
                projectVO.addPermission(PermissionEnum.AccessAble);
            } else if (this.softEdition.isOpenSource() || project.getPrivateType() == PrivateTypeEnum.Public || this.permissionService.checkUserPermission(Integer.valueOf(currentUserId), accessRole.getId())) {
                projectVO.addPermission(PermissionEnum.AccessAble);
            }
        }
        return projectVO;
    }

    public List<ProjectVO> queryByIds(List<Integer> ids) {
        ProjectQueryParam queryParam = new ProjectQueryParam();
        queryParam.setIds(ids);
        List projectList = this.projectDao.queryList(queryParam);
        ArrayList<ProjectVO> voList = new ArrayList<ProjectVO>();
        for (Project project : projectList) {
            ProjectVO projectVO = this.translate(project);
            voList.add(projectVO);
        }
        return voList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListData<ProjectVO> queryList(ProjectQueryParam queryParam, Integer pageNum, Integer pageSize) {
        PageInfo pageInfo;
        PageHelper.startPage((int)pageNum, (int)pageSize);
        ArrayList<ProjectVO> dtoList = new ArrayList<ProjectVO>();
        try {
            List projectList = this.projectDao.queryList(queryParam);
            pageInfo = new PageInfo(projectList);
        }
        finally {
            PageHelper.clearPage();
        }
        for (Project project : pageInfo.getList()) {
            try {
                ProjectVO projectVO = this.translate(project);
                dtoList.add(projectVO);
            }
            catch (Exception ex) {
                logger.error("translate item info error,itemId:{}!", (Object)project.getId(), (Object)ex);
            }
        }
        return ListData.newInstance(dtoList, (long)pageInfo.getTotal(), (int)pageNum, (int)pageSize);
    }

    public int count(ProjectQueryParam queryParam) {
        return this.projectDao.count(queryParam);
    }

    @Transactional
    public ServiceResult<Integer> deleteById(Integer id) {
        Project project = this.projectDao.queryById(id);
        GroupQueryParam queryParam = new GroupQueryParam();
        queryParam.setProjectId(id);
        int groupCount = this.groupDao.count(queryParam);
        if (groupCount > 0) {
            return ServiceResult.result((ResultCode)ResultCode.projectDelErrorGroupExist);
        }
        int result = this.projectDao.deleteById(id);
        RelationDeleteParam userStarRelation = new RelationDeleteParam();
        userStarRelation.setRelationType(RelationTypeEnum.UserStarProjectRelation);
        userStarRelation.setResourceId(id);
        userStarRelation.setResourceType(ResourceTypeEnum.Project);
        this.relationService.delete(userStarRelation);
        this.resourceService.deleteResourceCallback(ResourceDto.newResource((ResourceTypeEnum)ResourceTypeEnum.Project, (Integer)project.getId(), (ResourceTypeEnum)ResourceTypeEnum.Department, (Integer)project.getDepartmentId()));
        return ServiceResult.success((Object)result);
    }

    public TreeNode getStructure(Project project) throws Exception {
        List statList;
        List groupList;
        Integer id = project.getId();
        TreeNode rootNode = new TreeNode(project.getTitle(), (Object)project.getId(), "project");
        HashMap<CallSite, TreeNode> nodeMap = new HashMap<CallSite, TreeNode>();
        nodeMap.put((CallSite)((Object)("project_" + project.getId())), rootNode);
        if (BuiltinLoader.isBuiltinProject((int)project.getId())) {
            List groupExtEntities = BuiltinLoader.getAllGroups();
            groupList = groupExtEntities.stream().map(z -> z).collect(Collectors.toList());
        } else {
            groupList = this.groupDao.queryByProjectId(id);
        }
        for (Group group : groupList) {
            TreeNode groupNode = new TreeNode(group.getToken(), (Object)group.getId(), "group");
            nodeMap.put((CallSite)((Object)("group_" + group.getId())), groupNode);
            rootNode.addChild(groupNode);
        }
        if (BuiltinLoader.isBuiltinProject((int)project.getId())) {
            List statExtEntities = BuiltinLoader.getAllStats();
            statList = statExtEntities.stream().map(z -> z).collect(Collectors.toList());
        } else {
            statList = this.statDao.queryByProjectId(id);
        }
        for (Stat stat : statList) {
            TreeNode statNode = new TreeNode(stat.getTitle(), (Object)stat.getId(), "stat");
            TreeNode parentNode = (TreeNode)nodeMap.get("group_" + stat.getGroupId());
            parentNode.addChild(statNode);
        }
        return rootNode;
    }

    public ResultCode star(Project project) {
        int currentUserId = this.baseService.getCurrentUserId();
        RelationQueryParam countParam = new RelationQueryParam();
        countParam.setSubjectId(Integer.valueOf(currentUserId));
        countParam.setRelationType(RelationTypeEnum.UserStarProjectRelation);
        int count = this.relationService.count(countParam);
        if (count > 100) {
            return ResultCode.userStarProjectLimitExceed;
        }
        Relation relation = new Relation();
        relation.setSubjectId(Integer.valueOf(currentUserId));
        relation.setRelationType(RelationTypeEnum.UserStarProjectRelation);
        relation.setResourceId(project.getId());
        relation.setResourceType(ResourceTypeEnum.Project);
        return this.relationService.create(relation);
    }

    public ResultCode unStar(Project project) {
        int currentUserId = this.baseService.getCurrentUserId();
        RelationDeleteParam relationDeleteParam = new RelationDeleteParam();
        relationDeleteParam.setSubjectId(Integer.valueOf(currentUserId));
        relationDeleteParam.setRelationType(RelationTypeEnum.UserStarProjectRelation);
        relationDeleteParam.setResourceId(project.getId());
        relationDeleteParam.setResourceType(ResourceTypeEnum.Project);
        this.relationService.delete(relationDeleteParam);
        return ResultCode.success;
    }

    public List<ProjectVO> queryStarList() {
        int currentUserId = this.baseService.getCurrentUserId();
        List relationList = this.relationDao.queryList(Integer.valueOf(currentUserId), RelationTypeEnum.UserStarProjectRelation);
        List ids = relationList.stream().map(Relation::getResourceId).collect(Collectors.toList());
        ArrayList<ProjectVO> voList = new ArrayList<ProjectVO>();
        if (CollectionUtils.isNotEmpty(ids)) {
            ProjectQueryParam queryParam = new ProjectQueryParam();
            queryParam.setIds(ids);
            List projectList = this.projectDao.queryList(queryParam);
            for (Project project : projectList) {
                try {
                    ProjectVO projectVO = this.translate(project);
                    voList.add(projectVO);
                }
                catch (Exception ex) {
                    logger.error("translate item info error,id:{}", (Object)project.getId(), (Object)ex);
                }
            }
        }
        voList.sort(Comparator.comparingInt(e -> ids.indexOf(e.getId())));
        return voList;
    }
}

