/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.service.impl;

import com.dtstep.lighthouse.common.entity.ListData;
import com.dtstep.lighthouse.common.modal.Record;
import com.dtstep.lighthouse.common.modal.Stat;
import com.dtstep.lighthouse.insights.dao.RecordDao;
import com.dtstep.lighthouse.insights.dao.StatDao;
import com.dtstep.lighthouse.insights.dto.RecordQueryParam;
import com.dtstep.lighthouse.insights.service.RecordService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RecordServiceImpl
implements RecordService {
    @Autowired
    private RecordDao recordDao;
    @Autowired
    private StatDao statDao;

    public int create(Record record) {
        return this.recordDao.insert(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListData<Record> queryList(RecordQueryParam queryParam, Integer pageNum, Integer pageSize) {
        PageInfo pageInfo;
        PageHelper.startPage((int)pageNum, (int)pageSize);
        try {
            List recordList = this.recordDao.queryList(queryParam);
            pageInfo = new PageInfo(recordList);
        }
        finally {
            PageHelper.clearPage();
        }
        return ListData.newInstance((List)pageInfo.getList(), (long)pageInfo.getTotal(), (int)pageNum, (int)pageSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListData<Record> queryStatLimitList(Integer statId, Integer pageNum, Integer pageSize) {
        PageInfo pageInfo;
        Stat stat = this.statDao.queryById(statId);
        Validate.notNull((Object)stat);
        PageHelper.startPage((int)pageNum, (int)pageSize);
        try {
            List recordList = this.recordDao.queryStatLimit(stat.getId(), stat.getGroupId());
            pageInfo = new PageInfo(recordList);
        }
        finally {
            PageHelper.clearPage();
        }
        return ListData.newInstance((List)pageInfo.getList(), (long)pageInfo.getTotal(), (int)pageNum, (int)pageSize);
    }
}

