/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.service.impl;

import com.dtstep.lighthouse.common.enums.LinkTypeEnum;
import com.dtstep.lighthouse.common.modal.ShortLink;
import com.dtstep.lighthouse.common.random.RandomID;
import com.dtstep.lighthouse.insights.dao.ShortLinkDao;
import com.dtstep.lighthouse.insights.dto.LinkQueryParam;
import com.dtstep.lighthouse.insights.service.ShortLinkService;
import com.dtstep.lighthouse.insights.vo.ShortLinkVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShortLinkServiceImpl
implements ShortLinkService {
    private static final Logger logger = LoggerFactory.getLogger(ShortLinkServiceImpl.class);
    @Autowired
    private ShortLinkDao shortLinkDao;

    public String createShortLink(ShortLink shortLink) throws Exception {
        String shortCode;
        block1: {
            int attempts = 0;
            int MAX_ATTEMPTS = 30;
            do {
                boolean isExist;
                if (!(isExist = this.shortLinkDao.isExist(shortCode = RandomID.id((int)5)))) break block1;
            } while (++attempts < 30);
            throw new Exception();
        }
        shortLink.setShortCode(shortCode);
        this.shortLinkDao.insert(shortLink);
        return shortCode;
    }

    public List<ShortLinkVO> queryList(LinkQueryParam queryParam) throws Exception {
        List shortLinkList = this.shortLinkDao.queryList(queryParam);
        ArrayList<ShortLinkVO> voList = new ArrayList<ShortLinkVO>();
        if (CollectionUtils.isNotEmpty((Collection)shortLinkList)) {
            for (ShortLink shortLink : shortLinkList) {
                ShortLinkVO shortLinkVO = this.translate(shortLink);
                voList.add(shortLinkVO);
            }
        }
        return voList;
    }

    public ShortLinkVO queryByCode(String shortCode) throws Exception {
        ShortLink shortLink = this.shortLinkDao.queryByCode(shortCode);
        return this.translate(shortLink);
    }

    private ShortLinkVO translate(ShortLink shortLink) throws Exception {
        if (shortLink == null) {
            return null;
        }
        ShortLinkVO shortLinkVO = new ShortLinkVO(shortLink);
        if (shortLink.getLinkType() == LinkTypeEnum.VIEW_SHARE_LINK) {
            shortLinkVO.setLink("/s/" + shortLink.getShortCode());
        }
        return shortLinkVO;
    }

    public void updateShortLink(ShortLink shortLink) throws Exception {
        this.shortLinkDao.update(shortLink);
    }
}

