/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.insights.service.impl;

import com.dtstep.lighthouse.common.modal.SystemEnv;
import com.dtstep.lighthouse.common.random.RandomID;
import com.dtstep.lighthouse.insights.dao.SystemEnvDao;
import com.dtstep.lighthouse.insights.service.SystemEnvService;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SystemEnvServiceImpl
implements SystemEnvService {
    @Autowired
    private SystemEnvDao systemEnvDao;

    public void generateSignKeyIfNotExist() {
        boolean isExist = this.systemEnvDao.isParamExist("sign_key");
        if (!isExist) {
            SystemEnv systemEnv = new SystemEnv();
            systemEnv.setParam("sign_key");
            systemEnv.setValue(RandomID.id((int)64));
            this.systemEnvDao.insert(systemEnv);
        }
    }

    @Transactional
    public void createOrUpdate(String param, String value) {
        Validate.notNull((Object)param);
        Validate.notNull((Object)value);
        SystemEnv systemEnv = new SystemEnv();
        systemEnv.setParam(param);
        systemEnv.setValue(value);
        boolean isExist = this.systemEnvDao.isParamExist(param);
        if (!isExist) {
            this.systemEnvDao.insert(systemEnv);
        } else {
            this.systemEnvDao.update(systemEnv);
        }
    }

    public String getParam(String param) {
        return this.systemEnvDao.getParam(param);
    }

    public void delete(String param) {
        this.systemEnvDao.delete(param);
    }
}

