/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.test;

import com.dtstep.lighthouse.client.LightHouse;
import com.dtstep.lighthouse.common.entity.group.GroupExtEntity;
import com.dtstep.lighthouse.core.config.LDPConfig;
import com.dtstep.lighthouse.core.wrapper.GroupDBWrapper;
import com.dtstep.lighthouse.test.config.TestConfigContext;
import com.dtstep.lighthouse.test.impl.FlowModeTestImpl;
import com.dtstep.lighthouse.test.mode.BehaviorModalSample;
import java.util.ArrayList;
import org.apache.commons.lang3.Validate;

public class LDPFlowTestInstance {
    public static void main(String[] args) throws Exception {
        int minuteSize = Integer.parseInt(args[0]);
        String method = "rpc";
        if (args.length > 1 && args[1].equals("http")) {
            method = "http";
        }
        LDPConfig.loadConfiguration();
        String locators = LDPConfig.getVal((String)"lighthouse.ice.locators");
        String[] nodesArray = locators.split(",");
        ArrayList<String> ips = new ArrayList<String>();
        for (String node : nodesArray) {
            String ip = node.split(":")[0];
            ips.add(ip);
        }
        LightHouse.init((String)locators);
        TestConfigContext testConfigContext = new TestConfigContext();
        BehaviorModalSample modalSample = new BehaviorModalSample();
        String token = modalSample.getToken();
        testConfigContext.setToken(token);
        testConfigContext.setMethod(method);
        testConfigContext.setIps(ips);
        GroupExtEntity groupExtEntity = GroupDBWrapper.queryByToken((String)token);
        Validate.notNull((Object)groupExtEntity);
        testConfigContext.setSecretKey(groupExtEntity.getSecretKey());
        testConfigContext.setModalSample(modalSample);
        FlowModeTestImpl impl = new FlowModeTestImpl();
        testConfigContext.setMessageSize(minuteSize);
        impl.send(testConfigContext);
        System.out.println("Send Success!");
    }
}

