/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.test;

import com.dtstep.lighthouse.client.LightHouse;
import com.dtstep.lighthouse.common.entity.group.GroupExtEntity;
import com.dtstep.lighthouse.core.config.LDPConfig;
import com.dtstep.lighthouse.core.wrapper.GroupDBWrapper;
import com.dtstep.lighthouse.test.config.TestConfigContext;
import com.dtstep.lighthouse.test.dao.DaoHelper;
import com.dtstep.lighthouse.test.entity.BehaviorSampleEntity;
import com.dtstep.lighthouse.test.mode.BehaviorModalSample;
import com.dtstep.lighthouse.test.util.BeanUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;

public class LDPOnceTestInstance {
    private static final TestConfigContext testConfigContext = new TestConfigContext();
    private static final long now = System.currentTimeMillis();
    private static final AtomicLong dbIndex = new AtomicLong();
    private static final AtomicLong totalCost = new AtomicLong();

    public static void main(String[] args) throws Exception {
        Future future;
        int dataSize = Integer.parseInt(args[0]);
        LDPConfig.loadConfiguration();
        LightHouse.init((String)LDPConfig.getVal((String)"lighthouse.ice.locators"));
        LDPOnceTestInstance.createGroup();
        BehaviorModalSample modalSample = new BehaviorModalSample();
        String token = modalSample.getToken();
        testConfigContext.setToken(token);
        testConfigContext.setModalSample(modalSample);
        GroupExtEntity groupExtEntity = GroupDBWrapper.queryByToken((String)token);
        Validate.notNull((Object)groupExtEntity);
        testConfigContext.setSecretKey(groupExtEntity.getSecretKey());
        LDPOnceTestInstance.createSampleTable(dataSize);
        ExecutorService executorService = Executors.newFixedThreadPool(8);
        ArrayList<Future> futureList = new ArrayList<Future>();
        for (int i = 0; i < 8; ++i) {
            SendThread sendThread = new SendThread();
            future = executorService.submit(sendThread);
            futureList.add(future);
        }
        int totalSize = 0;
        for (int i = 0; i < 8; ++i) {
            future = (Future)futureList.get(i);
            totalSize += ((Integer)future.get()).intValue();
        }
        System.out.println("total send size:" + totalSize);
        Thread.sleep(10000L);
        System.exit(0);
    }

    public static void createGroup() throws Exception {
        int count = DaoHelper.sql.count("SELECT count(1) FROM ldp_groups where token = ?", "test_scene_behavior_stat");
        if (count == 0) {
            DaoHelper.sql.execute("INSERT INTO `ldp_projects` VALUES (11,'sssss',10221,0,'sadgasg','2024-03-17 10:07:51','2024-03-17 10:07:51')", new Object[0]);
            DaoHelper.sql.execute("INSERT INTO `ldp_groups` VALUES (111,'test_scene_behavior_stat',11,0,'[{\\\"name\\\":\\\"behavior_id\\\",\\\"type\\\":\\\"string\\\"},{\\\"name\\\":\\\"request_id\\\",\\\"type\\\":\\\"string\\\"},{\\\"name\\\":\\\"imei\\\",\\\"type\\\":\\\"string\\\"},{\\\"name\\\":\\\"province\\\",\\\"type\\\":\\\"string\\\"},{\\\"name\\\":\\\"recall_no\\\",\\\"type\\\":\\\"string\\\"},{\\\"name\\\":\\\"abtest_no\\\",\\\"type\\\":\\\"string\\\"},{\\\"name\\\":\\\"score\\\",\\\"type\\\":\\\"number\\\"},{\\\"name\\\":\\\"city\\\",\\\"type\\\":\\\"string\\\"}]','\u6d4b\u8bd5\u7edf\u8ba1\u7ec4\uff01','39Vke68YgJ3N6Y6i6o76Nfsz06Sqr3hM','JmVM5qDhpkizvJSLjgCoXa10k5j4UWJyj3LSJsPp',1,'{\\\"limitingConfig\\\":{}}','2024-03-17 12:48:35','2024-03-17 12:48:35','2024-03-17 12:48:35')", new Object[0]);
            System.out.println("create group success!");
        }
    }

    public static void createSampleTable(int dataSize) throws Exception {
        int dbSize;
        String token = testConfigContext.getToken();
        String dbName = LDPOnceTestInstance.getDBName();
        int count = DaoHelper.sql.count("SELECT count(1) FROM information_schema.TABLES WHERE table_schema = ? and table_name = ?", dbName, token);
        String tableName = dbName + "." + token;
        if (count == 0) {
            String createSql = "CREATE TABLE " + tableName + "(\n                                  `id` int NOT NULL AUTO_INCREMENT,\n                                  `behavior_id` varchar(80) DEFAULT NULL,\n                                  `request_id` varchar(80) DEFAULT NULL,\n                                  `imei` varchar(80) DEFAULT NULL,\n                                  `province` varchar(80) DEFAULT NULL,\n                                  `city` varchar(80) DEFAULT NULL,\n                                  `behavior_type` int(11) DEFAULT NULL,\n                                  `item_id` int(11) DEFAULT NULL,\n                                  `app_version` varchar(50) DEFAULT NULL,\n                                  `os` varchar(80) DEFAULT NULL,\n                                  `recall_no` int(11) DEFAULT NULL,\n                                  `abtest_no` varchar(50) DEFAULT NULL,\n                                  `top_level` varchar(50) DEFAULT NULL,\n                                  `sec_level` varchar(50) DEFAULT NULL,\n                                  `score` decimal(15,3) DEFAULT NULL,\n                                  `timestamp` datetime DEFAULT NULL,\n                                  PRIMARY KEY (`id`)\n) ENGINE=InnoDB AUTO_INCREMENT=1011 DEFAULT CHARSET=utf8mb3";
            int res = DaoHelper.sql.execute(createSql, new Object[0]);
            System.out.printf("create table %s ,result:%s!%n", tableName, res);
        }
        if ((dbSize = DaoHelper.sql.count(String.format("select count(1) from %s.%s", dbName, testConfigContext.getToken()), new Object[0])) == 0) {
            LDPOnceTestInstance.generateSampleData(dataSize);
        }
    }

    private static String getDBName() {
        String clusterName = LDPConfig.getVal((String)"lighthouse.cluster.id");
        Validate.notNull((Object)clusterName);
        return String.format("cluster_%s_ldp_cmdb", clusterName);
    }

    public static void generateSampleData(int size) throws Exception {
        BehaviorModalSample behaviorSampleModal = new BehaviorModalSample();
        String dbName = LDPOnceTestInstance.getDBName();
        DaoHelper.sql.execute(String.format("delete from %s.%s where id > 0", dbName, testConfigContext.getToken()), new Object[0]);
        try {
            int count = 0;
            ArrayList<BehaviorSampleEntity> behaviorSampleEntityList = new ArrayList<BehaviorSampleEntity>();
            for (int i = 0; i < size; ++i) {
                BehaviorSampleEntity behaviorSampleEntity = behaviorSampleModal.generateSample();
                behaviorSampleEntityList.add(behaviorSampleEntity);
                if (behaviorSampleEntityList.size() < 2000) continue;
                DaoHelper.sql.insertList(behaviorSampleEntityList);
                System.out.println("== insert data size:" + (count += behaviorSampleEntityList.size()));
                behaviorSampleEntityList.clear();
            }
            if (behaviorSampleEntityList.size() > 0) {
                DaoHelper.sql.insertList(behaviorSampleEntityList);
                System.out.println("== insert data size:" + (count += behaviorSampleEntityList.size()));
                behaviorSampleEntityList.clear();
            }
            System.out.println("sample total size is:" + count);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static long sendMessage(long startIndex, int batch) throws Exception {
        List<BehaviorSampleEntity> list = DaoHelper.sql.getList(BehaviorSampleEntity.class, "select * from " + testConfigContext.getToken() + " limit ?,?", startIndex, batch);
        if (CollectionUtils.isEmpty(list)) {
            return 0L;
        }
        for (BehaviorSampleEntity sampleEntity : list) {
            Map<String, Object> paramMap = BeanUtil.beanToMap(sampleEntity);
            long t1 = System.currentTimeMillis();
            LightHouse.stat((String)testConfigContext.getToken(), (String)testConfigContext.getSecretKey(), paramMap, (long)now);
            long t2 = System.currentTimeMillis();
            totalCost.getAndAdd(t2 - t1);
        }
        int sendSize = list.size();
        return sendSize;
    }

    public static class SendThread
    implements Callable<Integer> {
        @Override
        public Integer call() {
            int count = 0;
            try {
                while (true) {
                    int batch = 2000;
                    long curIndex = dbIndex.getAndAdd(batch);
                    long sendSize = LDPOnceTestInstance.sendMessage(curIndex, batch);
                    count = (int)((long)count + sendSize);
                    if (sendSize != 0L) {
                        System.out.println("current thread:" + Thread.currentThread().getName() + ",send size:" + sendSize + ",thread total sent number:" + count);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return count;
        }
    }
}

