/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.test.dao;

import com.dtstep.lighthouse.common.entity.annotation.DBColumnAnnotation;
import com.dtstep.lighthouse.common.entity.annotation.DBNameAnnotation;
import com.dtstep.lighthouse.common.util.DateUtil;
import com.dtstep.lighthouse.common.util.StringUtil;
import com.dtstep.lighthouse.core.storage.cmdb.CMDBStorageEngine;
import com.dtstep.lighthouse.core.storage.cmdb.mysql.MySQLCMDBStorageEngine;
import com.dtstep.lighthouse.test.dao.DaoBase;
import com.dtstep.lighthouse.test.dao.IDao;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DaoHandler
implements IDao {
    private static final Logger logger = LoggerFactory.getLogger(DaoHandler.class);
    private static final CMDBStorageEngine<Connection> storageEngine = new MySQLCMDBStorageEngine();

    DaoHandler() {
    }

    @Override
    public <T> List<T> getList(Class<T> clazz, String sql, Object ... param) throws Exception {
        List<T> list;
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        Connection conn = (Connection)storageEngine.getConnection();
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(sql);
            if (param != null) {
                for (int i = 0; i < param.length; ++i) {
                    Object obj = param[i];
                    DaoBase.setParams(ps, obj, i + 1);
                }
            }
            rs = ps.executeQuery();
            list = DaoBase.populateData(rs, clazz);
        }
        catch (Exception ex) {
            try {
                logger.error("db query error.sql:{}", (Object)sql, (Object)ex);
                throw ex;
            }
            catch (Throwable throwable) {
                this.close(ps, rs, conn);
                throw throwable;
            }
        }
        this.close(ps, rs, conn);
        logger.debug("db query,sql:{},cost:{}", (Object)sql, (Object)stopWatch.getTime());
        return list;
    }

    @Override
    public <T> T getItem(Class<T> clazz, String sql, Object ... param) throws Exception {
        if (clazz.isPrimitive()) {
            throw new InstantiationException("type not support,clazz:" + clazz);
        }
        List<T> list = this.getList(clazz, sql, param);
        T t = null;
        if (list != null && list.size() == 1) {
            t = list.get(0);
        }
        return t;
    }

    @Override
    public int insert(Object obj) throws Exception {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        Connection conn = (Connection)storageEngine.getConnection();
        Class<?> t = obj.getClass();
        Field[] fields = t.getDeclaredFields();
        Annotation[] annotations = t.getAnnotations();
        PreparedStatement ps = null;
        int preparedIndex = 1;
        StringBuilder columnsBuffer = new StringBuilder();
        StringBuilder placeBuffer = new StringBuilder();
        Annotation an = annotations[0];
        DBNameAnnotation entity = (DBNameAnnotation)an;
        String tableName = entity.name();
        HashMap<Integer, Object> paramMap = new HashMap<Integer, Object>();
        int id = -1;
        for (Field f : fields) {
            DBColumnAnnotation tt = f.getAnnotation(DBColumnAnnotation.class);
            f.setAccessible(true);
            if (f.get(obj) == null || tt == null || StringUtil.isEmpty((String)tt.basic())) continue;
            paramMap.put(preparedIndex, f.get(obj));
            if (preparedIndex != 1) {
                columnsBuffer.append(",");
                placeBuffer.append(",");
            }
            columnsBuffer.append("`" + tt.basic() + "`");
            placeBuffer.append("?");
            ++preparedIndex;
        }
        String sql = String.format("insert into %s (%s) values (%s)", tableName, columnsBuffer.toString(), placeBuffer.toString());
        try {
            ps = conn.prepareStatement(sql, 1);
            for (Integer index : paramMap.keySet()) {
                Object value = paramMap.get(index);
                if (value.getClass() == Integer.class) {
                    ps.setInt(index, (Integer)value);
                    continue;
                }
                if (value.getClass() == String.class) {
                    ps.setString(index, (String)value);
                    continue;
                }
                if (value.getClass() == Double.class) {
                    ps.setDouble(index, (Double)value);
                    continue;
                }
                if (value.getClass() == Float.class) {
                    ps.setFloat(index, ((Float)value).floatValue());
                    continue;
                }
                if (value.getClass() == Long.class) {
                    ps.setLong(index, (Long)value);
                    continue;
                }
                if (value.getClass() != Date.class) continue;
                Date d = (Date)value;
                ps.setTimestamp(index, new Timestamp(d.getTime()));
            }
            ps.executeUpdate();
            ResultSet resultSet = ps.getGeneratedKeys();
            if (resultSet != null && resultSet.next()) {
                id = resultSet.getInt(1);
            }
        }
        catch (Exception ex) {
            logger.error("db insert error.sql:{}", (Object)sql, (Object)ex);
            throw ex;
        }
        finally {
            this.close(ps, null, conn);
        }
        logger.info("db insert,sql:{},cost:{}", (Object)sql, (Object)stopWatch.getTime());
        return id;
    }

    private String combineSql(Object obj) throws Exception {
        Class<?> t = obj.getClass();
        Field[] fields = t.getDeclaredFields();
        Annotation[] annotations = t.getAnnotations();
        Annotation an = annotations[0];
        DBNameAnnotation entity = (DBNameAnnotation)an;
        String tableName = entity.name();
        StringBuilder columnBuffer = new StringBuilder();
        StringBuilder valueBuffer = new StringBuilder();
        columnBuffer.append("(");
        valueBuffer.append("(");
        int count = 0;
        for (Field f : fields) {
            DBColumnAnnotation tt = f.getAnnotation(DBColumnAnnotation.class);
            f.setAccessible(true);
            if (f.get(obj) == null || tt == null || StringUtil.isEmpty((String)tt.basic())) continue;
            if (++count != 1) {
                columnBuffer.append(",");
                valueBuffer.append(",");
            }
            if (f.getType() == Integer.class || f.getType() == Integer.TYPE) {
                if (f.get(obj) != null) {
                    valueBuffer.append(Integer.valueOf(f.get(obj).toString()));
                }
            } else if (f.getType() == Long.class || f.getType() == Long.TYPE) {
                if (f.get(obj) != null) {
                    valueBuffer.append(Long.valueOf(f.get(obj).toString()));
                }
            } else if (f.getType() == Double.class || f.getType() == Double.TYPE) {
                if (f.get(obj) != null) {
                    valueBuffer.append(Double.valueOf(f.get(obj).toString()));
                }
            } else if (f.getType() == Float.class || f.getType() == Float.TYPE) {
                if (f.get(obj) != null) {
                    valueBuffer.append(Float.valueOf(f.get(obj).toString()));
                }
            } else if (f.getType().equals(String.class)) {
                if (f.get(obj) != null) {
                    Object temp = f.get(obj).toString();
                    temp = StringUtil.escape((String)temp);
                    temp = "'" + (String)temp + "'";
                    valueBuffer.append((String)temp);
                }
            } else if (f.getType().equals(Date.class)) {
                Date date = (Date)f.get(obj);
                valueBuffer.append("'").append(DateUtil.formatTimeStamp((long)date.getTime(), (String)"yyyy-MM-dd HH:mm:ss")).append("'");
            }
            columnBuffer.append(tt.basic());
        }
        columnBuffer.append(")");
        valueBuffer.append(")");
        return "insert into " + tableName + " " + columnBuffer.toString() + " values " + valueBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(String sql, Object ... param) throws Exception {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        Connection conn = (Connection)storageEngine.getConnection();
        PreparedStatement ps = null;
        int res = 0;
        try {
            ps = conn.prepareStatement(sql);
            if (param != null) {
                for (int i = 0; i < param.length; ++i) {
                    Object obj = param[i];
                    DaoBase.setParams(ps, obj, i + 1);
                }
            }
            res = ps.executeUpdate();
        }
        catch (Exception ex) {
            logger.error("execute sql error,sql:{}", (Object)sql, (Object)ex);
        }
        finally {
            this.close(ps, null, conn);
        }
        logger.debug("db execute,sql:{},cost:{}", (Object)sql, (Object)stopWatch.getTime());
        return res;
    }

    @Override
    public <T> List<Integer> insertList(List<T> paramObjectList) throws Exception {
        Connection conn = (Connection)storageEngine.getConnection();
        ArrayList<String> sqlList = new ArrayList<String>();
        for (T t : paramObjectList) {
            sqlList.add(this.combineSql(t));
        }
        ArrayList<Integer> ids = new ArrayList<Integer>();
        Statement ps = conn.createStatement();
        try {
            conn.setAutoCommit(false);
            for (String s : sqlList) {
                ps.addBatch(s);
            }
            ps.executeBatch();
            conn.commit();
            ResultSet resultSet = ps.getGeneratedKeys();
            if (resultSet != null) {
                while (resultSet.next()) {
                    int id = resultSet.getInt(1);
                    ids.add(id);
                }
            }
        }
        catch (Exception e) {
            logger.error("db insert list error!", (Throwable)e);
            conn.rollback();
            throw e;
        }
        finally {
            this.close(ps, null, conn);
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int count(String sql, Object ... param) throws Exception {
        int count;
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        StopWatch stopWatch;
        block6: {
            stopWatch = new StopWatch();
            stopWatch.start();
            conn = (Connection)storageEngine.getConnection();
            ps = null;
            rs = null;
            count = 0;
            try {
                ps = conn.prepareStatement(sql);
                if (param != null) {
                    for (int i = 0; i < param.length; ++i) {
                        Object obj = param[i];
                        DaoBase.setParams(ps, obj, i + 1);
                    }
                }
                if (!(rs = ps.executeQuery()).next()) break block6;
                count = rs.getInt(1);
            }
            catch (Exception ex) {
                try {
                    logger.error("db count error,sql:{}", (Object)sql, (Object)ex);
                }
                catch (Throwable throwable) {
                    this.close(ps, rs, conn);
                    throw throwable;
                }
                this.close(ps, rs, conn);
            }
        }
        this.close(ps, rs, conn);
        logger.debug("db count,sql:{},cost:{}", (Object)sql, (Object)stopWatch.getTime());
        return count;
    }

    private void close(Statement ps, ResultSet rs, Connection connection) throws Exception {
        if (rs != null) {
            rs.close();
        }
        if (rs != null) {
            rs.close();
        }
        if (ps != null) {
            ps.close();
        }
        if (connection != null) {
            connection.close();
        }
    }
}

