/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.test.example;

import com.dtstep.lighthouse.common.entity.ServiceResult;
import com.dtstep.lighthouse.common.entity.stat.TemplateEntity;
import com.dtstep.lighthouse.common.enums.GroupStateEnum;
import com.dtstep.lighthouse.common.enums.OwnerTypeEnum;
import com.dtstep.lighthouse.common.enums.PrivateTypeEnum;
import com.dtstep.lighthouse.common.enums.RoleTypeEnum;
import com.dtstep.lighthouse.common.enums.StatStateEnum;
import com.dtstep.lighthouse.common.modal.Column;
import com.dtstep.lighthouse.common.modal.Group;
import com.dtstep.lighthouse.common.modal.Permission;
import com.dtstep.lighthouse.common.modal.Project;
import com.dtstep.lighthouse.common.modal.Role;
import com.dtstep.lighthouse.common.modal.Stat;
import com.dtstep.lighthouse.common.modal.User;
import com.dtstep.lighthouse.common.random.RandomID;
import com.dtstep.lighthouse.common.util.JsonUtil;
import com.dtstep.lighthouse.core.config.LDPConfig;
import com.dtstep.lighthouse.core.storage.cmdb.CMDBStorageEngineProxy;
import com.dtstep.lighthouse.core.template.TemplateContext;
import com.dtstep.lighthouse.core.template.TemplateParser;
import com.dtstep.lighthouse.test.relation.ExampleContext;
import com.dtstep.lighthouse.test.relation.GroupHandler;
import com.dtstep.lighthouse.test.relation.MetaHandler;
import com.dtstep.lighthouse.test.relation.PermissionHandler;
import com.dtstep.lighthouse.test.relation.ProjectHandler;
import com.dtstep.lighthouse.test.relation.RoleHandler;
import com.dtstep.lighthouse.test.relation.StatHandler;
import com.dtstep.lighthouse.test.relation.UserHandler;
import java.sql.Connection;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartExample {
    private static final Logger logger = LoggerFactory.getLogger(StartExample.class);
    private static final ExampleContext exampleContext = new ExampleContext();
    private static final List<Pair<String, String>> templateList = List.of(Pair.of((Object)"1-minute", (Object)"<stat-item  title=\"\u6bcf\u5206\u949f_\u65e5\u5fd7\u91cf\" stat=\"count()\"  />"), Pair.of((Object)"1-minute", (Object)"<stat-item  title=\"\u6bcf\u5206\u949f_uv\u91cf\" stat=\"bitcount(imei)\"  />"), Pair.of((Object)"1-minute", (Object)"<stat-item  title=\"\u6bcf\u5206\u949f_\u4e0b\u53d1\u5e16\u5b50\u91cf\" stat=\"bitcount(item_id)\"  />"), Pair.of((Object)"1-minute", (Object)"<stat-item  title=\"\u6bcf\u5206\u949f_\u5404\u7701\u4efd_\u66dd\u5149/\u70b9\u51fb\u91cf\" stat=\"count()\" dimens=\"province;behavior_type\"  />"), Pair.of((Object)"1-minute", (Object)"<stat-item  title=\"\u6bcf\u5206\u949f_\u63a5\u53e3\u8bf7\u6c42\u91cf\" stat=\"bitcount(request_id)\"  />"), Pair.of((Object)"1-day", (Object)"<stat-item  title=\"\u6bcf\u5929_\u5404\u4e00\u7ea7\u5206\u7c7b_\u5e16\u5b50\u4e0b\u53d1\u91cf\" stat=\"bitcount(item_id)\" dimens=\"top_level\"  />"), Pair.of((Object)"1-hour", (Object)"<stat-item  title=\"\u6bcf\u5c0f\u65f6_\u5404\u53ec\u56de\u6a21\u578b_\u5e73\u5747\u4e0b\u53d1\u8d28\u91cf\u5206\" stat=\"avg(score,behavior_type == '1')\" dimens=\"recall_no\"  />"), Pair.of((Object)"1-hour", (Object)"<stat-item  title=\"\u6bcf\u5c0f\u65f6_\u5404\u7701\u4efd_\u4e0b\u53d1\u91cftop100\" stat=\"count(behavior_type == '1')\" dimens=\"province\" limit=\"top100\" />"), Pair.of((Object)"1-minute", (Object)"<stat-item  title=\"\u6bcf\u5206\u949f_\u5404\u7701\u4efd_uv\" stat=\"bitcount(imei)\" dimens=\"province\"  />"), Pair.of((Object)"1-day", (Object)"<stat-item  title=\"\u6bcf\u5929_uv\u91cf\" stat=\"bitcount(imei)\"  />"), Pair.of((Object)"5-minute", (Object)"<stat-item  title=\"\u6bcf5\u5206\u949f_\u5404app\u7248\u672c_\u8bf7\u6c42\u91cftop50\" stat=\"bitcount(request_id)\" dimens=\"app_version\" limit=\"top50\" />"), Pair.of((Object)"1-day", (Object)"<stat-item  title=\"\u6bcf\u5929_\u70b9\u51fb\u7387\" stat=\"count(behavior_type == '2')/count(behavior_type == '1')\" />"), Pair.of((Object)"5-minute", (Object)"<stat-item  title=\"\u6bcf5\u5206\u949f_\u5404\u5206\u7c7b_\u70b9\u51fb\u7387top10\" stat=\"count(behavior_type == '2')/count(behavior_type == '1')\" dimens=\"top_level\" limit=\"top30\" />"));

    public static void main(String[] args) {
        try {
            LDPConfig.loadConfiguration();
            Group group = GroupHandler.queryGroupInfo("_demo_feed_behavior_stat");
            if (group == null) {
                User user = UserHandler.queryUserInfo("admin");
                Validate.notNull((Object)user);
                exampleContext.setAdminId(user.getId());
                exampleContext.setDepartmentId(user.getDepartmentId());
                Integer metaId = MetaHandler.queryValidMetaId();
                Validate.isTrue((metaId != null && metaId > 0 ? 1 : 0) != 0);
                exampleContext.setMetaId(metaId);
                StartExample.createExample();
                logger.info("Create statistic examples success!");
            } else {
                logger.info("Statistic examples already exists,groupId:" + group.getId());
                StartExample.startExample();
            }
        }
        catch (Exception ex) {
            logger.error("Failed to create statistic examples!", (Throwable)ex);
            System.exit(1);
        }
        System.exit(0);
    }

    public static void startExample() throws Exception {
        Group groupInfo = GroupHandler.queryGroupInfo("_demo_feed_behavior_stat");
        if (groupInfo == null) {
            return;
        }
        Connection conn = null;
        try {
            conn = (Connection)CMDBStorageEngineProxy.getInstance().getConnection();
            conn.setAutoCommit(false);
            StatHandler.startByGroupId(conn, groupInfo.getId());
            conn.commit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (conn != null) {
                conn.rollback();
            }
        }
        finally {
            CMDBStorageEngineProxy.getInstance().closeConnection();
        }
    }

    private static void createExample() throws Exception {
        Connection conn = null;
        try {
            conn = (Connection)CMDBStorageEngineProxy.getInstance().getConnection();
            conn.setAutoCommit(false);
            StartExample.createProject(conn);
            StartExample.createGroup(conn);
            StartExample.createStats(conn);
            conn.commit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (conn != null) {
                conn.rollback();
            }
        }
        finally {
            CMDBStorageEngineProxy.getInstance().closeConnection();
        }
    }

    private static void createProject(Connection conn) throws Exception {
        Project project = new Project();
        project.setTitle("XL-LightHouse\u6f14\u793a\u5de5\u7a0b");
        project.setBuiltIn(false);
        project.setDepartmentId(exampleContext.getDepartmentId());
        project.setPrivateType(PrivateTypeEnum.Public);
        project.setDesc("\u7528\u4e8e\u6f14\u793aXL-LightHouse\u9879\u76ee\u4f7f\u7528\uff01");
        LocalDateTime localDateTime = LocalDateTime.now();
        project.setCreateTime(localDateTime);
        project.setUpdateTime(localDateTime);
        Integer projectId = ProjectHandler.createProject(conn, project);
        int departmentManageRoleId = RoleHandler.queryRoleId(conn, project.getDepartmentId(), RoleTypeEnum.DEPARTMENT_MANAGE_PERMISSION);
        exampleContext.setDepartManageRoleId(departmentManageRoleId);
        Role manageRole = new Role();
        manageRole.setPid(Integer.valueOf(departmentManageRoleId));
        manageRole.setResourceId(projectId);
        manageRole.setRoleType(RoleTypeEnum.PROJECT_MANAGE_PERMISSION);
        manageRole.setCreateTime(localDateTime);
        manageRole.setUpdateTime(localDateTime);
        manageRole.setDesc(RoleTypeEnum.PROJECT_MANAGE_PERMISSION + "(" + project.getTitle() + ")");
        int manageRoleId = RoleHandler.createRole(conn, manageRole);
        exampleContext.setProjectManageRoleId(manageRoleId);
        int departmentAccessRoleId = RoleHandler.queryRoleId(conn, project.getDepartmentId(), RoleTypeEnum.DEPARTMENT_ACCESS_PERMISSION);
        exampleContext.setDepartAccessRoleId(departmentAccessRoleId);
        project.setId(projectId);
        exampleContext.setProject(project);
        Role accessRole = new Role();
        accessRole.setPid(Integer.valueOf(departmentAccessRoleId));
        accessRole.setResourceId(projectId);
        accessRole.setRoleType(RoleTypeEnum.PROJECT_ACCESS_PERMISSION);
        accessRole.setCreateTime(localDateTime);
        accessRole.setUpdateTime(localDateTime);
        accessRole.setDesc(RoleTypeEnum.PROJECT_ACCESS_PERMISSION + "(" + project.getTitle() + ")");
        int accessRoleId = RoleHandler.createRole(conn, accessRole);
        exampleContext.setProjectAccessRoleId(accessRoleId);
        Permission managePermission = new Permission();
        managePermission.setRoleId(Integer.valueOf(manageRoleId));
        managePermission.setOwnerId(exampleContext.getAdminId());
        managePermission.setOwnerType(OwnerTypeEnum.USER);
        managePermission.setCreateTime(localDateTime);
        managePermission.setUpdateTime(localDateTime);
        PermissionHandler.createPermission(conn, managePermission);
        Permission accessPermission = new Permission();
        accessPermission.setRoleId(Integer.valueOf(accessRoleId));
        accessPermission.setOwnerId(exampleContext.getAdminId());
        accessPermission.setOwnerType(OwnerTypeEnum.USER);
        accessPermission.setCreateTime(localDateTime);
        accessPermission.setUpdateTime(localDateTime);
        PermissionHandler.createPermission(conn, accessPermission);
        logger.info("create project example completed,projectId:{}", (Object)project.getId());
    }

    public static void createGroup(Connection connection) throws Exception {
        Group group = new Group();
        LocalDateTime localDateTime = LocalDateTime.now();
        group.setProjectId(exampleContext.getProject().getId());
        group.setState(GroupStateEnum.RUNNING);
        group.setRefreshTime(localDateTime);
        group.setUpdateTime(localDateTime);
        group.setCreateTime(localDateTime);
        group.setToken("_demo_feed_behavior_stat");
        String columns = "[{\"name\":\"request_id\",\"type\":\"string\",\"comment\":\"\u5217\u8868\u8bf7\u6c42ID\"},{\"name\":\"imei\",\"type\":\"string\",\"comment\":\"\u7528\u6237ID\"},{\"name\":\"behavior_type\",\"type\":\"string\",\"comment\":\"1\uff1a\u66dd\u5149\uff0c2\uff1a\u70b9\u51fb\"},{\"name\":\"province\",\"type\":\"string\",\"comment\":\"\u7528\u6237\u6240\u5728\u7701\u4efd\"},{\"name\":\"city\",\"type\":\"string\",\"comment\":\"\u7528\u6237\u6240\u5728\u57ce\u5e02\"},{\"name\":\"item_id\",\"type\":\"string\",\"comment\":\"\u5e16\u5b50ID\"},{\"name\":\"top_level\",\"type\":\"string\",\"comment\":\"\u5e16\u5b50\u4e00\u7ea7\u5206\u7c7b\"},{\"name\":\"sec_level\",\"type\":\"string\",\"comment\":\"\u5e16\u5b50\u4e8c\u7ea7\u5206\u7c7b\"},{\"name\":\"score\",\"type\":\"number\",\"comment\":\"\u5e16\u5b50\u8d28\u91cf\u5206\"},{\"name\":\"recall_no\",\"type\":\"string\",\"comment\":\"\u53ec\u56de\u6a21\u578b\u6807\u8bc6\"},{\"name\":\"app_version\",\"type\":\"string\",\"comment\":\"APP\u7248\u672c\u53f7\"}]";
        List columnList = JsonUtil.toJavaObjectList((String)columns, Column.class);
        group.setColumns(columnList);
        group.setRandomId(RandomID.id((int)32));
        group.setSecretKey(RandomID.id((int)40));
        group.setDesc("Feed\u53ec\u56de\u5217\u8868\u7528\u6237\u884c\u4e3a\u6570\u636e\u7edf\u8ba1\uff0c\u5305\u62ec\u66dd\u5149\u91cf\u3001\u70b9\u51fb\u91cf\u3001\u70b9\u51fb\u7387\u7b49\u6307\u6807\u6570\u636e\u3002");
        Integer groupId = GroupHandler.createGroup(connection, group);
        group.setId(groupId);
        exampleContext.setGroup(group);
        Role manageRole = new Role();
        manageRole.setPid(exampleContext.getProjectManageRoleId());
        manageRole.setResourceId(groupId);
        manageRole.setRoleType(RoleTypeEnum.GROUP_MANAGE_PERMISSION);
        manageRole.setCreateTime(localDateTime);
        manageRole.setUpdateTime(localDateTime);
        manageRole.setDesc(RoleTypeEnum.GROUP_MANAGE_PERMISSION + "(" + group.getToken() + ")");
        int manageRoleId = RoleHandler.createRole(connection, manageRole);
        exampleContext.setGroupManageRoleId(manageRoleId);
        Role accessRole = new Role();
        accessRole.setPid(exampleContext.getProjectAccessRoleId());
        accessRole.setResourceId(groupId);
        accessRole.setRoleType(RoleTypeEnum.GROUP_ACCESS_PERMISSION);
        accessRole.setCreateTime(localDateTime);
        accessRole.setUpdateTime(localDateTime);
        accessRole.setDesc(RoleTypeEnum.GROUP_ACCESS_PERMISSION + "(" + group.getToken() + ")");
        int accessRoleId = RoleHandler.createRole(connection, accessRole);
        exampleContext.setGroupAccessRoleId(accessRoleId);
        Permission managePermission = new Permission();
        managePermission.setRoleId(Integer.valueOf(manageRoleId));
        managePermission.setOwnerId(exampleContext.getAdminId());
        managePermission.setOwnerType(OwnerTypeEnum.USER);
        managePermission.setCreateTime(localDateTime);
        managePermission.setUpdateTime(localDateTime);
        PermissionHandler.createPermission(connection, managePermission);
        Permission accessPermission = new Permission();
        accessPermission.setRoleId(Integer.valueOf(accessRoleId));
        accessPermission.setOwnerId(exampleContext.getAdminId());
        accessPermission.setOwnerType(OwnerTypeEnum.USER);
        accessPermission.setCreateTime(localDateTime);
        accessPermission.setUpdateTime(localDateTime);
        PermissionHandler.createPermission(connection, accessPermission);
        logger.info("create group example completed,groupId:{}", (Object)group.getId());
    }

    public static void createStats(Connection connection) throws Exception {
        ArrayList<Stat> statList = new ArrayList<Stat>();
        for (Pair<String, String> pair : templateList) {
            String timeParam = (String)pair.getLeft();
            String template = (String)pair.getRight();
            TemplateContext templateContext = new TemplateContext(template, timeParam, exampleContext.getGroup().getColumns());
            ServiceResult serviceResult = TemplateParser.parseConfig((TemplateContext)templateContext);
            TemplateEntity templateEntity = (TemplateEntity)serviceResult.getData();
            Stat stat = new Stat();
            stat.setState(StatStateEnum.RUNNING);
            LocalDateTime localDateTime = LocalDateTime.now();
            stat.setRefreshTime(localDateTime);
            stat.setCreateTime(localDateTime);
            stat.setUpdateTime(localDateTime);
            stat.setRandomId(RandomID.id((int)32));
            stat.setMetaId(exampleContext.getMetaId());
            stat.setTitle(templateEntity.getTitle());
            stat.setDesc(templateEntity.getTitle());
            stat.setTemplate(template);
            stat.setProjectId(exampleContext.getProject().getId());
            stat.setGroupId(exampleContext.getGroup().getId());
            stat.setTimeparam(timeParam);
            stat.setExpired(Long.valueOf(1209600L));
            statList.add(stat);
        }
        List<Integer> ids = StatHandler.createStats(connection, statList);
        LocalDateTime localDateTime = LocalDateTime.now();
        for (int i = 0; i < ids.size(); ++i) {
            Integer id = ids.get(i);
            Stat stat = (Stat)statList.get(i);
            Role manageRole = new Role();
            manageRole.setPid(exampleContext.getGroupManageRoleId());
            manageRole.setResourceId(id);
            manageRole.setRoleType(RoleTypeEnum.STAT_MANAGE_PERMISSION);
            manageRole.setCreateTime(localDateTime);
            manageRole.setUpdateTime(localDateTime);
            manageRole.setDesc(RoleTypeEnum.STAT_MANAGE_PERMISSION + "(" + stat.getTitle() + ")");
            int manageRoleId = RoleHandler.createRole(connection, manageRole);
            Role accessRole = new Role();
            accessRole.setPid(exampleContext.getGroupAccessRoleId());
            accessRole.setResourceId(id);
            accessRole.setRoleType(RoleTypeEnum.STAT_ACCESS_PERMISSION);
            accessRole.setCreateTime(localDateTime);
            accessRole.setUpdateTime(localDateTime);
            accessRole.setDesc(RoleTypeEnum.STAT_ACCESS_PERMISSION + "(" + stat.getTitle() + ")");
            int accessRoleId = RoleHandler.createRole(connection, accessRole);
            Permission managePermission = new Permission();
            managePermission.setRoleId(Integer.valueOf(manageRoleId));
            managePermission.setOwnerId(exampleContext.getAdminId());
            managePermission.setOwnerType(OwnerTypeEnum.USER);
            managePermission.setCreateTime(localDateTime);
            managePermission.setUpdateTime(localDateTime);
            PermissionHandler.createPermission(connection, managePermission);
            Permission accessPermission = new Permission();
            accessPermission.setRoleId(Integer.valueOf(accessRoleId));
            accessPermission.setOwnerId(exampleContext.getAdminId());
            accessPermission.setOwnerType(OwnerTypeEnum.USER);
            accessPermission.setCreateTime(localDateTime);
            accessPermission.setUpdateTime(localDateTime);
            PermissionHandler.createPermission(connection, accessPermission);
            logger.info("create statistic example completed,statId:{}", (Object)id);
        }
    }
}

