/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.builtin;

import com.dtstep.lighthouse.common.entity.group.GroupExtEntity;
import com.dtstep.lighthouse.common.entity.stat.StatExtEntity;
import com.dtstep.lighthouse.common.entity.stat.TimeParam;
import com.dtstep.lighthouse.common.enums.ColumnTypeEnum;
import com.dtstep.lighthouse.common.enums.GroupStateEnum;
import com.dtstep.lighthouse.common.enums.StatStateEnum;
import com.dtstep.lighthouse.common.modal.Column;
import com.dtstep.lighthouse.common.modal.Project;
import com.dtstep.lighthouse.common.modal.RenderConfig;
import com.dtstep.lighthouse.common.modal.Stat;
import com.dtstep.lighthouse.common.util.JsonUtil;
import com.dtstep.lighthouse.common.util.Md5Util;
import com.dtstep.lighthouse.common.util.StringUtil;
import com.dtstep.lighthouse.core.wrapper.StatDBWrapper;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BuiltinLoader {
    private static final HashMap<Integer, GroupExtEntity> builtinGroups = new HashMap();
    private static final HashMap<Integer, StatExtEntity> builtinStats = new HashMap();
    private static final HashMap<Integer, List<StatExtEntity>> groupStatsMapping = new HashMap();
    private static final Logger logger = LoggerFactory.getLogger(BuiltinLoader.class);
    private static final Project builtinProject = new Project();
    private static final String secretKey = "2l2ipBHOssTzsHsdErKDcarxjU6rKZwo";
    private static final String groupRandomId = "XjElwfhjXKB7dNzcIHsQ767fPXkTLKsB";
    private static final int dataVersion = 0;

    public static StatExtEntity getBuiltinStat(int statId) {
        return builtinStats.getOrDefault(statId, null);
    }

    public static boolean isBuiltinStat(int statId) {
        return builtinStats.containsKey(statId);
    }

    public static boolean isBuiltinGroup(int groupId) {
        return builtinGroups.containsKey(groupId);
    }

    public static boolean isBuiltinGroup(String token) {
        for (GroupExtEntity groupExtEntity : builtinGroups.values()) {
            if (!groupExtEntity.getToken().equals(token)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBuiltinProject(int projectId) {
        return projectId == builtinProject.getId();
    }

    public static Project getBuiltinProject() {
        return builtinProject;
    }

    public static GroupExtEntity getBuiltinGroup(int monitorGroupId) {
        return builtinGroups.getOrDefault(monitorGroupId, null);
    }

    public static GroupExtEntity getBuiltinGroup(String token) {
        for (GroupExtEntity groupExtEntity : builtinGroups.values()) {
            if (!groupExtEntity.getToken().equals(token)) continue;
            return groupExtEntity;
        }
        return null;
    }

    public static List<GroupExtEntity> getAllGroups() {
        return new ArrayList<GroupExtEntity>(builtinGroups.values());
    }

    public static List<StatExtEntity> getAllStats() {
        return new ArrayList<StatExtEntity>(builtinStats.values());
    }

    public static List<StatExtEntity> getBuiltinStatByGroupId(int groupId) {
        return groupStatsMapping.get(groupId);
    }

    private static void loadBuiltInStats() throws Exception {
        InputStream inputStream = BuiltinLoader.class.getResourceAsStream("builtin-stats.xml");
        Document document = Jsoup.parse((InputStream)inputStream, (String)"utf-8", (String)"");
        Elements elements = document.getElementsByTag("monitor-group");
        if (elements == null || elements.isEmpty()) {
            return;
        }
        for (Element element : elements) {
            GroupExtEntity groupExtEntity = new GroupExtEntity();
            int groupId = Integer.parseInt(element.attr("id"));
            String token = element.attr("token");
            groupExtEntity.setId(Integer.valueOf(groupId));
            groupExtEntity.setToken(token);
            groupExtEntity.setSecretKey(secretKey);
            groupExtEntity.setProjectId(builtinProject.getId());
            groupExtEntity.setBuiltIn(true);
            groupExtEntity.setMinTimeParam(new TimeParam(1, TimeUnit.MINUTES));
            groupExtEntity.setVerifyKey(Md5Util.getMD5((String)secretKey));
            groupExtEntity.setDataVersion(Integer.valueOf(0));
            groupExtEntity.setRandomId(groupRandomId);
            Elements columnElements = element.getElementsByTag("column");
            ArrayList<Column> columnList = new ArrayList<Column>();
            for (Element columnElement : columnElements) {
                String columnName = columnElement.attr("name");
                String columnType = columnElement.attr("type");
                Column metaColumn = new Column();
                metaColumn.setName(columnName);
                metaColumn.setType(columnType != null && columnType.equals("number") ? ColumnTypeEnum.NUMBER : ColumnTypeEnum.STRING);
                columnList.add(metaColumn);
            }
            Map<String, ColumnTypeEnum> columnHashMap = columnList.stream().collect(Collectors.toMap(Column::getName, Column::getType));
            groupExtEntity.setAllRelatedColumns(columnHashMap);
            groupExtEntity.setRunningRelatedColumns(columnHashMap);
            groupExtEntity.setState(GroupStateEnum.RUNNING);
            groupExtEntity.setColumns(columnList);
            builtinGroups.put(groupId, groupExtEntity);
            Elements statList = element.getElementsByTag("monitor-item");
            if (statList == null || statList.isEmpty()) continue;
            String groupColumns = JsonUtil.toJSONString(columnList);
            LocalDateTime localDateTime = LocalDateTime.now();
            for (Element statElement : statList) {
                StatExtEntity statExtEntity;
                int statId = Integer.parseInt(statElement.attr("id"));
                String timeParam = statElement.attr("timeparam");
                String renderConfig = statElement.attr("renderConfig");
                Elements templateElements = statElement.getElementsByTag("template");
                Element templateElement = (Element)templateElements.get(0);
                String template = templateElement.html();
                Stat statEntity = new Stat();
                statEntity.setTemplate(template);
                statEntity.setTimeparam(timeParam);
                statEntity.setId(Integer.valueOf(statId));
                statEntity.setProjectId(builtinProject.getId());
                statEntity.setGroupId(Integer.valueOf(groupId));
                statEntity.setMetaId(Integer.valueOf(-1));
                statEntity.setExpired(Long.valueOf(1209600L));
                statEntity.setCreateTime(localDateTime);
                statEntity.setUpdateTime(localDateTime);
                statEntity.setGroupColumns(groupColumns);
                statEntity.setRandomId("XjElwfhjXKB7dNzcIHsQ767fPXkTLKsB_" + statId);
                statEntity.setState(StatStateEnum.RUNNING);
                statEntity.setProjectTitle(builtinProject.getTitle());
                if (StringUtil.isNotEmpty((String)renderConfig)) {
                    statEntity.setRenderConfig((RenderConfig)JsonUtil.toJavaObject((String)renderConfig, RenderConfig.class));
                }
                if ((statExtEntity = StatDBWrapper.combineExtInfo(statEntity, true)) == null) continue;
                statExtEntity.setBuiltIn(true);
                statExtEntity.setNeedAlarm(false);
                statExtEntity.setToken(token);
                statExtEntity.setDataVersion(Integer.valueOf(0));
                statExtEntity.setTitle(statExtEntity.getTemplateEntity().getTitle());
                List groupStats = groupStatsMapping.getOrDefault(groupId, new ArrayList());
                groupStats.add(statExtEntity);
                groupStatsMapping.put(groupId, groupStats);
                builtinStats.put(statId, statExtEntity);
            }
        }
    }

    static {
        builtinProject.setTitle("Cluster Monitor");
        builtinProject.setId(Integer.valueOf(1));
        builtinProject.setBuiltIn(true);
        try {
            BuiltinLoader.loadBuiltInStats();
        }
        catch (Exception ex) {
            logger.error("load builtin stat error!", (Throwable)ex);
        }
    }
}

