/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.config;

import com.dtstep.lighthouse.common.enums.RunningMode;
import com.dtstep.lighthouse.common.exception.InitializationException;
import com.dtstep.lighthouse.common.exception.LDPUncaughtExceptionHandler;
import com.dtstep.lighthouse.common.util.FileUtil;
import com.dtstep.lighthouse.common.util.StringUtil;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LDPConfig {
    private static final Logger logger = LoggerFactory.getLogger(LDPConfig.class);
    private static Map<String, String> paramMap = Maps.newHashMap();
    public static final String KEY_KAFKA_BOOTSTRAP_SERVERS = "kafka.bootstrap.servers";
    public static final String KEY_KAFKA_TOPIC_NAME = "kafka.topic.name";
    public static final String KEY_REDIS_CLUSTER = "redis.cluster";
    public static final String KEY_REDIS_CLUSTER_PASSWORD = "redis.cluster.password";
    public static final String KEY_LIMITING_GROUP_MESSAGE_SIZE_PER_SEC = "limiting.group.message.size.per.sec";
    public static final String KEY_LIMITING_STAT_RESULT_SIZE_PER_SEC = "limiting.stat.result.size.per.sec";
    public static final String KEY_LIGHTHOUSE_LIMITING_ENABLED = "limiting.enabled";
    public static final String KEY_LIGHTHOUSE_ICE_LOCATORS = "lighthouse.ice.locators";
    public static final String KEY_LIGHTHOUSE_ICE_IPS = "lighthouse.ice.ips";
    public static final String KEY_DATA_COMPRESSION_TYPE = "data.storage.compression.type";
    public static final String KEY_CLUSTER_ID = "lighthouse.cluster.id";
    public static final String KEY_RUNNING_MODE = "lighthouse.running.mode";
    public static final String KEY_HOME_PATH = "ldp_home";
    public static final String KEY_DATA_DIR = "lighthouse.data.dir";
    public static final String KEY_CMDB_STORAGE_ENGINE = "cmdb.storage.engine";
    public static final String KEY_WAREHOUSE_STORAGE_ENGINE = "warehouse.storage.engine";
    private static RunningMode runningMode;
    public static final AtomicBoolean isInit;

    public static void loadConfiguration() throws Exception {
        String ldpHome = System.getenv("LDP_HOME");
        if (StringUtil.isEmpty((String)ldpHome)) {
            logger.error("lighthouse component start error,system environment variable[LDP_HOME] does not exist!");
            throw new InitializationException();
        }
        LDPConfig.initWithHomePath(ldpHome);
    }

    public static synchronized void initWithHomePath(String homePath) throws Exception {
        if (isInit.get()) {
            return;
        }
        boolean is = FileUtil.isFileExist((String)homePath);
        if (!is) {
            throw new FileNotFoundException(String.format("home path[%s] not found!", homePath));
        }
        String siteFilePath = homePath + "/conf/ldp-site.xml";
        is = FileUtil.isFileExist((String)siteFilePath);
        if (!is) {
            throw new FileNotFoundException(String.format("configuration file[%s] not found!", siteFilePath));
        }
        paramMap.put(KEY_HOME_PATH, homePath);
        LDPConfig.init(siteFilePath);
    }

    public static synchronized void init(String confPath) throws Exception {
        if (isInit.get()) {
            return;
        }
        boolean is = FileUtil.isFileExist((String)confPath);
        if (!is) {
            throw new FileNotFoundException(String.format("configuration file[%s] not found!", confPath));
        }
        File file = new File(confPath);
        Document document = Jsoup.parse((File)file, (String)"utf-8");
        LDPConfig.parseProperties(document.select("configuration > property"), "", paramMap);
        paramMap = Collections.unmodifiableMap(paramMap);
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new LDPUncaughtExceptionHandler());
        isInit.set(true);
    }

    private static void parseProperties(Elements elements, String parentKey, Map<String, String> keyValuePairs) {
        for (Element element : elements) {
            if (!element.tagName().equals("property")) continue;
            String name = element.selectFirst("name").text();
            String value = element.selectFirst("value").text();
            String fullKey = parentKey.isEmpty() ? name : parentKey + "." + name;
            keyValuePairs.put(fullKey, value);
            Elements childProperties = element.select("properties > property");
            if (childProperties.isEmpty()) continue;
            LDPConfig.parseProperties(childProperties, fullKey, keyValuePairs);
        }
    }

    public static String getHomeDir() {
        return paramMap.get(KEY_HOME_PATH);
    }

    public static String getDataDir() {
        return paramMap.get(KEY_DATA_DIR);
    }

    public static RunningMode getRunningMode() {
        if (runningMode != null) {
            return runningMode;
        }
        String mode = paramMap.get(KEY_RUNNING_MODE);
        runningMode = StringUtil.isNotEmpty((String)mode) && mode.equals("standalone") ? RunningMode.STANDALONE : RunningMode.CLUSTER;
        return runningMode;
    }

    public static Map<String, String> getConf() {
        return paramMap;
    }

    public static String getVal(String param) {
        if (paramMap.containsKey(param)) {
            return paramMap.get(param);
        }
        return null;
    }

    public static <T> T getOrDefault(String param, T defaultValue, Class<T> clazz) {
        String temp = LDPConfig.getVal(param);
        if (StringUtil.isEmpty((String)temp)) {
            return defaultValue;
        }
        if (clazz == Integer.class) {
            return clazz.cast(Integer.parseInt(temp));
        }
        if (clazz == Boolean.class) {
            return clazz.cast("true".equals(temp));
        }
        if (clazz == Long.class) {
            return clazz.cast(Long.parseLong(temp));
        }
        if (clazz == String.class) {
            return clazz.cast(temp);
        }
        return defaultValue;
    }

    public static boolean limitedEnable() {
        return LDPConfig.getOrDefault(KEY_LIGHTHOUSE_LIMITING_ENABLED, true, Boolean.class);
    }

    static {
        isInit = new AtomicBoolean(false);
    }
}

