/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.consumer;

import com.dtstep.lighthouse.common.aggregator.EventPool;
import com.dtstep.lighthouse.common.aggregator.SlotsGroup;
import com.dtstep.lighthouse.common.entity.event.SimpleSlotEvent;
import com.dtstep.lighthouse.common.entity.stat.StatExtEntity;
import com.dtstep.lighthouse.common.entity.state.StatState;
import com.dtstep.lighthouse.common.enums.function.FunctionEnum;
import com.dtstep.lighthouse.common.modal.MetaTable;
import com.dtstep.lighthouse.common.util.DateUtil;
import com.dtstep.lighthouse.common.util.JsonUtil;
import com.dtstep.lighthouse.common.util.StringUtil;
import com.dtstep.lighthouse.core.consumer.AggregateEvent;
import com.dtstep.lighthouse.core.functions.BitCountStatProcess;
import com.dtstep.lighthouse.core.functions.CountStatProcess;
import com.dtstep.lighthouse.core.functions.DimensStatProcess;
import com.dtstep.lighthouse.core.functions.MaxStatProcess;
import com.dtstep.lighthouse.core.functions.MinStatProcess;
import com.dtstep.lighthouse.core.functions.SeqStatProcess;
import com.dtstep.lighthouse.core.functions.SumStatProcess;
import com.dtstep.lighthouse.core.plugins.PluginManager;
import com.dtstep.lighthouse.core.plugins.StatAlarmPlugin;
import com.dtstep.lighthouse.core.wrapper.MetaTableWrapper;
import com.dtstep.lighthouse.core.wrapper.StatDBWrapper;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExpandedEventRunnable
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ExpandedEventRunnable.class);
    private static final long _threadConsumePeriod = TimeUnit.SECONDS.toMillis(15L);
    private static final long _maximumBacklogPeriod = TimeUnit.MINUTES.toMillis(2L);
    private final EventPool<SimpleSlotEvent> eventPool;
    private static final int batchLimitSize = 15000;

    ExpandedEventRunnable(EventPool<SimpleSlotEvent> eventPool) {
        this.eventPool = eventPool;
    }

    @Override
    public void run() {
        IntStream.range(0, this.eventPool.slotSize()).forEach(this::consumer);
    }

    private void consumer(int slot) {
        try {
            SlotsGroup.SlotWrapper slotWrapper = this.eventPool.take(slot);
            while ((double)slotWrapper.size() > 75000.0 || System.currentTimeMillis() - slotWrapper.getLastAccessTime() > _threadConsumePeriod || System.currentTimeMillis() - slotWrapper.getHeadElementTime() > _maximumBacklogPeriod) {
                StopWatch stopWatch = new StopWatch();
                stopWatch.start();
                List events = slotWrapper.getEvents(15000);
                if (!CollectionUtils.isEmpty((Collection)events)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("process expanded events start,thread:{},slot:{},process size:{}", new Object[]{Thread.currentThread().getName(), slot, events.size()});
                    }
                    if (logger.isTraceEnabled()) {
                        events.forEach(z -> logger.trace("event consumer message:[{}],repeat:[{}]", (Object)z.getMessage(), (Object)z.getRepeat()));
                    }
                    ArrayList aggregateEvents = Lists.newArrayListWithCapacity((int)10000);
                    Map<String, Long> counterMap = events.parallelStream().collect(Collectors.groupingBy(SimpleSlotEvent::getMessage, Collectors.summingLong(SimpleSlotEvent::getRepeat)));
                    for (Map.Entry<String, Long> entry : counterMap.entrySet()) {
                        Iterator iterator = Splitter.on((String)"\u0004").split((CharSequence)entry.getKey()).iterator();
                        AggregateEvent aggregateEvent = new AggregateEvent((String)iterator.next(), Integer.parseInt((String)iterator.next()), (String)iterator.next(), (String)iterator.next(), Integer.parseInt((String)iterator.next()), Long.parseLong((String)iterator.next()), entry.getValue());
                        aggregateEvents.add(aggregateEvent);
                    }
                    Map<String, List<AggregateEvent>> eventMap = aggregateEvents.parallelStream().collect(Collectors.groupingBy(AggregateEvent::getAggregateKey));
                    for (Map.Entry<String, List<AggregateEvent>> stringListEntry : eventMap.entrySet()) {
                        List<AggregateEvent> lists = stringListEntry.getValue();
                        AggregateEvent entity = lists.get(0);
                        List<Pair<String, Long>> dataList = lists.stream().map(x -> Pair.of((Object)x.getData(), (Object)x.getRepeat())).collect(Collectors.toList());
                        this.consumer(entity.getStatId(), entity.getAggregateKey(), entity.getFunctionIndex(), entity.getDimensValue(), entity.getBatchTime(), dataList);
                    }
                    long l = stopWatch.getTime();
                    logger.info("process expanded events,thread:{},slot:{},process size:{},remaining size:{},eventMap size:{},accessTime:{},cost:{}ms", new Object[]{Thread.currentThread().getName(), slot, events.size(), slotWrapper.size(), eventMap.size(), slotWrapper.getLastAccessTime(), l});
                    if (l <= _threadConsumePeriod) continue;
                    logger.warn("batch processing expanded events takes too long, and may cause message delays,thread:{},slot:{},cost:{}", new Object[]{Thread.currentThread().getName(), slot, String.format("[%sms > %sms]", l, _threadConsumePeriod)});
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            logger.error("process expanded events error!", (Throwable)ex);
        }
    }

    private void consumer(int statId, String aggregateKey, int functionIndex, String dimensValue, long batchTime, List<Pair<String, Long>> eventList) throws Exception {
        String metaName;
        StatExtEntity statExtEntity = StatDBWrapper.queryById(statId);
        if (statExtEntity == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("expanded consumer runnable,statId:{},aggregateKey:{},functionIndex:{},dimensValue:{},batchTime:{}", new Object[]{statId, aggregateKey, functionIndex, dimensValue, DateUtil.formatTimeStamp((long)batchTime, (String)"yyyy-MM-dd HH:mm:ss")});
        }
        Optional<StatAlarmPlugin> plugin = PluginManager.getAlarmPlugin();
        plugin.ifPresent(statAlarmPlugin -> statAlarmPlugin.trigger(statExtEntity, batchTime, dimensValue));
        if (!StringUtil.isEmpty((String)statExtEntity.getTemplateEntity().getDimens())) {
            try {
                DimensStatProcess.getInstance().process(statExtEntity, dimensValue);
            }
            catch (Exception ex) {
                logger.error("save dimens info error,statId:{},dimensValue:{}", new Object[]{statExtEntity.getId(), dimensValue, ex});
            }
        }
        StatState statState = (StatState)statExtEntity.getTemplateEntity().getStatStateList().get(functionIndex);
        FunctionEnum functionEnum = statState.getFunctionEnum();
        int metaId = statExtEntity.getMetaId();
        if (metaId == -1) {
            metaName = "ldp_system_result";
        } else {
            MetaTable metaTable = MetaTableWrapper.queryById(metaId);
            if (metaTable != null) {
                metaName = metaTable.getMetaName();
            } else {
                logger.error("get meta info error,statId:{},metaId:{}", (Object)statId, (Object)metaId);
                return;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("expanded consumer runnable,statId:{},aggregateKey:{},functionIndex:{},dimensValue:{},batchTime:{},metaName:{}", new Object[]{statId, aggregateKey, functionIndex, dimensValue, DateUtil.formatTimeStamp((long)batchTime, (String)"yyyy-MM-dd HH:mm:ss"), metaName});
        }
        if (logger.isTraceEnabled()) {
            logger.trace("expanded consumer runnable,statId:{},aggregateKey:{},dimensValue:{},batchTime:{},eventList:{}", new Object[]{statId, aggregateKey, dimensValue, batchTime, JsonUtil.toJSONString(eventList)});
        }
        switch (functionEnum) {
            case COUNT: {
                CountStatProcess countStatProcess = new CountStatProcess(statExtEntity, metaName, aggregateKey, dimensValue);
                countStatProcess.evaluate(statState, eventList, batchTime);
                break;
            }
            case BITCOUNT: {
                BitCountStatProcess bitStatProcess = new BitCountStatProcess(statExtEntity, metaName, aggregateKey, dimensValue);
                bitStatProcess.evaluate(statState, eventList, batchTime);
                break;
            }
            case SUM: {
                SumStatProcess sumStatProcess = new SumStatProcess(statExtEntity, metaName, aggregateKey, dimensValue);
                sumStatProcess.evaluate(statState, eventList, batchTime);
                break;
            }
            case MAX: {
                MaxStatProcess maxStatProcess = new MaxStatProcess(statExtEntity, metaName, aggregateKey, dimensValue);
                maxStatProcess.evaluate(statState, eventList, batchTime);
                break;
            }
            case MIN: {
                MinStatProcess minStatProcess = new MinStatProcess(statExtEntity, metaName, aggregateKey, dimensValue);
                minStatProcess.evaluate(statState, eventList, batchTime);
                break;
            }
            case SEQ: {
                SeqStatProcess seqStatProcess = new SeqStatProcess(statExtEntity, metaName, aggregateKey, dimensValue);
                seqStatProcess.evaluate(statState, eventList, batchTime);
                break;
            }
        }
    }
}

