/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.consumer;

import com.dtstep.lighthouse.common.aggregator.BlockingEventPool;
import com.dtstep.lighthouse.common.aggregator.EventPool;
import com.dtstep.lighthouse.common.entity.event.SimpleSlotEvent;
import com.dtstep.lighthouse.common.entity.event.SlotEvent;
import com.dtstep.lighthouse.common.util.StringUtil;
import com.dtstep.lighthouse.core.consumer.ExpandedConsumer;
import com.dtstep.lighthouse.core.preparing.handler.expand.ExpandEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RealTimeProcessor {
    private static final Logger logger = LoggerFactory.getLogger(RealTimeProcessor.class);
    private static EventPool<SimpleSlotEvent> eventPool;
    private static final int consumerThreadSize = 5;

    public static void onEvent(int slot, String message, int repeat) {
        try {
            if (StringUtil.isNotEmpty((String)message)) {
                eventPool.put(slot, (SlotEvent)new SimpleSlotEvent(message, repeat));
            }
        }
        catch (Exception ex) {
            logger.error("process expanded events error!", (Throwable)ex);
        }
    }

    public static void onEvent(ExpandEvent expandEvent) {
        try {
            if (expandEvent != null) {
                eventPool.put(expandEvent.getSlot(), (SlotEvent)new SimpleSlotEvent(expandEvent.getMessage(), expandEvent.getRepeat()));
            }
        }
        catch (Exception ex) {
            logger.error("process expanded events error!", (Throwable)ex);
        }
    }

    static {
        try {
            eventPool = new BlockingEventPool("ExpandedEventPool", 10, 500000);
            ExpandedConsumer expandedConsumer = new ExpandedConsumer(eventPool, 5);
            expandedConsumer.start();
        }
        catch (Exception ex) {
            logger.error("lighthouse tasks consumer start error!", (Throwable)ex);
        }
    }
}

