/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.dao;

import com.dtstep.lighthouse.common.exception.InitializationException;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RDBMSConfiguration
implements Serializable {
    private String database;
    private String driverClassName;
    private String connectionURL;
    private String connectionUserName;
    private String connectionPassword;

    public RDBMSConfiguration(String driverClassName, String connectionURL, String connectionUserName, String connectionPassword) {
        this.driverClassName = driverClassName;
        this.connectionURL = connectionURL;
        Pattern pattern = Pattern.compile("jdbc:mysql://(.*):(\\d+)/(.+)\\?.*");
        Matcher matcher = pattern.matcher(connectionURL);
        if (!matcher.find()) {
            throw new InitializationException("Failed to parse rdbms configuration!");
        }
        this.database = matcher.group(3);
        this.connectionUserName = connectionUserName;
        this.connectionPassword = connectionPassword;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public String getConnectionURL() {
        return this.connectionURL;
    }

    public void setConnectionURL(String connectionURL) {
        this.connectionURL = connectionURL;
    }

    public String getConnectionUserName() {
        return this.connectionUserName;
    }

    public void setConnectionUserName(String connectionUserName) {
        this.connectionUserName = connectionUserName;
    }

    public String getConnectionPassword() {
        return this.connectionPassword;
    }

    public void setConnectionPassword(String connectionPassword) {
        this.connectionPassword = connectionPassword;
    }
}

