/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.expression.embed;

import com.dtstep.lighthouse.common.util.StringUtil;
import com.dtstep.lighthouse.core.expression.embed.aviator.ContainsFunction;
import com.dtstep.lighthouse.core.expression.embed.aviator.DateFormatFunction;
import com.dtstep.lighthouse.core.expression.embed.aviator.DateParseFunction;
import com.dtstep.lighthouse.core.expression.embed.aviator.DaySubFunction;
import com.dtstep.lighthouse.core.expression.embed.aviator.EndsWithFunction;
import com.dtstep.lighthouse.core.expression.embed.aviator.HashCodeFunction;
import com.dtstep.lighthouse.core.expression.embed.aviator.HourSubFunction;
import com.dtstep.lighthouse.core.expression.embed.aviator.IsEmptyFunction;
import com.dtstep.lighthouse.core.expression.embed.aviator.IsInFunction;
import com.dtstep.lighthouse.core.expression.embed.aviator.IsNullFunction;
import com.dtstep.lighthouse.core.expression.embed.aviator.IsNumericFunction;
import com.dtstep.lighthouse.core.expression.embed.aviator.LeftFunction;
import com.dtstep.lighthouse.core.expression.embed.aviator.LenFunction;
import com.dtstep.lighthouse.core.expression.embed.aviator.LowerFunction;
import com.dtstep.lighthouse.core.expression.embed.aviator.MD5Function;
import com.dtstep.lighthouse.core.expression.embed.aviator.MinuteSubFunction;
import com.dtstep.lighthouse.core.expression.embed.aviator.ReplaceFunction;
import com.dtstep.lighthouse.core.expression.embed.aviator.ReverseFunction;
import com.dtstep.lighthouse.core.expression.embed.aviator.RightFunction;
import com.dtstep.lighthouse.core.expression.embed.aviator.SectionFunction;
import com.dtstep.lighthouse.core.expression.embed.aviator.SplitFunction;
import com.dtstep.lighthouse.core.expression.embed.aviator.StartWithFunction;
import com.dtstep.lighthouse.core.expression.embed.aviator.SubStrFunction;
import com.dtstep.lighthouse.core.expression.embed.aviator.TrimFunction;
import com.dtstep.lighthouse.core.expression.embed.aviator.UpperFunction;
import com.dtstep.lighthouse.core.formula.FormulaCalculate;
import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.AviatorEvaluatorInstance;
import com.googlecode.aviator.lexer.token.OperatorType;
import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.type.AviatorBoolean;
import com.googlecode.aviator.runtime.type.AviatorDecimal;
import com.googlecode.aviator.runtime.type.AviatorFunction;
import com.googlecode.aviator.runtime.type.AviatorLong;
import com.googlecode.aviator.runtime.type.AviatorNil;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorString;
import com.googlecode.aviator.runtime.type.AviatorType;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AviatorHandler {
    private static final Logger logger = LoggerFactory.getLogger(FormulaCalculate.class);
    private static final AviatorHandler aviatorHandler = new AviatorHandler();
    private static final AviatorEvaluatorInstance aviatorEvaluatorInstance = AviatorEvaluator.getInstance();

    public static AviatorHandler instance() {
        return aviatorHandler;
    }

    public static Object execute(String str) {
        if (StringUtil.isEmpty((String)str)) {
            return 999999999999999998L;
        }
        if (StringUtil.isNumber((String)str)) {
            return str;
        }
        try {
            return aviatorEvaluatorInstance.execute(str, null, true);
        }
        catch (Exception ex) {
            logger.error("aviator execute formula [{}] error!", (Object)str, (Object)ex);
            return null;
        }
    }

    public static boolean isNumber(AviatorObject object) {
        return object.getAviatorType() == AviatorType.Double || object.getAviatorType() == AviatorType.Decimal || object.getAviatorType() == AviatorType.Long || object.getAviatorType() == AviatorType.BigInt;
    }

    public static boolean isBoolFormula(String str, Map<String, Object> envMap) {
        if (StringUtil.isEmpty((String)str) || StringUtil.isLetterNumOrUnderLine((String)str)) {
            return false;
        }
        Object object = AviatorHandler.execute(str, envMap);
        return object instanceof Boolean;
    }

    public static boolean check(String str, Map<String, Object> envMap) {
        if (StringUtil.isEmpty((String)str) || StringUtil.isNumber((String)str)) {
            return false;
        }
        Object object = AviatorHandler.execute(str, envMap);
        return object instanceof Boolean && (Boolean)object != false;
    }

    public static void compileStatFormula(String str) throws Exception {
        Object object = aviatorEvaluatorInstance.execute(str, null, true);
        Validate.isTrue((boolean)StringUtil.isNumber((String)object.toString()));
    }

    public static void compileDimensFormula(String str, Map<String, Object> envMap) throws Exception {
        aviatorEvaluatorInstance.execute(str, null, true);
    }

    public static Object execute(String str, Map<String, Object> envMap) {
        if (StringUtil.isEmpty((String)str)) {
            return 999999999999999998L;
        }
        if (StringUtil.isNumber((String)str)) {
            return str;
        }
        if (envMap != null && envMap.containsKey(str)) {
            return envMap.get(str);
        }
        return aviatorEvaluatorInstance.execute(str, envMap, true);
    }

    static {
        aviatorEvaluatorInstance.setCachedExpressionByDefault(true);
        aviatorEvaluatorInstance.useLRUExpressionCache(80000);
        AviatorEvaluator.removeFunction((String)"contains");
        AviatorEvaluator.addFunction((AviatorFunction)new ContainsFunction());
        AviatorEvaluator.removeFunction((String)"endsWith");
        AviatorEvaluator.addFunction((AviatorFunction)new EndsWithFunction());
        AviatorEvaluator.removeFunction((String)"md5");
        AviatorEvaluator.addFunction((AviatorFunction)new MD5Function());
        AviatorEvaluator.removeFunction((String)"hashcode");
        AviatorEvaluator.addFunction((AviatorFunction)new HashCodeFunction());
        AviatorEvaluator.removeFunction((String)"left");
        AviatorEvaluator.addFunction((AviatorFunction)new LeftFunction());
        AviatorEvaluator.removeFunction((String)"len");
        AviatorEvaluator.addFunction((AviatorFunction)new LenFunction());
        AviatorEvaluator.removeFunction((String)"replace");
        AviatorEvaluator.addFunction((AviatorFunction)new ReplaceFunction());
        AviatorEvaluator.removeFunction((String)"reverse");
        AviatorEvaluator.addFunction((AviatorFunction)new ReverseFunction());
        AviatorEvaluator.removeFunction((String)"right");
        AviatorEvaluator.addFunction((AviatorFunction)new RightFunction());
        AviatorEvaluator.removeFunction((String)"split");
        AviatorEvaluator.addFunction((AviatorFunction)new SplitFunction());
        AviatorEvaluator.removeFunction((String)"startWith");
        AviatorEvaluator.addFunction((AviatorFunction)new StartWithFunction());
        AviatorEvaluator.removeFunction((String)"trim");
        AviatorEvaluator.addFunction((AviatorFunction)new TrimFunction());
        AviatorEvaluator.removeFunction((String)"dateFormat");
        AviatorEvaluator.addFunction((AviatorFunction)new DateFormatFunction());
        AviatorEvaluator.removeFunction((String)"dateParse");
        AviatorEvaluator.addFunction((AviatorFunction)new DateParseFunction());
        AviatorEvaluator.removeFunction((String)"toUpper");
        AviatorEvaluator.addFunction((AviatorFunction)new UpperFunction());
        AviatorEvaluator.removeFunction((String)"toLower");
        AviatorEvaluator.addFunction((AviatorFunction)new LowerFunction());
        AviatorEvaluator.removeFunction((String)"isIn");
        AviatorEvaluator.addFunction((AviatorFunction)new IsInFunction());
        AviatorEvaluator.removeFunction((String)"section");
        AviatorEvaluator.addFunction((AviatorFunction)new SectionFunction());
        AviatorEvaluator.removeFunction((String)"substr");
        AviatorEvaluator.addFunction((AviatorFunction)new SubStrFunction());
        AviatorEvaluator.removeFunction((String)"isEmpty");
        AviatorEvaluator.addFunction((AviatorFunction)new IsEmptyFunction());
        AviatorEvaluator.removeFunction((String)"isNull");
        AviatorEvaluator.addFunction((AviatorFunction)new IsNullFunction());
        AviatorEvaluator.removeFunction((String)"isNumeric");
        AviatorEvaluator.addFunction((AviatorFunction)new IsNumericFunction());
        AviatorEvaluator.removeFunction((String)"minuteSub");
        AviatorEvaluator.addFunction((AviatorFunction)new MinuteSubFunction());
        AviatorEvaluator.removeFunction((String)"hourSub");
        AviatorEvaluator.addFunction((AviatorFunction)new HourSubFunction());
        AviatorEvaluator.removeFunction((String)"daySub");
        AviatorEvaluator.addFunction((AviatorFunction)new DaySubFunction());
        AviatorEvaluator.addOpFunction((OperatorType)OperatorType.EQ, (AviatorFunction)new AbstractFunction(){
            private static final long serialVersionUID = 7858793601172630686L;

            public AviatorBoolean call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2) {
                String temp1 = String.valueOf(arg1.getValue(env));
                String temp2 = String.valueOf(arg2.getValue(env));
                if (temp1.trim().equals(temp2.trim())) {
                    return AviatorBoolean.TRUE;
                }
                if (StringUtil.isInt((String)temp1) && StringUtil.isInt((String)temp2)) {
                    long b;
                    long a = Long.parseLong(temp1);
                    return AviatorBoolean.valueOf((a == (b = Long.parseLong(temp2)) ? 1 : 0) != 0);
                }
                if ((AviatorHandler.isNumber(arg1) || StringUtil.isNumber((String)temp1)) && (AviatorHandler.isNumber(arg2) || StringUtil.isNumber((String)temp2))) {
                    BigDecimal a = new BigDecimal(temp1);
                    BigDecimal b = new BigDecimal(temp2);
                    return AviatorBoolean.valueOf((a.compareTo(b) == 0 ? 1 : 0) != 0);
                }
                return AviatorBoolean.valueOf((boolean)false);
            }

            public String getName() {
                return "==";
            }
        });
        AviatorEvaluator.addOpFunction((OperatorType)OperatorType.LT, (AviatorFunction)new AbstractFunction(){
            private static final long serialVersionUID = 1032142270615951426L;

            public AviatorBoolean call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2) {
                String temp1 = String.valueOf(arg1.getValue(env));
                String temp2 = String.valueOf(arg2.getValue(env));
                if (StringUtil.isEmpty((String)temp1) || StringUtil.isEmpty((String)temp2)) {
                    return AviatorBoolean.FALSE;
                }
                if (StringUtil.isInt((String)temp1) && StringUtil.isInt((String)temp2)) {
                    long b;
                    long a = Long.parseLong(temp1);
                    return AviatorBoolean.valueOf((a < (b = Long.parseLong(temp2)) ? 1 : 0) != 0);
                }
                if ((AviatorHandler.isNumber(arg1) || StringUtil.isNumber((String)temp1)) && (AviatorHandler.isNumber(arg2) || StringUtil.isNumber((String)temp2))) {
                    BigDecimal a = new BigDecimal(temp1);
                    BigDecimal b = new BigDecimal(temp2);
                    return AviatorBoolean.valueOf((a.compareTo(b) < 0 ? 1 : 0) != 0);
                }
                return AviatorBoolean.valueOf((temp1.compareTo(temp2) < 0 ? 1 : 0) != 0);
            }

            public String getName() {
                return "<";
            }
        });
        AviatorEvaluator.addOpFunction((OperatorType)OperatorType.LE, (AviatorFunction)new AbstractFunction(){
            private static final long serialVersionUID = 3358634192708716929L;

            public AviatorBoolean call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2) {
                String temp1 = String.valueOf(arg1.getValue(env));
                String temp2 = String.valueOf(arg2.getValue(env));
                if (StringUtil.isEmpty((String)temp1) || StringUtil.isEmpty((String)temp2)) {
                    return AviatorBoolean.FALSE;
                }
                if (StringUtil.isInt((String)temp1) && StringUtil.isInt((String)temp2)) {
                    long b;
                    long a = Long.parseLong(temp1);
                    return AviatorBoolean.valueOf((a <= (b = Long.parseLong(temp2)) ? 1 : 0) != 0);
                }
                if ((AviatorHandler.isNumber(arg1) || StringUtil.isNumber((String)temp1)) && (AviatorHandler.isNumber(arg2) || StringUtil.isNumber((String)temp2))) {
                    BigDecimal a = new BigDecimal(temp1);
                    BigDecimal b = new BigDecimal(temp2);
                    return AviatorBoolean.valueOf((a.compareTo(b) <= 0 ? 1 : 0) != 0);
                }
                return AviatorBoolean.valueOf((temp1.compareTo(temp2) <= 0 ? 1 : 0) != 0);
            }

            public String getName() {
                return "<=";
            }
        });
        AviatorEvaluator.addOpFunction((OperatorType)OperatorType.GT, (AviatorFunction)new AbstractFunction(){
            private static final long serialVersionUID = 309126794543864959L;

            public AviatorBoolean call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2) {
                String temp1 = String.valueOf(arg1.getValue(env));
                String temp2 = String.valueOf(arg2.getValue(env));
                if (StringUtil.isEmpty((String)temp1) || StringUtil.isEmpty((String)temp2)) {
                    return AviatorBoolean.FALSE;
                }
                if (StringUtil.isInt((String)temp1) && StringUtil.isInt((String)temp2)) {
                    long b;
                    long a = Long.parseLong(temp1);
                    return AviatorBoolean.valueOf((a > (b = Long.parseLong(temp2)) ? 1 : 0) != 0);
                }
                if ((AviatorHandler.isNumber(arg1) || StringUtil.isNumber((String)temp1)) && (AviatorHandler.isNumber(arg2) || StringUtil.isNumber((String)temp2))) {
                    BigDecimal a = new BigDecimal(temp1);
                    BigDecimal b = new BigDecimal(temp2);
                    return AviatorBoolean.valueOf((a.compareTo(b) > 0 ? 1 : 0) != 0);
                }
                return AviatorBoolean.valueOf((temp1.compareTo(temp2) > 0 ? 1 : 0) != 0);
            }

            public String getName() {
                return ">";
            }
        });
        AviatorEvaluator.addOpFunction((OperatorType)OperatorType.GE, (AviatorFunction)new AbstractFunction(){
            private static final long serialVersionUID = 476660652675389194L;

            public AviatorBoolean call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2) {
                String temp1 = String.valueOf(arg1.getValue(env));
                String temp2 = String.valueOf(arg2.getValue(env));
                if (StringUtil.isEmpty((String)temp1) || StringUtil.isEmpty((String)temp2)) {
                    return AviatorBoolean.FALSE;
                }
                if (StringUtil.isInt((String)temp1) && StringUtil.isInt((String)temp2)) {
                    long b;
                    long a = Long.parseLong(temp1);
                    return AviatorBoolean.valueOf((a >= (b = Long.parseLong(temp2)) ? 1 : 0) != 0);
                }
                if ((AviatorHandler.isNumber(arg1) || StringUtil.isNumber((String)temp1)) && (AviatorHandler.isNumber(arg2) || StringUtil.isNumber((String)temp2))) {
                    BigDecimal a = new BigDecimal(temp1);
                    BigDecimal b = new BigDecimal(temp2);
                    return AviatorBoolean.valueOf((a.compareTo(b) >= 0 ? 1 : 0) != 0);
                }
                return AviatorBoolean.valueOf((temp1.compareTo(temp2) >= 0 ? 1 : 0) != 0);
            }

            public String getName() {
                return ">=";
            }
        });
        AviatorEvaluator.addOpFunction((OperatorType)OperatorType.NEQ, (AviatorFunction)new AbstractFunction(){
            private static final long serialVersionUID = 309126794543864959L;

            public AviatorBoolean call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2) {
                String temp1 = String.valueOf(arg1.getValue(env));
                String temp2 = String.valueOf(arg2.getValue(env));
                if (StringUtil.isEmpty((String)temp1) && StringUtil.isEmpty((String)temp2)) {
                    return AviatorBoolean.FALSE;
                }
                if (StringUtil.isEmpty((String)temp1) || StringUtil.isEmpty((String)temp2)) {
                    return AviatorBoolean.TRUE;
                }
                if (StringUtil.isInt((String)temp1) && StringUtil.isInt((String)temp2)) {
                    int b;
                    int a = Integer.parseInt(temp1);
                    return AviatorBoolean.valueOf((a != (b = Integer.parseInt(temp2)) ? 1 : 0) != 0);
                }
                if ((AviatorHandler.isNumber(arg1) || StringUtil.isNumber((String)temp1)) && (AviatorHandler.isNumber(arg2) || StringUtil.isNumber((String)temp2))) {
                    BigDecimal a = new BigDecimal(temp1);
                    BigDecimal b = new BigDecimal(temp2);
                    return AviatorBoolean.valueOf((a.compareTo(b) != 0 ? 1 : 0) != 0);
                }
                return AviatorBoolean.valueOf((!temp1.equals(temp2) ? 1 : 0) != 0);
            }

            public String getName() {
                return "!=";
            }
        });
        AviatorEvaluator.addOpFunction((OperatorType)OperatorType.ADD, (AviatorFunction)new AbstractFunction(){
            private static final long serialVersionUID = 3358634192708716929L;

            public AviatorObject call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2) {
                String temp1 = String.valueOf(arg1.getValue(env));
                String temp2 = String.valueOf(arg2.getValue(env));
                if (StringUtil.isInt((String)temp1) && StringUtil.isInt((String)temp2)) {
                    long a = Long.parseLong(temp1);
                    long b = Long.parseLong(temp2);
                    return AviatorLong.valueOf((long)(a + b));
                }
                if ((AviatorHandler.isNumber(arg1) || StringUtil.isNumber((String)temp1)) && (AviatorHandler.isNumber(arg2) || StringUtil.isNumber((String)temp2))) {
                    BigDecimal a = new BigDecimal(temp1);
                    BigDecimal b = new BigDecimal(temp2);
                    AviatorDecimal c = AviatorDecimal.valueOf((BigDecimal)a.add(b));
                    return AviatorDecimal.valueOf((BigDecimal)a.add(b).setScale(3, RoundingMode.HALF_UP));
                }
                return new AviatorString(temp1 + temp2);
            }

            public String getName() {
                return "+";
            }
        });
        AviatorEvaluator.addOpFunction((OperatorType)OperatorType.MULT, (AviatorFunction)new AbstractFunction(){
            private static final long serialVersionUID = 3358634192708716929L;

            public AviatorObject call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2) {
                String temp1 = String.valueOf(arg1.getValue(env));
                String temp2 = String.valueOf(arg2.getValue(env));
                if ((AviatorHandler.isNumber(arg1) || StringUtil.isNumber((String)temp1)) && (AviatorHandler.isNumber(arg2) || StringUtil.isNumber((String)temp2))) {
                    BigDecimal a = new BigDecimal(temp1);
                    BigDecimal b = new BigDecimal(temp2);
                    return AviatorDecimal.valueOf((BigDecimal)a.multiply(b).setScale(3, RoundingMode.HALF_UP));
                }
                return AviatorNil.NIL;
            }

            public String getName() {
                return "*";
            }
        });
        AviatorEvaluator.addOpFunction((OperatorType)OperatorType.DIV, (AviatorFunction)new AbstractFunction(){
            private static final long serialVersionUID = 3358634192708716929L;

            public AviatorObject call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2) {
                String temp1 = String.valueOf(arg1.getValue(env));
                String temp2 = String.valueOf(arg2.getValue(env));
                if ((AviatorHandler.isNumber(arg1) || StringUtil.isNumber((String)temp1)) && (AviatorHandler.isNumber(arg2) || StringUtil.isNumber((String)temp2)) && Double.parseDouble(temp2) != 0.0) {
                    BigDecimal a = new BigDecimal(temp1);
                    BigDecimal b = new BigDecimal(temp2);
                    return AviatorDecimal.valueOf((BigDecimal)a.divide(b, 3, RoundingMode.HALF_UP));
                }
                return AviatorNil.NIL;
            }

            public String getName() {
                return "/";
            }
        });
        AviatorEvaluator.addOpFunction((OperatorType)OperatorType.SUB, (AviatorFunction)new AbstractFunction(){
            private static final long serialVersionUID = 3358634192708716929L;

            public AviatorObject call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2) {
                String temp1 = String.valueOf(arg1.getValue(env));
                String temp2 = String.valueOf(arg2.getValue(env));
                if ((AviatorHandler.isNumber(arg1) || StringUtil.isNumber((String)temp1)) && (AviatorHandler.isNumber(arg2) || StringUtil.isNumber((String)temp2)) && Double.parseDouble(temp2) != 0.0) {
                    BigDecimal a = new BigDecimal(temp1);
                    BigDecimal b = new BigDecimal(temp2);
                    return AviatorDecimal.valueOf((BigDecimal)a.subtract(b).setScale(3, RoundingMode.HALF_UP));
                }
                return AviatorNil.NIL;
            }

            public String getName() {
                return "-";
            }
        });
    }
}

