/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.formula;

import com.dtstep.lighthouse.common.entity.state.StatState;
import com.dtstep.lighthouse.common.entity.state.StatUnit;
import com.dtstep.lighthouse.common.enums.variable.EmbedVariableEnum;
import com.dtstep.lighthouse.common.exception.TemplateParseException;
import com.dtstep.lighthouse.common.util.JsonUtil;
import com.dtstep.lighthouse.common.util.StringUtil;
import com.dtstep.lighthouse.core.expression.embed.AviatorHandler;
import com.dtstep.lighthouse.core.formula.VariableEvaluate;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FormulaCalculate {
    private static final Logger logger = LoggerFactory.getLogger(FormulaCalculate.class);
    private static final Pattern pattern = Pattern.compile("\\$[a-z_0-9A-Z-: ]+");

    public static long calculate(StatState statState, Map<String, Object> envMap, long batchTime) {
        long res;
        try {
            res = FormulaCalculate.doCalculate(statState, envMap, batchTime);
        }
        catch (Exception ex) {
            logger.error("formula calculate error,state:{}", (Object)JsonUtil.toJSONString((Object)statState), (Object)ex);
            res = 999999999999999997L;
        }
        return res;
    }

    private static Long doCalculate(StatState statState, Map<String, Object> envMap, long batchTime) throws Exception {
        double radix;
        List list = statState.getUnitList();
        int filterStartIndex = StatState.getFilterStartIndex((StatState)statState);
        if (StatState.isCountState((StatState)statState) || StatState.isBitCountState((StatState)statState)) {
            radix = 1.0;
        } else {
            String origin = StatState.getFirstUnit((StatState)statState);
            FormulaCalculate.combineVariableEnvMap(origin, envMap, batchTime);
            String radixStr = String.valueOf(AviatorHandler.execute(origin, envMap));
            if (!StringUtil.isNumber((String)radixStr)) {
                return 999999999999999997L;
            }
            radix = Double.parseDouble(radixStr);
            if (radix > 1.0E14) {
                return 999999999999999997L;
            }
        }
        if (list.size() > filterStartIndex) {
            for (int i = filterStartIndex; i < list.size(); ++i) {
                StatUnit unit = (StatUnit)list.get(i);
                String origin = unit.getOrigin();
                FormulaCalculate.combineVariableEnvMap(origin, envMap, batchTime);
                if (AviatorHandler.check(origin, envMap)) continue;
                return 999999999999999998L;
            }
        }
        if (radix % 1.0 == 0.0) {
            return (long)(radix * 1000.0);
        }
        return BigDecimal.valueOf(radix).multiply(BigDecimal.valueOf(1000L)).longValue();
    }

    public static boolean valid(StatState statState, Map<String, Object> paramMap, long batchTime) throws Exception {
        String origin;
        List list = statState.getUnitList();
        int filterStartIndex = StatState.getFilterStartIndex((StatState)statState);
        HashMap<String, Object> envMap = null;
        if (StatState.isBitCountState((StatState)statState)) {
            envMap = new HashMap<String, Object>(paramMap);
            origin = ((StatUnit)list.get(0)).getOrigin();
            Object obj = AviatorHandler.execute(origin, envMap);
            if (obj == null) {
                return false;
            }
        } else if (!StatState.isCountState((StatState)statState) && !StatState.isBitCountState((StatState)statState)) {
            envMap = new HashMap<String, Object>(paramMap);
            origin = ((StatUnit)list.get(0)).getOrigin();
            FormulaCalculate.combineVariableEnvMap(origin, envMap, batchTime);
            String radixStr = String.valueOf(AviatorHandler.execute(origin, envMap));
            if (!StringUtil.isNumber((String)radixStr)) {
                return false;
            }
            double radix = Double.parseDouble(radixStr);
            if (radix > 1.0E14) {
                return false;
            }
        }
        if (list.size() > filterStartIndex) {
            if (envMap == null) {
                envMap = new HashMap<String, Object>(paramMap);
            }
            for (int i = filterStartIndex; i < list.size(); ++i) {
                StatUnit unit = (StatUnit)list.get(i);
                String origin2 = unit.getOrigin();
                FormulaCalculate.combineVariableEnvMap(origin2, envMap, batchTime);
                if (AviatorHandler.isBoolFormula(origin2, envMap)) continue;
                return false;
            }
        }
        return true;
    }

    public static void combineVariableEnvMap(String formula, Map<String, Object> envMap, long batchTime) throws Exception {
        if (StringUtil.isEmpty((String)formula)) {
            return;
        }
        if (formula.contains("$")) {
            Matcher m = pattern.matcher(formula);
            while (m.find()) {
                String variableName;
                String group = m.group();
                String variable = null;
                if (group.startsWith("$")) {
                    variable = group.substring(1);
                }
                if (StringUtil.isEmpty(variable)) continue;
                int index = variable.indexOf("_");
                String format = "yyyy-MM-dd HH:mm:ss";
                if (index == -1) {
                    variableName = variable;
                } else {
                    variableName = variable.substring(0, index);
                    format = variable.substring(index + 1);
                }
                if (EmbedVariableEnum.isVariableExist((String)variableName)) {
                    Object value = VariableEvaluate.evaluate(variableName, format, batchTime);
                    envMap.put(group, value);
                    continue;
                }
                throw new TemplateParseException("formula parse error,variable[" + m.group() + "] not exist.");
            }
        }
    }

    public static Object parseVariableEntity(String customVariable, Map<String, Object> envMap, long batchTime) throws Exception {
        if (StringUtil.isEmpty((String)customVariable) || MapUtils.isEmpty(envMap)) {
            return null;
        }
        if (envMap.containsKey(customVariable)) {
            return envMap.get(customVariable);
        }
        FormulaCalculate.combineVariableEnvMap(customVariable, envMap, batchTime);
        return AviatorHandler.execute(customVariable, envMap);
    }
}

