/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.formula;

import com.dtstep.lighthouse.common.entity.stat.StatVariableEntity;
import com.dtstep.lighthouse.common.entity.state.StatState;
import com.dtstep.lighthouse.common.entity.state.StatUnit;
import com.dtstep.lighthouse.common.enums.formula.CharTypeEnum;
import com.dtstep.lighthouse.common.enums.function.EmbedFunctionEnum;
import com.dtstep.lighthouse.common.enums.function.FunctionEnum;
import com.dtstep.lighthouse.common.enums.variable.EmbedVariableEnum;
import com.dtstep.lighthouse.common.exception.TemplateParseException;
import com.dtstep.lighthouse.common.modal.Column;
import com.dtstep.lighthouse.common.util.StringUtil;
import com.google.common.collect.Lists;
import java.io.StringReader;
import java.lang.invoke.CallSite;
import java.lang.invoke.StringConcatFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public final class FormulaTranslate {
    private static final Pattern pattern_1 = Pattern.compile("'(.*?)'");
    private static final Pattern pattern_2 = Pattern.compile("\\$[a-z_0-9A-Z]+");
    private static final Pattern pattern_3 = Pattern.compile("[a-z_0-9A-Z]+");

    public static Pair<String, List<StatState>> translate(String stat) throws Exception {
        int n;
        String completeState = stat;
        ArrayList<StatState> stateList = new ArrayList<StatState>();
        StringReader stringReader = new StringReader(stat);
        int index = 0;
        int functionIndex = 0;
        StringBuilder sbr = new StringBuilder();
        CharTypeEnum lastCharType = null;
        while ((n = stringReader.read()) != -1) {
            CharTypeEnum charTypeEnum = CharTypeEnum.getCharTypeEnum((char)((char)n));
            if (charTypeEnum == null) {
                throw new TemplateParseException("formula parse error,unsupported characters exist,char:[" + (char)n + "]");
            }
            if (lastCharType == null) {
                sbr.append((char)n);
                ++index;
                lastCharType = charTypeEnum;
                continue;
            }
            if (FormulaTranslate.isAppend(lastCharType, charTypeEnum)) {
                sbr.append((char)n);
                ++index;
                lastCharType = charTypeEnum;
                continue;
            }
            String temp = sbr.toString();
            if (charTypeEnum == CharTypeEnum.LBRACKET && FunctionEnum.isStatFunction((String)temp)) {
                String functionBody = FormulaTranslate.getFunctionBody(stat.substring(index + 1));
                if (FormulaTranslate.containsStatFunction(functionBody)) {
                    throw new TemplateParseException("formula parse error,nested stat function not support.");
                }
                if (temp.equals(FunctionEnum.AVG.getFunctionName())) {
                    List<StatState> averageStateList = FormulaTranslate.transAverageState(functionBody);
                    for (StatState tempState : averageStateList) {
                        tempState.setFunctionIndex(functionIndex++);
                        stateList.add(tempState);
                    }
                    completeState = stat.replace(String.format("%s(%s)", temp, functionBody), String.format("%s/%s", averageStateList.get(0).getStateBody(), averageStateList.get(1).getStateBody()));
                } else {
                    StatState statState = new StatState();
                    statState.setFunctionIndex(functionIndex++);
                    statState.setStateName(temp);
                    List<StatUnit> unitList = FormulaTranslate.getFunctionUnit(functionBody);
                    statState.setUnitList(unitList);
                    statState.setStateBody(String.format("%s(%s)", temp, functionBody));
                    stateList.add(statState);
                }
                assert (functionBody != null);
                index = index + functionBody.length() + 2;
                stringReader.skip(functionBody.length() + 1);
                continue;
            }
            sbr.setLength(0);
            sbr.append((char)n);
            ++index;
            lastCharType = charTypeEnum;
        }
        return Pair.of((Object)completeState, stateList);
    }

    private static List<StatState> transAverageState(String formula) throws Exception {
        ArrayList<StatState> stateList = new ArrayList<StatState>();
        StatState sumState = new StatState();
        sumState.setStateName("sum");
        List<StatUnit> unitList = FormulaTranslate.getFunctionUnit(formula);
        sumState.setUnitList(unitList);
        sumState.setStateBody(String.format("%s(%s)", "sum", formula));
        StatState.valid((StatState)sumState);
        stateList.add(sumState);
        StatState countState = new StatState();
        countState.setStateName("count");
        if (unitList.size() > 1) {
            countState.setUnitList(unitList.subList(1, unitList.size()));
            List unitOriginList = unitList.subList(1, unitList.size()).stream().map(StatUnit::getOrigin).collect(Collectors.toList());
            String countBody = String.join((CharSequence)",", unitOriginList);
            countState.setStateBody(String.format("%s(%s)", "count", countBody));
        } else {
            countState.setUnitList(new ArrayList());
            countState.setStateBody("count()");
        }
        StatState.valid((StatState)countState);
        stateList.add(countState);
        return stateList;
    }

    public static boolean containsStatFunction(String formula) throws Exception {
        for (FunctionEnum functionEnum : FunctionEnum.values()) {
            Matcher m = Pattern.compile("[^0-9_a-zA-Z]*" + functionEnum.getFunctionName() + "\\(.*\\)").matcher(formula);
            if (!m.matches()) continue;
            return true;
        }
        return false;
    }

    private static List<String> getUnitPart(String functionBody) throws Exception {
        CallSite temp = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002", "\u0001"}, (String)functionBody);
        ArrayList<String> unitList = new ArrayList<String>();
        StringReader stringReader = new StringReader((String)((Object)temp));
        StringBuilder sbr = new StringBuilder();
        int level = 0;
        int n = 0;
        boolean constFlag = false;
        int index = 0;
        while ((n = stringReader.read()) != -1) {
            char c = (char)n;
            CharTypeEnum charTypeEnum = CharTypeEnum.getCharTypeEnum((char)c);
            if (charTypeEnum == null) {
                throw new TemplateParseException("formula parse error,unsupported characters exist,char:[" + (char)n + "]");
            }
            if (charTypeEnum == CharTypeEnum.SINGLE_QUOTATION) {
                if (constFlag) {
                    char nextChar;
                    if (index != ((String)((Object)temp)).length() - 1 && !FormulaTranslate.isAppend(charTypeEnum, Objects.requireNonNull(CharTypeEnum.getCharTypeEnum((char)(nextChar = ((String)((Object)temp)).charAt(index + 1)))))) {
                        constFlag = false;
                    }
                } else {
                    constFlag = true;
                }
                sbr.append(c);
            } else if (constFlag) {
                sbr.append(c);
            } else if (charTypeEnum == CharTypeEnum.COMMA) {
                if (level == 0) {
                    unitList.add(sbr.toString());
                    sbr.setLength(0);
                } else {
                    sbr.append(c);
                }
            } else if (charTypeEnum == CharTypeEnum.LBRACKET) {
                ++level;
                sbr.append(c);
            } else if (charTypeEnum == CharTypeEnum.RBRACKET) {
                --level;
                sbr.append(c);
            } else if (charTypeEnum == CharTypeEnum.END) {
                unitList.add(sbr.toString());
                sbr.setLength(0);
            } else {
                sbr.append(c);
            }
            ++index;
        }
        return unitList;
    }

    private static List<StatUnit> getFunctionUnit(String functionBody) throws Exception {
        ArrayList unitList = Lists.newArrayListWithExpectedSize((int)2);
        if (StringUtil.isEmpty((String)functionBody)) {
            return unitList;
        }
        List<String> partList = FormulaTranslate.getUnitPart(functionBody);
        for (String temp : partList) {
            StatUnit statUnit = new StatUnit();
            statUnit.setOrigin(temp);
            unitList.add(statUnit);
        }
        return unitList;
    }

    private static boolean isAppend(CharTypeEnum charTypeEnum1, CharTypeEnum charTypeEnum2) {
        return charTypeEnum1.getLevel() == charTypeEnum2.getLevel();
    }

    private static String getFunctionBody(String rest) {
        StringBuilder sbr = new StringBuilder();
        int level = 0;
        for (int i = 0; i < rest.length(); ++i) {
            char c = rest.charAt(i);
            if (c == '(') {
                ++level;
                sbr.append(c);
                continue;
            }
            if (c == ')') {
                if (--level == -1) {
                    return sbr.toString();
                }
                sbr.append(c);
                continue;
            }
            sbr.append(c);
        }
        return null;
    }

    public static List<Column> queryRelatedColumns(List<Column> columnList, String formula) throws Exception {
        ArrayList<Column> resultColumnList = new ArrayList<Column>();
        if (CollectionUtils.isNotEmpty(columnList)) {
            for (Column metaColumn : columnList) {
                String columnName = metaColumn.getName();
                if (columnName.equals(formula)) {
                    resultColumnList.add(metaColumn);
                    continue;
                }
                Matcher m = Pattern.compile("(.*[^0-9_a-zA-Z]+|^)" + columnName + "([^0-9_a-zA-Z]+.*|$)").matcher(formula);
                if (!m.matches()) continue;
                resultColumnList.add(metaColumn);
            }
        }
        return resultColumnList;
    }

    public static void checkVariableExist(String strInfo, List<Column> columnList, List<StatVariableEntity> variableEntityList) throws Exception {
        StringBuffer sbr1 = new StringBuffer();
        Matcher m1 = pattern_1.matcher(strInfo);
        while (m1.find()) {
            m1.appendReplacement(sbr1, "_CONST_");
        }
        m1.appendTail(sbr1);
        String removeConst = sbr1.toString();
        StringBuffer sbr2 = new StringBuffer();
        Matcher m2 = pattern_2.matcher(removeConst);
        while (m2.find()) {
            if (EmbedVariableEnum.isVariableExist((String)m2.group())) {
                m2.appendReplacement(sbr2, "_EMBED_");
                continue;
            }
            throw new TemplateParseException(String.format("i18n(ldp_i18n_template_parse_1016,%s)", m2.group()));
        }
        m2.appendTail(sbr2);
        String removeEmbed = sbr2.toString();
        Matcher m3 = pattern_3.matcher(removeEmbed);
        List columnNameList = columnList.stream().map(Column::getName).collect(Collectors.toList());
        List variableNameList = variableEntityList.stream().map(StatVariableEntity::getVariableName).collect(Collectors.toList());
        while (m3.find()) {
            String group = m3.group();
            if (StringUtil.isNumber((String)group) || FunctionEnum.isStatFunction((String)group) || EmbedFunctionEnum.isEmbedFunction((String)group) || columnNameList.contains(group) || variableNameList.contains(group) || group.startsWith("_CONST_") || group.startsWith("_EMBED_")) continue;
            throw new TemplateParseException(String.format("i18n(ldp_i18n_template_parse_1016,%s)", group));
        }
    }
}

