/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.formula;

import com.dtstep.lighthouse.common.enums.variable.EmbedVariableEnum;
import com.dtstep.lighthouse.common.util.DateUtil;
import com.dtstep.lighthouse.common.util.StringUtil;
import java.util.Date;

public final class VariableEvaluate {
    public static Object evaluate(String variableName, String format, long batchTime) {
        if (StringUtil.isEmpty((String)variableName)) {
            return null;
        }
        long time = 0L;
        if (variableName.equals(EmbedVariableEnum.batchDate.getVariableName())) {
            time = batchTime;
        } else if (variableName.equals(EmbedVariableEnum.hour.getVariableName())) {
            time = DateUtil.getHourStartTime((long)batchTime);
        } else if (variableName.equals(EmbedVariableEnum.lastHour.getVariableName())) {
            time = DateUtil.getHourBefore((long)batchTime, (int)1);
        } else if (variableName.equals(EmbedVariableEnum.twoHoursBefore.getVariableName())) {
            time = DateUtil.getHourBefore((long)batchTime, (int)2);
        } else if (variableName.equals(EmbedVariableEnum.threeHoursBefore.getVariableName())) {
            time = DateUtil.getHourBefore((long)batchTime, (int)3);
        } else if (variableName.equals(EmbedVariableEnum.sixHoursBefore.getVariableName())) {
            time = DateUtil.getHourBefore((long)batchTime, (int)6);
        } else if (variableName.equals(EmbedVariableEnum.twelveHoursBefore.getVariableName())) {
            time = DateUtil.getHourBefore((long)batchTime, (int)12);
        } else if (variableName.equals(EmbedVariableEnum.today.getVariableName())) {
            time = DateUtil.getDayStartTime((long)batchTime);
        } else if (variableName.equals(EmbedVariableEnum.yesterday.getVariableName())) {
            time = DateUtil.getDayBefore((long)batchTime, (int)1);
        } else if (variableName.equals(EmbedVariableEnum.twoDaysBefore.getVariableName())) {
            time = DateUtil.getDayBefore((long)batchTime, (int)2);
        } else if (variableName.equals(EmbedVariableEnum.threeDaysBefore.getVariableName())) {
            time = DateUtil.getDayBefore((long)batchTime, (int)3);
        } else if (variableName.equals(EmbedVariableEnum.sevenDaysBefore.getVariableName())) {
            time = DateUtil.getDayBefore((long)batchTime, (int)7);
        } else if (variableName.equals(EmbedVariableEnum.fourteenDaysBefore.getVariableName())) {
            time = DateUtil.getDayBefore((long)batchTime, (int)14);
        } else if (variableName.equals(EmbedVariableEnum.thirtyDaysBefore.getVariableName())) {
            time = DateUtil.getDayBefore((long)batchTime, (int)30);
        } else if (variableName.equals(EmbedVariableEnum.weekBegin.getVariableName())) {
            time = DateUtil.getWeekStartTime((long)batchTime);
        } else if (variableName.equals(EmbedVariableEnum.weekEnd.getVariableName())) {
            time = DateUtil.getWeekEndTime((long)batchTime);
        } else if (variableName.equals(EmbedVariableEnum.lastWeekBegin.getVariableName())) {
            Date tempDate = new Date(DateUtil.getDayBefore((long)batchTime, (int)7));
            time = DateUtil.getWeekStartTime((long)tempDate.getTime());
        } else if (variableName.equals(EmbedVariableEnum.lastWeekEnd.getVariableName())) {
            Date tempDate = new Date(DateUtil.getDayBefore((long)batchTime, (int)7));
            time = DateUtil.getWeekEndTime((long)tempDate.getTime());
        } else if (variableName.equals(EmbedVariableEnum.monthBegin.getVariableName())) {
            time = DateUtil.getMonthStartTime((long)batchTime);
        } else if (variableName.equals(EmbedVariableEnum.monthEnd.getVariableName())) {
            time = DateUtil.getMonthEndTime((long)batchTime);
        } else if (variableName.equals(EmbedVariableEnum.lastMonthBegin.getVariableName())) {
            int year = DateUtil.getYear((long)batchTime);
            int month = DateUtil.getMonthIndexOfYear((long)batchTime);
            if (month == 1) {
                --year;
                month = 12;
            } else {
                --month;
            }
            time = DateUtil.getMonthStartTime((int)year, (int)month);
        } else if (variableName.equals(EmbedVariableEnum.lastMonthEnd.getVariableName())) {
            int year = DateUtil.getYear((long)batchTime);
            int month = DateUtil.getMonthIndexOfYear((long)batchTime);
            if (month == 1) {
                --year;
                month = 12;
            } else {
                --month;
            }
            time = DateUtil.getMonthEndTime((int)year, (int)month);
        }
        Object value = "timestamp".equals(format) ? Long.valueOf(time) : DateUtil.formatTimeStamp((long)time, (String)format);
        if (value.getClass() == String.class) {
            value = "'" + value.toString() + "'";
        }
        return value;
    }
}

