/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.http;

import com.dtstep.lighthouse.core.http.HttpServiceHandler;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightHouseHttpService {
    private static final Logger logger = LoggerFactory.getLogger(LightHouseHttpService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start() {
        EpollEventLoopGroup workerGroup;
        EpollEventLoopGroup bossGroup;
        if (Epoll.isAvailable()) {
            bossGroup = new EpollEventLoopGroup(Runtime.getRuntime().availableProcessors() * 2);
            workerGroup = new EpollEventLoopGroup(Runtime.getRuntime().availableProcessors() * 2);
        } else if (KQueue.isAvailable()) {
            bossGroup = new KQueueEventLoopGroup(Runtime.getRuntime().availableProcessors() * 2);
            workerGroup = new KQueueEventLoopGroup(Runtime.getRuntime().availableProcessors() * 2);
        } else {
            bossGroup = new NioEventLoopGroup(Runtime.getRuntime().availableProcessors() * 2);
            workerGroup = new NioEventLoopGroup(Runtime.getRuntime().availableProcessors() * 2);
        }
        try {
            ServerBootstrap bootstrap = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)bootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(Epoll.isAvailable() ? EpollServerSocketChannel.class : (KQueue.isAvailable() ? KQueueServerSocketChannel.class : NioServerSocketChannel.class))).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).option(EpollChannelOption.SO_REUSEPORT, (Object)true)).option(ChannelOption.SO_BACKLOG, (Object)1024)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new HttpServerCodec()}).addLast(new ChannelHandler[]{new HttpObjectAggregator(0x3200000)}).addLast(new ChannelHandler[]{new HttpServiceHandler()});
                }
            }).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childOption(ChannelOption.SO_SNDBUF, (Object)0x6400000).childOption(ChannelOption.SO_RCVBUF, (Object)0x6400000);
            ChannelFuture future = bootstrap.bind(18101).sync();
            logger.info("ldp http service start,listen:{}", (Object)18101);
            future.channel().closeFuture().sync();
        }
        catch (Exception ex) {
            logger.error("ldp http service startup exception!", (Throwable)ex);
        }
        finally {
            bossGroup.shutdownGracefully();
            workerGroup.shutdownGracefully();
        }
    }
}

