/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.ipc;

import com.dtstep.lighthouse.common.entity.event.IceEvent;
import com.dtstep.lighthouse.common.sbr.StringBuilderHolder;
import com.dtstep.lighthouse.common.schedule.ScheduledThreadPoolBuilder;
import com.dtstep.lighthouse.core.tasks.EventSenderFactory;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.WorkHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DisruptorEventHandler
implements EventHandler<IceEvent>,
WorkHandler<IceEvent> {
    private static final Logger logger = LoggerFactory.getLogger(DisruptorEventHandler.class);
    private static final int CONSUMER_THRESHOLD = 20000;
    private final Multiset<String> multiset = HashMultiset.create((int)20000);
    private volatile long lastBatchTime;
    private static final int SENDER_SIZE = 60;
    private final ReentrantLock lock = new ReentrantLock(false);

    public void onEvent(IceEvent event, long sequence, boolean endOfBatch) {
    }

    public DisruptorEventHandler() {
        ScheduledThreadPoolExecutor service = ScheduledThreadPoolBuilder.newScheduledThreadPoolExecutor((int)1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("ice-clear-schedule-pool-%d").daemon(true).build());
        service.scheduleWithFixedDelay(new ClearThread(), 5L, 5L, TimeUnit.SECONDS);
    }

    public void onEvent(IceEvent event) {
        this.lock.lock();
        try {
            this.multiset.add((Object)event.getMessage(), event.getRepeat());
            if (this.multiset.entrySet().size() >= 20000) {
                this.consumer();
            }
        }
        catch (Exception ex) {
            logger.error("ice consumer error!", (Throwable)ex);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void consumer() throws Exception {
        int sendSize = this.multiset.entrySet().size();
        if (sendSize == 0) {
            return;
        }
        StringBuilder sbr = StringBuilderHolder.Bigger.getStringBuilder();
        int i = 0;
        for (Multiset.Entry entry : this.multiset.entrySet()) {
            if (i != 0) {
                sbr.append("\u0003");
            }
            sbr.append((String)entry.getElement()).append("\u0004").append(entry.getCount());
            if (++i < 60) continue;
            this.send(sbr.toString());
            sbr.setLength(0);
            i = 0;
        }
        if (sbr.length() > 0) {
            this.send(sbr.toString());
            sbr.setLength(0);
        }
        this.multiset.clear();
        this.lastBatchTime = System.currentTimeMillis();
        logger.info("lighthouse rpc service batch processed {} messages!", (Object)sendSize);
    }

    private void send(String text) throws Exception {
        EventSenderFactory.getEventSender().send(text);
    }

    private final class ClearThread
    implements Runnable {
        private ClearThread() {
        }

        @Override
        public void run() {
            if (System.currentTimeMillis() - DisruptorEventHandler.this.lastBatchTime < TimeUnit.SECONDS.toMillis(10L)) {
                return;
            }
            boolean is = DisruptorEventHandler.this.lock.tryLock();
            if (is) {
                try {
                    DisruptorEventHandler.this.consumer();
                }
                catch (Exception ex) {
                    logger.error("ice consumer error.", (Throwable)ex);
                }
                finally {
                    DisruptorEventHandler.this.lock.unlock();
                }
            }
        }
    }
}

