/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.ipc;

import com.dtstep.lighthouse.common.entity.event.IceEvent;
import com.dtstep.lighthouse.core.ipc.DisruptorEventHandler;
import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.WorkHandler;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DisruptorEventProducer {
    private static final RingBuffer<IceEvent> ringBuffer;
    private static final Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onData(String message, int repeat) {
        long sequence = ringBuffer.next();
        try {
            IceEvent iceEvent = (IceEvent)ringBuffer.get(sequence);
            iceEvent.setMessage(message);
            iceEvent.setRepeat(repeat);
        }
        finally {
            ringBuffer.publish(sequence);
        }
    }

    static {
        logger = LoggerFactory.getLogger(DisruptorEventProducer.class);
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        long maxMemoryInMB = maxMemory / 0x100000L;
        int threadSize = Math.min((int)(maxMemoryInMB / 300L), 10);
        int ringBufferSize = maxMemoryInMB <= 1024L ? 65536 : (maxMemoryInMB <= 2048L ? 131072 : (maxMemoryInMB <= 3072L ? 262144 : 524288));
        logger.info("RingBuffer init,maxMemoryInMB:{},thread size:{},ringBufferSize:{}", new Object[]{maxMemoryInMB, threadSize, ringBufferSize});
        Validate.isTrue((threadSize > 0 ? 1 : 0) != 0);
        Disruptor disruptor = new Disruptor(IceEvent::new, ringBufferSize, Executors.defaultThreadFactory(), ProducerType.MULTI, (WaitStrategy)new BlockingWaitStrategy());
        WorkHandler[] handlers = new DisruptorEventHandler[threadSize];
        for (int i = 0; i < handlers.length; ++i) {
            handlers[i] = new DisruptorEventHandler();
        }
        disruptor.handleEventsWithWorkerPool(handlers);
        disruptor.start();
        ringBuffer = disruptor.getRingBuffer();
    }
}

