/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.kafka;

import com.dtstep.lighthouse.core.config.LDPConfig;
import com.dtstep.lighthouse.core.kafka.KafkaProducerFactory;
import java.util.Properties;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KafkaProducerPool {
    private static final Logger logger = LoggerFactory.getLogger(KafkaProducerPool.class);
    private final GenericObjectPool<KafkaProducer<byte[], byte[]>> connectionPool;

    public KafkaProducerPool() {
        Properties properties = KafkaProducerPool.getConfig();
        KafkaProducerFactory producerFactory = new KafkaProducerFactory(properties);
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(5);
        config.setMaxIdle(3);
        config.setMinIdle(1);
        config.setMaxWaitMillis(5000L);
        config.setBlockWhenExhausted(true);
        config.setTestOnReturn(false);
        config.setMinEvictableIdleTimeMillis(60000L);
        config.setTestWhileIdle(true);
        config.setTimeBetweenEvictionRunsMillis(3000L);
        config.setNumTestsPerEvictionRun(10);
        this.connectionPool = new GenericObjectPool((PooledObjectFactory)producerFactory, config);
    }

    public static Properties getConfig() {
        String bootstrapServers = null;
        try {
            bootstrapServers = LDPConfig.getVal("kafka.bootstrap.servers");
        }
        catch (Exception ex) {
            logger.error("ice process exit,get param [{}] fail.", (Object)"kafka.bootstrap.servers", (Object)ex);
        }
        assert (bootstrapServers != null);
        Properties props = new Properties();
        props.put("bootstrap.servers", bootstrapServers);
        props.put("batch.size", (Object)131072);
        props.put("linger.ms", (Object)100);
        props.put("acks", "all");
        props.put("retries", (Object)5);
        props.put("buffer.memory", (Object)0x2000000);
        props.put("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        props.put("compression.type", "gzip");
        return props;
    }

    public KafkaProducer<byte[], byte[]> getInstance() {
        try {
            return (KafkaProducer)this.connectionPool.borrowObject();
        }
        catch (Exception e) {
            throw new RuntimeException("lighthouse ice get kafka connection exception!", e);
        }
    }

    public void release(KafkaProducer<byte[], byte[]> producer) {
        try {
            this.connectionPool.returnObject(producer);
        }
        catch (Exception e) {
            throw new RuntimeException("release Kafka connection exception", e);
        }
    }
}

