/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.limiting;

import com.dtstep.lighthouse.common.util.Md5Util;
import com.dtstep.lighthouse.common.util.StringUtil;
import com.dtstep.lighthouse.core.redis.RedisClient;
import com.dtstep.lighthouse.core.redis.RedisOperator;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.util.concurrent.Striped;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.exceptions.JedisNoScriptException;

public final class RedisLimitingAspect {
    private static final Logger logger = LoggerFactory.getLogger(RedisLimitingAspect.class);
    private static final Cache<String, Optional<Boolean>> limitedCache = Caffeine.newBuilder().expireAfterWrite(20L, TimeUnit.SECONDS).maximumSize(1000000L).softValues().build();
    private static final Cache<String, Optional<Integer>> remainCache = Caffeine.newBuilder().expireAfterWrite(20L, TimeUnit.SECONDS).maximumSize(1000000L).softValues().build();
    private static final RedisLimitingAspect instance = new RedisLimitingAspect();
    private String sha;
    private static final String LUA_LIMIT_SCRIPT = " local key = KEYS[1]\n local expireTime = tonumber(ARGV[1]) \n local step = tonumber(ARGV[2]) \n local limitValue = tonumber(ARGV[3]) \n local num = redis.call('INCRBY',key,step) \n redis.call('expire',key,expireTime) \n local result = 0\n if tonumber(num) > limitValue + step then result = 0 elseif tonumber(num) < limitValue then result = step else  result = step - (num - limitValue) \n end\n return result";
    private static final Striped<Lock> stripedLock = Striped.lazyWeakLock((int)80);

    private RedisLimitingAspect() {
        try {
            this.sha = RedisClient.scriptLoad(LUA_LIMIT_SCRIPT);
        }
        catch (Exception ex) {
            logger.error("script load error", (Throwable)ex);
        }
    }

    public static RedisLimitingAspect getInstance() {
        return instance;
    }

    private int getRemainSize(String limitKey, int step, long limitValue, long expireSeconds) {
        RedisOperator redisOperator = RedisClient.getInstance().getRedisOperator();
        try {
            if (StringUtil.isEmpty((String)this.sha) || !redisOperator.scriptExists(this.sha, limitKey).booleanValue()) {
                this.sha = redisOperator.scriptLoad(LUA_LIMIT_SCRIPT, limitKey);
            }
            Object result = redisOperator.evalsha(this.sha, 1, Md5Util.get16MD5((String)limitKey), String.valueOf(expireSeconds), String.valueOf(step), String.valueOf(limitValue));
            return Integer.parseInt(String.valueOf(result));
        }
        catch (JedisNoScriptException ex) {
            logger.info("put limiting lua-script to remote server again,key:{}", (Object)limitKey);
            this.sha = redisOperator.scriptLoad(LUA_LIMIT_SCRIPT, limitKey);
            return this.getRemainSize(limitKey, step, limitValue, expireSeconds);
        }
        catch (Exception ex) {
            logger.error("redis try acquire error", (Throwable)ex);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryAcquire(String limitKey, int step, long limitValue, long expireSeconds, int acquireSize) {
        Optional optional = (Optional)limitedCache.getIfPresent((Object)limitKey);
        if (optional != null && optional.isPresent() && !((Boolean)optional.get()).booleanValue()) {
            return false;
        }
        Lock lock = (Lock)stripedLock.get((Object)limitKey);
        lock.lock();
        try {
            int remainSize;
            Optional cacheOptional = (Optional)remainCache.getIfPresent((Object)limitKey);
            int cacheValue = 0;
            if (cacheOptional != null && cacheOptional.isPresent()) {
                cacheValue = (Integer)cacheOptional.get();
            }
            if (cacheValue > acquireSize) {
                remainCache.put((Object)limitKey, Optional.of(cacheValue - acquireSize));
                boolean bl = true;
                return bl;
            }
            int curAcquireSize = acquireSize - cacheValue;
            if (step < curAcquireSize) {
                step = curAcquireSize;
            }
            if ((remainSize = this.getRemainSize(limitKey, step, limitValue, expireSeconds)) < curAcquireSize) {
                limitedCache.put((Object)limitKey, Optional.of(false));
                boolean bl = false;
                return bl;
            }
            remainCache.put((Object)limitKey, Optional.of(remainSize - curAcquireSize));
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            logger.error("redis limited error!", (Throwable)ex);
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }
}

