/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.limiting.device.impl;

import com.dtstep.lighthouse.common.entity.stat.StatExtEntity;
import com.dtstep.lighthouse.common.entity.view.StatValue;
import com.dtstep.lighthouse.common.schedule.ScheduledThreadPoolBuilder;
import com.dtstep.lighthouse.common.util.DateUtil;
import com.dtstep.lighthouse.core.callback.CaffeineExpiry;
import com.dtstep.lighthouse.core.limiting.device.CountingDevice;
import com.dtstep.lighthouse.core.storage.result.ResultStorageSelector;
import com.dtstep.lighthouse.core.wrapper.StatDBWrapper;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Scheduler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLimitingCountingDevice
implements CountingDevice {
    private static final Logger logger = LoggerFactory.getLogger(DefaultLimitingCountingDevice.class);
    private static final Cache<Pair<Integer, Integer>, CountingDevice.Value> valueCache = Caffeine.newBuilder().expireAfter(new CaffeineExpiry.ExpiryAfterLastAccess(TimeUnit.MINUTES.toMillis(2L))).scheduler(Scheduler.systemScheduler()).maximumSize(300000L).softValues().build();

    @Override
    public boolean tryRequire(CountingDevice.Params params) throws Exception {
        int threshold = params.getPermitsPerSecond();
        CountingDevice.Value value = (CountingDevice.Value)valueCache.get((Object)Pair.of((Object)params.getBuiltinStat().getId(), (Object)params.getRelationId()), k -> CountingDevice.Value.newVar());
        assert (value != null);
        value.setAccessTime(System.currentTimeMillis());
        if (logger.isTraceEnabled()) {
            logger.trace("default limiting counting device check,builtInStatId:{},relationId:{},value:{},threshold:{}", new Object[]{params.getBuiltinStat().getId(), params.getRelationId(), value.getV(), threshold * 60});
        }
        return (long)threshold * 60L > value.getV();
    }

    static {
        ScheduledThreadPoolExecutor service = ScheduledThreadPoolBuilder.newScheduledThreadPoolExecutor((int)1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("limiting-counting-schedule-pool-%d").daemon(true).build());
        service.scheduleWithFixedDelay(new RefreshThread(valueCache), 0L, 1L, TimeUnit.MINUTES);
    }

    static class RefreshThread
    implements Runnable {
        private final Cache<Pair<Integer, Integer>, CountingDevice.Value> valueCache;

        public RefreshThread(Cache<Pair<Integer, Integer>, CountingDevice.Value> valueCache) {
            this.valueCache = valueCache;
        }

        @Override
        public void run() {
            ConcurrentMap dataMap = this.valueCache.asMap();
            Set sets = dataMap.keySet();
            HashMap<Integer, List> paramMap = new HashMap<Integer, List>();
            for (Pair pair : sets) {
                List list = paramMap.computeIfAbsent((Integer)pair.getLeft(), k -> new ArrayList());
                list.add((Integer)pair.getRight());
            }
            try {
                long batchTime = DateUtil.previousBatchTime((int)1, (TimeUnit)TimeUnit.MINUTES, (long)System.currentTimeMillis());
                for (Integer builtStatId : paramMap.keySet()) {
                    List<String> dimensList;
                    LinkedHashMap<String, StatValue> data;
                    List list = (List)paramMap.get(builtStatId);
                    StatExtEntity statExtEntity = StatDBWrapper.queryById(builtStatId);
                    if (statExtEntity == null || !MapUtils.isNotEmpty(data = ResultStorageSelector.queryWithDimensList(statExtEntity, dimensList = list.stream().map(Object::toString).collect(Collectors.toList()), batchTime))) continue;
                    data.forEach((k, v) -> {
                        CountingDevice.Value value = (CountingDevice.Value)this.valueCache.getIfPresent((Object)Pair.of((Object)builtStatId, (Object)Integer.parseInt(k)));
                        assert (value != null);
                        value.setV(Long.parseLong(v.getValue().toString()));
                        value.setUpdateTime(System.currentTimeMillis());
                        if (logger.isTraceEnabled()) {
                            logger.trace("default limiting counting device refresh,builtInStatId:{},relationId:{},value:{}", new Object[]{builtStatId, k, value.getV()});
                        }
                    });
                }
            }
            catch (Exception ex) {
                logger.error("refresh limiting counting data error!", (Throwable)ex);
            }
        }
    }
}

