/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.lock;

import com.dtstep.lighthouse.core.config.LDPConfig;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.redisson.Redisson;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RedissonLock {
    private static final Logger logger = LoggerFactory.getLogger(RedissonLock.class);
    private static RedissonClient redissonClient;

    private static synchronized void init() {
        Config config = new Config();
        try {
            String redisCluster = LDPConfig.getVal("redis.cluster");
            String password = LDPConfig.getVal("redis.cluster.password");
            assert (redisCluster != null);
            String[] servers = redisCluster.split(",");
            ArrayList<CallSite> nodeAddress = new ArrayList<CallSite>();
            for (String server : servers) {
                nodeAddress.add((CallSite)((Object)("redis://" + server)));
            }
            ((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)config.useClusterServers().setPassword(password)).setScanInterval(5000).setIdleConnectionTimeout(480000)).setConnectTimeout(480000)).setRetryAttempts(6)).setRetryInterval(6000)).setKeepAlive(false)).setMasterConnectionPoolSize(64)).setCheckSlotsCoverage(false).setTimeout(480000)).setNodeAddresses(nodeAddress);
            redissonClient = Redisson.create((Config)config);
        }
        catch (Exception ex) {
            logger.error("init redisson lock error,process exit!", (Throwable)ex);
            System.exit(-1);
        }
    }

    public static boolean tryLock(String key, long waitTime, long leastTime, TimeUnit timeUnit) {
        try {
            RLock rLock = redissonClient.getLock(key);
            if (Objects.isNull(rLock)) {
                logger.error("No redisson lock operation instance was obtained,rLock:{},key:{}", (Object)rLock, (Object)key);
                return false;
            }
            return rLock.tryLock(waitTime, leastTime, timeUnit);
        }
        catch (Exception ex) {
            logger.error("redisson try lock failed,key:{}!", (Object)key, (Object)ex);
            return false;
        }
    }

    public static void unLock(String key) throws Exception {
        RLock rLock = redissonClient.getLock(key);
        if (rLock.isLocked() && rLock.isHeldByCurrentThread()) {
            rLock.unlock();
        }
    }

    static {
        RedissonLock.init();
    }
}

