/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.preparing.handler.valid;

import com.dtstep.lighthouse.common.entity.group.GroupExtEntity;
import com.dtstep.lighthouse.common.entity.message.LightMessage;
import com.dtstep.lighthouse.common.enums.GroupStateEnum;
import com.dtstep.lighthouse.common.enums.LimitingStrategyEnum;
import com.dtstep.lighthouse.common.enums.SwitchStateEnum;
import com.dtstep.lighthouse.common.enums.result.MessageCaptchaEnum;
import com.dtstep.lighthouse.common.util.DateUtil;
import com.dtstep.lighthouse.common.util.JsonUtil;
import com.dtstep.lighthouse.core.limiting.LimitingContext;
import com.dtstep.lighthouse.core.limiting.RedisLimitingAspect;
import com.dtstep.lighthouse.core.preparing.handler.valid.MessageValid;
import com.dtstep.lighthouse.core.preparing.handler.valid.ValidHandler;
import com.dtstep.lighthouse.core.redis.RedisClient;
import com.dtstep.lighthouse.core.wrapper.GroupDBWrapper;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultValidHandler
implements ValidHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultValidHandler.class);

    @Override
    public Pair<MessageCaptchaEnum, LightMessage> valid(LightMessage message) throws Exception {
        GroupExtEntity groupEntity = GroupDBWrapper.queryById(message.getGroupId());
        if (groupEntity == null || groupEntity.getState() != GroupStateEnum.RUNNING) {
            return null;
        }
        int threshold = groupEntity.getExtendConfig().getLimitingConfig().getOrDefault(LimitingStrategyEnum.GROUP_MESSAGE_SIZE_LIMITING, -1);
        if (!LimitingContext.getInstance().tryAcquire(groupEntity, threshold, message.getRepeat())) {
            logger.error("limited trigger strategy:GROUP_MESSAGE_SIZE_LIMIT,group id:{},threshold:{}", (Object)groupEntity.getId(), (Object)((long)threshold * 60L));
        }
        if (groupEntity.getDebugMode() == SwitchStateEnum.OPEN) {
            this.capture(groupEntity.getId(), message);
        }
        MessageCaptchaEnum resultCodeEnum = this.validMessage(message, groupEntity);
        if (logger.isTraceEnabled()) {
            logger.trace("The group of message matching is:{},valid result:{}", (Object)groupEntity.getId(), (Object)resultCodeEnum);
        }
        return Pair.of((Object)resultCodeEnum, (Object)message);
    }

    private MessageCaptchaEnum validMessage(LightMessage message, GroupExtEntity groupExtEntity) throws Exception {
        List columnList = groupExtEntity.getColumns();
        if (!MessageValid.valid((int)groupExtEntity.getId(), message, columnList)) {
            return MessageCaptchaEnum.PARAM_CHECK_FAILED;
        }
        return MessageCaptchaEnum.SUCCESS;
    }

    private void capture(int groupId, LightMessage message) {
        long batchTime = DateUtil.batchTime((int)1, (TimeUnit)TimeUnit.MINUTES, (long)System.currentTimeMillis());
        String lockTrackKey = "lock_group_track_" + groupId + "_" + batchTime;
        if (RedisLimitingAspect.getInstance().tryAcquire(lockTrackKey, 5, 50L, TimeUnit.MINUTES.toSeconds(5L), 1)) {
            String trackKey = "group_track_" + groupId;
            message.setSystemTime(System.currentTimeMillis());
            if (logger.isTraceEnabled()) {
                logger.trace("group[{}] enable debug mode,capture message:{}", (Object)groupId, (Object)JsonUtil.toJSONString((Object)message));
            }
            RedisClient.getInstance().limitSet(trackKey, JsonUtil.toJSONString((Object)message), 500, 7200);
        }
    }
}

