/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.preparing.pipe;

import com.dtstep.lighthouse.core.preparing.pipe.PreparingCollector;
import com.dtstep.lighthouse.core.preparing.pipe.PreparingInput;
import com.dtstep.lighthouse.core.preparing.pipe.stage.PreparingStage;
import java.util.List;

public class Pipeline<IN, OUT> {
    private final List<PreparingStage<?, ?>> stages;

    Pipeline(List<PreparingStage<?, ?>> stages) {
        this.stages = stages;
    }

    public List<OUT> process(IN inputData) throws Exception {
        List<?> result = null;
        for (int i = 0; i < this.stages.size(); ++i) {
            PreparingCollector<?> collector;
            PreparingStage<?, ?> stage = this.stages.get(i);
            if (i == 0) {
                collector = stage.generateCollector();
                this.apply(stage, new PreparingInput<IN>(inputData), collector);
                result = collector.getData();
                continue;
            }
            collector = stage.generateCollector();
            for (Object object : result) {
                this.apply(stage, new PreparingInput(object), collector);
            }
            result = collector.getData();
        }
        return result;
    }

    private <I, O> void apply(PreparingStage<I, O> stage, PreparingInput<?> dataItem, PreparingCollector<O> outItem) throws Exception {
        PreparingInput<?> typedDataItem = dataItem;
        stage.process(typedDataItem, outItem);
    }
}

