/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.redis;

import com.dtstep.lighthouse.common.util.StringUtil;
import com.dtstep.lighthouse.core.config.LDPConfig;
import com.dtstep.lighthouse.core.redis.RedisOperator;
import com.dtstep.lighthouse.core.redis.cluster.RedisClusterOperator;
import com.google.common.base.Joiner;
import java.util.LinkedHashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.exceptions.JedisNoScriptException;
import redis.clients.jedis.resps.Tuple;

public final class RedisClient {
    private static final Logger logger = LoggerFactory.getLogger(RedisClient.class);
    private static final RedisClient client = new RedisClient();
    private static RedisOperator redisOperator = null;
    private static final String LIMIT_SET_LUA = "redis.call('lpush',KEYS[1],ARGV[1])\t\nredis.call('ltrim',KEYS[1],0,tonumber(ARGV[2]))\t\nredis.call('expire',KEYS[1],tonumber(ARGV[3]))\t\nreturn 1";
    private static String sha_limit_set = null;
    private static final String LUA_PUT_TOP_N = "local function Split(fullStr, separator)\nlocal startIndex = 1\nlocal splitIndex = 1\nlocal splitArray = {}\nwhile true do\n   local lastIndex = string.find(fullStr, separator, startIndex)\n   if not lastIndex then\n    splitArray[splitIndex] = string.sub(fullStr, startIndex, string.len(fullStr))\n    break\n   end\n   splitArray[splitIndex] = string.sub(fullStr, startIndex, lastIndex - 1)\n   startIndex = lastIndex + string.len(separator)\n   splitIndex = splitIndex + 1\nend\nreturn splitArray\nend\nlocal scores = Split(ARGV[1], ',')\nlocal members = Split(ARGV[2], ',')\nlocal tableArray = {}\nfor i = 1, #members do\nredis.call('zadd',KEYS[1],scores[i],members[i])\nend\nredis.call('zremrangeByRank',KEYS[1],0,-(tonumber(ARGV[3]) + 1))\t\nredis.call('expire',KEYS[1],tonumber(ARGV[4]))\t\nreturn 1\n";
    private static String sha_topN;
    private static final String LUA_PUT_LAST_N = "local function Split(fullStr, separator)\nlocal startIndex = 1\nlocal splitIndex = 1\nlocal splitArray = {}\nwhile true do\n   local lastIndex = string.find(fullStr, separator, startIndex)\n   if not lastIndex then\n    splitArray[splitIndex] = string.sub(fullStr, startIndex, string.len(fullStr))\n    break\n   end\n   splitArray[splitIndex] = string.sub(fullStr, startIndex, lastIndex - 1)\n   startIndex = lastIndex + string.len(separator)\n   splitIndex = splitIndex + 1\nend\nreturn splitArray\nend\nlocal scores = Split(ARGV[1], ',')\nlocal members = Split(ARGV[2], ',')\nlocal tableArray = {}\nfor i = 1, #members do\nredis.call('zadd',KEYS[1],scores[i],members[i])\nend\nredis.call('zremrangeByRank',KEYS[1],tonumber(ARGV[3]),-1)\t\nredis.call('expire',KEYS[1],tonumber(ARGV[4]))\t\nreturn 1\n";
    private static String sha_lastN;

    public static RedisClient getInstance() {
        return client;
    }

    public static String scriptLoad(String script) {
        return redisOperator.scriptLoad(script);
    }

    public static String scriptLoad(String script, String key) {
        return redisOperator.scriptLoad(script, key);
    }

    public RedisOperator getRedisOperator() {
        return redisOperator;
    }

    public void limitSet(String key, String value, int limit, int expireSeconds) {
        try {
            if (StringUtil.isEmpty((String)sha_limit_set) || !redisOperator.scriptExists(sha_limit_set, key).booleanValue()) {
                sha_limit_set = redisOperator.scriptLoad(LIMIT_SET_LUA, key);
            }
            redisOperator.evalsha(sha_limit_set, 1, key, value, String.valueOf(limit), String.valueOf(expireSeconds));
        }
        catch (JedisNoScriptException ex) {
            logger.info("put limit-set lua-script to remote server again,key:{}", (Object)key);
            sha_limit_set = redisOperator.scriptLoad(LIMIT_SET_LUA, key);
            this.limitSet(key, value, limit, expireSeconds);
        }
        catch (Exception ex) {
            logger.error("redis limit set error!", (Throwable)ex);
        }
    }

    public void del(String key) {
        redisOperator.del(key);
    }

    public void batchPutTopN(String key, LinkedHashMap<String, String> memberMap, int limit, int expireSeconds) {
        String members = Joiner.on((String)",").join(memberMap.keySet());
        String scores = Joiner.on((String)",").join(memberMap.values());
        try {
            if (StringUtil.isEmpty((String)sha_topN)) {
                sha_topN = redisOperator.scriptLoad(LUA_PUT_TOP_N, key);
            }
            redisOperator.evalsha(sha_topN, 1, key, scores, members, String.valueOf(limit), String.valueOf(expireSeconds));
        }
        catch (JedisNoScriptException ex) {
            logger.info("put topN lua-script to remote server again,key:{}", (Object)key);
            sha_topN = redisOperator.scriptLoad(LUA_PUT_TOP_N, key);
            this.batchPutTopN(key, memberMap, limit, expireSeconds);
        }
        catch (Exception ex) {
            logger.error("redis batch put error,key:{},memberMap:{},limit:{}", new Object[]{key, memberMap, limit, ex});
        }
    }

    public void batchPutLastN(String key, LinkedHashMap<String, String> memberMap, int limit, int expireSeconds) {
        String members = Joiner.on((String)",").join(memberMap.keySet());
        String scores = Joiner.on((String)",").join(memberMap.values());
        try {
            if (StringUtil.isEmpty((String)sha_lastN)) {
                sha_lastN = redisOperator.scriptLoad(LUA_PUT_LAST_N, key);
            }
            redisOperator.evalsha(sha_lastN, 1, key, scores, members, String.valueOf(limit), String.valueOf(expireSeconds));
        }
        catch (JedisNoScriptException ex) {
            logger.info("put lastN lua-script to remote server again,key:{}", (Object)key);
            sha_lastN = redisOperator.scriptLoad(LUA_PUT_LAST_N, key);
            this.batchPutLastN(key, memberMap, limit, expireSeconds);
        }
        catch (Exception ex) {
            logger.error("redis batch put error,key:{},memberMap:{},limit:{}", new Object[]{key, memberMap, limit, ex});
        }
    }

    public List<Tuple> zrevrange(String key, int start, int end) {
        return redisOperator.zrevrangeWithScores(key, start, end);
    }

    public List<Tuple> zrange(String key, int start, int end) {
        return redisOperator.zrangeWithScores(key, start, end);
    }

    public List<String> lrange(String key, int start, int end) {
        return redisOperator.lrange(key, start, end);
    }

    public void set(String key, String value, int expireSeconds) {
        if (StringUtil.isEmpty((String)key) || StringUtil.isEmpty((String)value)) {
            return;
        }
        redisOperator.setex(key, (long)expireSeconds, value);
    }

    public void setBytes(String key, byte[] value, int expireSeconds) {
        if (StringUtil.isEmpty((String)key) || value == null) {
            return;
        }
        redisOperator.setex(key.getBytes(), (long)expireSeconds, value);
    }

    public byte[] getBytes(String key) {
        if (StringUtil.isEmpty((String)key)) {
            return null;
        }
        return redisOperator.get(key.getBytes());
    }

    public String get(String key) {
        return redisOperator.get(key);
    }

    public boolean exists(String key) {
        return redisOperator.exists(key);
    }

    public void expire(String key, int second) throws Exception {
        redisOperator.expire(key, second);
    }

    public void incrBy(String key, int step) throws Exception {
        redisOperator.incrBy(key, step);
    }

    static {
        try {
            String redisServers = LDPConfig.getVal("redis.cluster");
            assert (redisServers != null);
            String[] servers = redisServers.split(",");
            String password = LDPConfig.getVal("redis.cluster.password");
            redisOperator = new RedisClusterOperator();
            redisOperator.init(servers, password);
        }
        catch (Exception ex) {
            logger.error("init redis cluster error!", (Throwable)ex);
        }
        sha_topN = null;
        sha_lastN = null;
    }
}

