/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.rowkey.impl;

import com.dtstep.lighthouse.common.constant.StatConst;
import com.dtstep.lighthouse.common.constant.SysConst;
import com.dtstep.lighthouse.common.hash.HashUtil;
import com.dtstep.lighthouse.common.modal.Group;
import com.dtstep.lighthouse.common.modal.Stat;
import com.dtstep.lighthouse.common.sbr.StringBuilderHolder;
import com.dtstep.lighthouse.common.util.DateUtil;
import com.dtstep.lighthouse.common.util.Md5Util;
import com.dtstep.lighthouse.core.rowkey.KeyGenerator;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultKeyGenerator
implements KeyGenerator {
    private static final Logger logger = LoggerFactory.getLogger(DefaultKeyGenerator.class);
    private static final Cache<String, String> resultKeyCache = Caffeine.newBuilder().expireAfterWrite(2L, TimeUnit.MINUTES).maximumSize(5000L).softValues().build();

    @Override
    public String resultKey(Stat stat, int functionIndex, String dimensValue, long batchTime) {
        String cacheKey = stat.getRandomId() + "_" + functionIndex + "_" + dimensValue + "_" + batchTime;
        String rowKey = (String)resultKeyCache.get((Object)cacheKey, k -> this.generateBatchKey(stat, functionIndex, dimensValue, batchTime));
        return Objects.requireNonNull(rowKey);
    }

    public String generateBatchKey(Stat stat, int functionIndex, String dimensValue, long batchTime) {
        String key = null;
        try {
            TimeUnit timeUnit;
            long mergeTime;
            String timeUnitStr;
            String timeparam = stat.getTimeparam();
            String[] arr = timeparam.split("-");
            int interval = Integer.parseInt(arr[0]);
            switch (timeUnitStr = arr[1]) {
                case "minute": {
                    mergeTime = DateUtil.getHourStartTime((long)batchTime);
                    timeUnit = TimeUnit.MINUTES;
                    break;
                }
                case "hour": {
                    mergeTime = DateUtil.getDayStartTime((long)batchTime);
                    timeUnit = TimeUnit.HOURS;
                    break;
                }
                case "day": {
                    mergeTime = DateUtil.getMonthStartTime((long)batchTime);
                    timeUnit = TimeUnit.DAYS;
                    break;
                }
                case "second": {
                    mergeTime = DateUtil.getHourStartTime((long)batchTime);
                    timeUnit = TimeUnit.SECONDS;
                    break;
                }
                default: {
                    throw new Exception();
                }
            }
            long duration = timeUnit.toMillis(interval);
            String baseKey = this.generateBatchBaseKey(stat.getRandomId(), stat.getDataVersion(), mergeTime, dimensValue, functionIndex);
            String delta = Long.toHexString((batchTime - mergeTime) / duration);
            key = StringBuilderHolder.Smaller.getStringBuilder().append(baseKey).append(";").append(delta).toString();
        }
        catch (Exception ex) {
            logger.error("generate batch key error!", (Throwable)ex);
        }
        return key;
    }

    public String generateBatchBaseKey(String randomId, int dataVersion, long mergeTime, String dimensValue, int functionIndex) {
        String origin = Md5Util.getMD5((String)(randomId + "_" + dataVersion + "_" + mergeTime + "_" + dimensValue + "_" + functionIndex));
        int index = Math.abs((int)(HashUtil.BKDRHash((String)origin) % (long)SysConst._DBKeyPrefixArray.length));
        String prefix = SysConst._DBKeyPrefixArray[index];
        return prefix + this.getChronoLocation(mergeTime) + "|" + origin;
    }

    private long getChronoLocation(long mergeTime) {
        return ChronoUnit.MINUTES.between(Instant.ofEpochMilli(StatConst.SYSTEM_BASE_TIME), Instant.ofEpochMilli(mergeTime));
    }

    @Override
    public String dimensKey(Group group, String dimens, String dimensValue) {
        int index;
        int startIndex = Math.abs((int)(HashUtil.BKDRHash((String)(group.getRandomId() + "_" + group.getDataVersion() + "_" + dimens)) % (long)SysConst._DBKeyPrefixArray.length));
        int position = Math.abs((int)(HashUtil.BKDRHash((String)(group.getRandomId() + "_" + group.getDataVersion() + "_" + dimens + "_" + dimensValue)) % 4L));
        for (index = startIndex + position; index >= SysConst._DBKeyPrefixArray.length; index -= SysConst._DBKeyPrefixArray.length) {
        }
        String prefix = SysConst._DBKeyPrefixArray[index];
        String origin = Md5Util.getMD5((String)(group.getRandomId() + "_" + group.getDataVersion() + "_" + dimens));
        return prefix + origin + "_" + Md5Util.getMD5((String)dimensValue);
    }
}

