/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.sql;

import com.dtstep.lighthouse.common.util.StringUtil;
import java.util.Collection;
import java.util.stream.Collectors;

public class SqlBinder {
    private StringBuilder sbr;

    public SqlBinder(StringBuilder sbr) {
        this.sbr = sbr;
    }

    public SqlBinder() {
    }

    public String toString() {
        return this.sbr.toString();
    }

    public static class Builder {
        private final StringBuilder sbr = new StringBuilder(80);
        private boolean isFirstCondition = true;

        public Builder appendSegment(String segment) {
            this.sbr.append(" ").append(segment);
            return this;
        }

        public Builder appendSegmentIf(boolean is, String segment) {
            if (is) {
                this.sbr.append(" ").append(segment);
            }
            return this;
        }

        public Builder appendWhereSegment(String segment) {
            if (this.isFirstCondition) {
                this.sbr.append(String.format(" where %s", segment));
                this.isFirstCondition = false;
            } else {
                this.sbr.append(String.format(" and %s", segment));
            }
            return this;
        }

        public Builder appendLike(String k, Object v) {
            if (v == null || "-1".equals(v.toString())) {
                return this;
            }
            String param = Builder.avoidInject(v.toString());
            if (this.isFirstCondition) {
                this.sbr.append(String.format(" where %s like %s", k, "'%" + param + "%'"));
                this.isFirstCondition = false;
            } else {
                this.sbr.append(String.format(" and %s like %s", k, "'%" + param + "%'"));
            }
            return this;
        }

        public Builder appendLeftLike(String k, Object v) {
            if (v == null || "-1".equals(v.toString())) {
                return this;
            }
            String param = Builder.avoidInject(v.toString());
            if (this.isFirstCondition) {
                this.sbr.append(String.format(" where %s like %s", k, "'%" + param + "'"));
                this.isFirstCondition = false;
            } else {
                this.sbr.append(String.format(" and %s like %s", k, "'%" + param + "'"));
            }
            return this;
        }

        public Builder appendRightLike(String k, Object v) {
            if (v == null || "-1".equals(v.toString())) {
                return this;
            }
            String param = Builder.avoidInject(v.toString());
            if (this.isFirstCondition) {
                this.sbr.append(String.format(" where %s like %s", k, "'" + param + "%'"));
                this.isFirstCondition = false;
            } else {
                this.sbr.append(String.format(" and %s like %s", k, "'" + param + "%'"));
            }
            return this;
        }

        public Builder appendWhere(String k, Object v) {
            if (v == null || "-1".equals(v.toString())) {
                return this;
            }
            String param = Builder.avoidInject(v.toString());
            if (this.isFirstCondition) {
                this.sbr.append(String.format(" where %s = '%s'", k, param));
                this.isFirstCondition = false;
            } else {
                this.sbr.append(String.format(" and %s = '%s'", k, param));
            }
            return this;
        }

        public Builder appendIn(String k, Collection<Integer> collection) {
            String ids = collection == null || collection.isEmpty() ? "-1" : collection.stream().map(String::valueOf).collect(Collectors.joining(","));
            if (this.isFirstCondition) {
                this.sbr.append(String.format(" where %s in (%s)", k, ids));
                this.isFirstCondition = false;
            } else {
                this.sbr.append(String.format(" and %s in (%s)", k, ids));
            }
            return this;
        }

        public Builder appendInExceptNull(String k, Collection<Integer> collection) {
            if (collection == null) {
                return this;
            }
            String ids = collection.stream().map(String::valueOf).collect(Collectors.joining(","));
            if (StringUtil.isEmpty((String)ids)) {
                ids = "-1";
            }
            if (this.isFirstCondition) {
                this.sbr.append(String.format(" where %s in (%s)", k, ids));
                this.isFirstCondition = false;
            } else {
                this.sbr.append(String.format(" and %s in (%s)", k, ids));
            }
            return this;
        }

        static String avoidInject(String str) {
            return str.replaceAll("([';])+|(--)+", "");
        }

        public SqlBinder create() {
            return new SqlBinder(this.sbr);
        }
    }
}

