/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.storage.dimens.impl;

import com.dtstep.lighthouse.common.constant.SysConst;
import com.dtstep.lighthouse.common.entity.event.DimensBucket;
import com.dtstep.lighthouse.common.hash.HashUtil;
import com.dtstep.lighthouse.common.modal.Group;
import com.dtstep.lighthouse.common.util.Md5Util;
import com.dtstep.lighthouse.common.util.StringUtil;
import com.dtstep.lighthouse.core.rowkey.KeyGenerator;
import com.dtstep.lighthouse.core.rowkey.impl.DefaultKeyGenerator;
import com.dtstep.lighthouse.core.storage.common.LdpPut;
import com.dtstep.lighthouse.core.storage.common.LdpResult;
import com.dtstep.lighthouse.core.storage.dimens.DimensStorageHandler;
import com.dtstep.lighthouse.core.storage.warehouse.WarehouseStorageEngineProxy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDimensStorageHandler
implements DimensStorageHandler<DimensBucket, String> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultDimensStorageHandler.class);
    private static final KeyGenerator keyGenerator = new DefaultKeyGenerator();
    private static final String dimensColumnName = "v";

    @Override
    public void put(List<DimensBucket> list) throws Exception {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        HashSet<String> uniqueSet = new HashSet<String>();
        ArrayList<LdpPut> putList = new ArrayList<LdpPut>();
        for (DimensBucket quartet : list) {
            String rowKey = keyGenerator.dimensKey(quartet.getGroup(), quartet.getDimens(), quartet.getDimensValue());
            if (logger.isTraceEnabled()) {
                logger.trace("save dimens,token:{},dimens:{},dimensValue:{},rowKey:{}", new Object[]{quartet.getGroup().getToken(), quartet.getDimens(), quartet.getDimensValue(), rowKey});
            }
            LdpPut ldpPut = LdpPut.with(rowKey, dimensColumnName, quartet.getDimensValue(), quartet.getTtl());
            if (uniqueSet.contains(rowKey)) continue;
            putList.add(ldpPut);
            uniqueSet.add(rowKey);
        }
        WarehouseStorageEngineProxy.getInstance().puts("ldp_dimens_records", putList);
    }

    @Override
    public List<String> query(Group group, String dimens, String lastDimensValue, int limit) throws Exception {
        String baseKey = group.getRandomId() + "_" + group.getDataVersion() + "_" + dimens;
        int startIndex = Math.abs((int)(HashUtil.BKDRHash((String)baseKey) % (long)SysConst._DBKeyPrefixArray.length));
        ArrayList<String> dimensList = new ArrayList<String>();
        String startRow = null;
        if (!StringUtil.isEmpty((String)lastDimensValue)) {
            startRow = keyGenerator.dimensKey(group, dimens, lastDimensValue);
        }
        String finalStartRow = startRow;
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        for (int part = 0; part < 4; ++part) {
            int current;
            for (current = startIndex + part; current >= SysConst._DBKeyPrefixArray.length; current -= SysConst._DBKeyPrefixArray.length) {
            }
            indexList.add(current);
        }
        List sortedIndexList = indexList.stream().sorted().collect(Collectors.toList());
        Iterator iterator = sortedIndexList.iterator();
        block4: while (iterator.hasNext()) {
            int current = (Integer)iterator.next();
            if (dimensList.size() >= limit) break;
            String prefix = SysConst._DBKeyPrefixArray[current];
            Object partStartRow = prefix + Md5Util.getMD5((String)baseKey) + ".";
            String partEndRow = prefix + Md5Util.getMD5((String)baseKey) + "|";
            if (finalStartRow != null && finalStartRow.compareTo(partEndRow) > 0) continue;
            if (finalStartRow != null && finalStartRow.compareTo((String)partStartRow) > 0) {
                partStartRow = finalStartRow;
            }
            try {
                int requireSize;
                List<LdpResult<String>> dbResults;
                do {
                    requireSize = limit - dimensList.size();
                    dbResults = WarehouseStorageEngineProxy.getInstance().scan("ldp_dimens_records", (String)partStartRow, partEndRow, requireSize, String.class);
                    if (CollectionUtils.isEmpty(dbResults)) continue block4;
                    for (LdpResult<String> ldpResult : dbResults) {
                        String dimensValue = ldpResult.getData();
                        if (!StringUtil.isNotEmpty((String)dimensValue) || dimensList.size() >= limit) continue;
                        partStartRow = ldpResult.getKey();
                        dimensList.add(dimensValue);
                    }
                    if (dimensList.size() >= limit) continue block4;
                } while (dbResults.size() >= requireSize);
            }
            catch (Exception ex) {
                logger.error("load dimens error!", (Throwable)ex);
            }
        }
        return dimensList;
    }
}

