/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.storage.limit.impl;

import com.dtstep.lighthouse.common.entity.event.LimitBucket;
import com.dtstep.lighthouse.common.entity.stat.StatExtEntity;
import com.dtstep.lighthouse.common.entity.state.StatState;
import com.dtstep.lighthouse.common.entity.view.LimitValue;
import com.dtstep.lighthouse.common.entity.view.StatValue;
import com.dtstep.lighthouse.common.enums.LimitTypeEnum;
import com.dtstep.lighthouse.common.enums.function.FunctionEnum;
import com.dtstep.lighthouse.common.hash.HashUtil;
import com.dtstep.lighthouse.common.util.DateUtil;
import com.dtstep.lighthouse.common.util.JsonUtil;
import com.dtstep.lighthouse.core.batch.BatchAdapter;
import com.dtstep.lighthouse.core.lock.RedissonLock;
import com.dtstep.lighthouse.core.redis.RedisClient;
import com.dtstep.lighthouse.core.rowkey.KeyGenerator;
import com.dtstep.lighthouse.core.rowkey.impl.DefaultKeyGenerator;
import com.dtstep.lighthouse.core.storage.limit.LimitStorageEngine;
import com.dtstep.lighthouse.core.storage.result.ResultStorageSelector;
import com.dtstep.lighthouse.core.wrapper.GroupDBWrapper;
import com.dtstep.lighthouse.core.wrapper.StatDBWrapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.resps.Tuple;

public class RedisLimitStorageEngine
extends LimitStorageEngine<LimitBucket, LimitValue> {
    private static final Logger logger = LoggerFactory.getLogger(RedisLimitStorageEngine.class);
    private static final KeyGenerator keyGenerator = new DefaultKeyGenerator();
    public static final Comparator<LimitValue> ascComparator = Comparator.comparing(o -> new BigDecimal(o.getScore().toString()));
    public static final Comparator<LimitValue> descComparator = (o1, o2) -> new BigDecimal(o2.getScore().toString()).compareTo(new BigDecimal(o1.getScore().toString()));

    @Override
    public void limit(List<LimitBucket> limitBuckets) throws Exception {
        Map<String, List<LimitBucket>> limitMap = limitBuckets.stream().collect(Collectors.groupingBy(x -> x.getStatId() + "_" + x.getBatchTime() + "_" + HashUtil.BKDRHash((String)x.getDimensValue()) % 3L));
        for (String ignored : limitMap.keySet()) {
            List<LimitBucket> events = limitMap.get(ignored);
            int statId = events.get(0).getStatId();
            long batchTime = events.get(0).getBatchTime();
            int salt = Integer.parseInt(ignored.substring(ignored.lastIndexOf("_") + 1));
            Set<String> dimensSet = events.stream().map(LimitBucket::getDimensValue).collect(Collectors.toSet());
            StatExtEntity statExtEntity = StatDBWrapper.queryById(statId);
            if (statExtEntity == null) continue;
            try {
                this.process(statExtEntity, dimensSet, batchTime, salt);
            }
            catch (Exception ex) {
                logger.error("lighthouse limit process error!", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void process(StatExtEntity statExtEntity, Set<String> dimensSet, long batchTime, int salt) throws Exception {
        stopWatch = new StopWatch();
        stopWatch.start();
        templateEntity = statExtEntity.getTemplateEntity();
        limitTypeEnum = templateEntity.getLimitTypeEnum();
        groupExtEntity = GroupDBWrapper.queryById(statExtEntity.getGroupId());
        if (CollectionUtils.isEmpty(dimensSet) || groupExtEntity == null) {
            return;
        }
        baseKey = BatchAdapter.generateLimitKey(statExtEntity.getRandomId(), statExtEntity.getDataVersion(), batchTime);
        lockKey = "lock_limit_" + baseKey + "_" + salt + "_" + DateUtil.formatTimeStamp((long)batchTime, (String)"yyyyMMddHHmmss");
        redisKey = "limitN_" + baseKey + "_" + salt;
        isLock = RedissonLock.tryLock(lockKey, 5L, 3L, TimeUnit.MINUTES);
        expireSeconds = (int)statExtEntity.getTimeUnit().toSeconds(statExtEntity.getTimeParamInterval());
        cacheSize = this.getLimitCacheSize(statExtEntity, templateEntity.getLimitSize());
        if (isLock) {
            try {
                t1 = System.currentTimeMillis();
                dbMap = ResultStorageSelector.queryWithDimensList(statExtEntity, (List<String>)Lists.newArrayList(dimensSet), batchTime);
                t2 = System.currentTimeMillis();
                if (RedisLimitStorageEngine.logger.isTraceEnabled()) {
                    RedisLimitStorageEngine.logger.trace("limit data query,stat:{},formula:{},dimens:{},dimens size:{},dimens value:{},cost:{}", new Object[]{statExtEntity.getId(), templateEntity.getStat(), templateEntity.getDimens(), dimensSet.size(), JsonUtil.toJSONString(dimensSet), t2 - t1});
                }
                keyValueMap = Maps.newLinkedHashMap();
                if (limitTypeEnum == LimitTypeEnum.TOP) {
                    t3 = System.currentTimeMillis();
                    dbMap.entrySet().stream().sorted(Comparator.comparing((Function<Map.Entry, Double>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$process$1(java.util.Map$Entry ), (Ljava/util/Map$Entry;)Ljava/lang/Double;)())).limit(cacheSize).forEachOrdered((Consumer<Map.Entry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$process$2(java.util.LinkedHashMap java.util.Map$Entry ), (Ljava/util/Map$Entry;)V)((LinkedHashMap)keyValueMap));
                    t4 = System.currentTimeMillis();
                    RedisClient.getInstance().batchPutTopN(redisKey, keyValueMap, cacheSize, expireSeconds * 10);
                    t5 = System.currentTimeMillis();
                    if (!RedisLimitStorageEngine.logger.isDebugEnabled()) ** GOTO lbl47
                    RedisLimitStorageEngine.logger.debug("limit topN put,stat:{},batchTime:{},redis key:{},dimensSet size:{},keyValueMap size:{},cost1:{},cost2:{},cost3:{}", new Object[]{statExtEntity.getId(), DateUtil.formatTimeStamp((long)batchTime, (String)"yyyy-MM-dd HH:mm:ss"), redisKey, dimensSet.size(), keyValueMap.size(), t2 - t1, t4 - t3, t5 - t4});
                }
                if (limitTypeEnum != LimitTypeEnum.LAST) ** GOTO lbl47
                t3 = System.currentTimeMillis();
                dbMap.entrySet().stream().sorted(Comparator.comparing((Function<Map.Entry, Double>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$process$3(java.util.Map$Entry ), (Ljava/util/Map$Entry;)Ljava/lang/Double;)())).limit(cacheSize).forEachOrdered((Consumer<Map.Entry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$process$4(java.util.LinkedHashMap java.util.Map$Entry ), (Ljava/util/Map$Entry;)V)((LinkedHashMap)keyValueMap));
                t4 = System.currentTimeMillis();
                RedisClient.getInstance().batchPutLastN(redisKey, keyValueMap, cacheSize, expireSeconds * 10);
                t5 = System.currentTimeMillis();
                if (!RedisLimitStorageEngine.logger.isDebugEnabled()) ** GOTO lbl47
                RedisLimitStorageEngine.logger.debug("limit lastN put,stat:{},batchTime:{},redis key:{},dimensSet size:{},keyValueMap size:{},cost1:{},cost2:{},cost3:{}", new Object[]{statExtEntity.getId(), DateUtil.formatTimeStamp((long)batchTime, (String)"yyyy-MM-dd HH:mm:ss"), redisKey, dimensSet.size(), keyValueMap.size(), t2 - t1, t4 - t3, t5 - t4});
            }
            catch (Exception ex) {
                RedisLimitStorageEngine.logger.error("lighthouse stat,limit process error,statId:{}!", (Object)statExtEntity.getId(), (Object)ex);
            }
            finally {
                RedissonLock.unLock(lockKey);
            }
        } else {
            RedisLimitStorageEngine.logger.error("try lock failed,thread unable to acquire lock,this batch data may be lost,cost:{}ms!", (Object)stopWatch.getTime());
        }
lbl47:
        // 7 sources

        if (RedisLimitStorageEngine.logger.isDebugEnabled()) {
            RedisLimitStorageEngine.logger.debug("limit process,stat:{},isLock:{},dimens size:{},cost:{}ms", new Object[]{statExtEntity.getId(), isLock, dimensSet.size(), stopWatch.getTime()});
        }
    }

    private int getLimitCacheSize(StatExtEntity statExtEntity, int limitSize) {
        List stateList = statExtEntity.getTemplateEntity().getStatStateList();
        if (stateList.size() != 1) {
            return 5000;
        }
        FunctionEnum functionTypeEnum = ((StatState)stateList.get(0)).getFunctionEnum();
        if (functionTypeEnum == FunctionEnum.AVG) {
            return 5000;
        }
        return limitSize;
    }

    @Override
    public List<LimitValue> query(StatExtEntity statExtEntity, long batchTime) throws Exception {
        ArrayList<LimitValue> resultList = new ArrayList<LimitValue>();
        String baseKey = BatchAdapter.generateLimitKey(statExtEntity.getRandomId(), statExtEntity.getDataVersion(), batchTime);
        ArrayList limitSet = new ArrayList();
        int limitSize = statExtEntity.getTemplateEntity().getLimitSize();
        if (statExtEntity.getTemplateEntity().getLimitTypeEnum() == LimitTypeEnum.TOP) {
            IntStream.range(0, 3).forEach(z -> {
                String redisKey = "limitN_" + baseKey + "_" + z;
                List<Tuple> tempDimensSet = RedisClient.getInstance().zrevrange(redisKey, 0, limitSize);
                if (CollectionUtils.isNotEmpty(tempDimensSet)) {
                    limitSet.addAll(tempDimensSet);
                }
            });
            List dimensList = limitSet.stream().sorted(Comparator.comparing(Tuple::getScore).reversed()).map(Tuple::getElement).collect(Collectors.toList());
            List<String> topDimensList = dimensList.subList(0, Math.min(dimensList.size(), limitSize));
            LinkedHashMap<String, StatValue> valueMap = ResultStorageSelector.queryWithDimensList(statExtEntity, topDimensList, batchTime);
            for (String dimens : valueMap.keySet()) {
                LimitValue limitValue = new LimitValue(dimens, ((StatValue)valueMap.get(dimens)).getValue());
                resultList.add(limitValue);
            }
            resultList.sort(descComparator);
        } else if (statExtEntity.getTemplateEntity().getLimitTypeEnum() == LimitTypeEnum.LAST) {
            IntStream.range(0, 3).forEach(z -> {
                String redisKey = "limitN_" + baseKey + "_" + z;
                List<Tuple> tempDimensSet = RedisClient.getInstance().zrange(redisKey, 0, limitSize);
                if (CollectionUtils.isNotEmpty(tempDimensSet)) {
                    limitSet.addAll(tempDimensSet);
                }
            });
            List dimensList = limitSet.stream().sorted(Comparator.comparing(Tuple::getScore)).map(Tuple::getElement).collect(Collectors.toList());
            List<String> lastDimensList = dimensList.subList(0, Math.min(dimensList.size(), limitSize));
            LinkedHashMap<String, StatValue> valueMap = ResultStorageSelector.queryWithDimensList(statExtEntity, lastDimensList, batchTime);
            for (String dimens : valueMap.keySet()) {
                LimitValue limitValue = new LimitValue(dimens, ((StatValue)valueMap.get(dimens)).getValue());
                resultList.add(limitValue);
            }
            resultList.sort(ascComparator);
        }
        return resultList;
    }

    private static /* synthetic */ void lambda$process$4(LinkedHashMap keyValueMap, Map.Entry e) {
        keyValueMap.put((String)e.getKey(), ((StatValue)e.getValue()).getValue().toString());
    }

    private static /* synthetic */ Double lambda$process$3(Map.Entry o) {
        return Double.parseDouble(((StatValue)o.getValue()).getValue().toString());
    }

    private static /* synthetic */ void lambda$process$2(LinkedHashMap keyValueMap, Map.Entry e) {
        keyValueMap.put((String)e.getKey(), ((StatValue)e.getValue()).getValue().toString());
    }

    private static /* synthetic */ Double lambda$process$1(Map.Entry o) {
        return 0.0 - Double.parseDouble(((StatValue)o.getValue()).getValue().toString());
    }
}

