/*
 * Decompiled with CFR 0.152.
 */
package com.dtstep.lighthouse.core.storage.result.impl;

import com.dtstep.lighthouse.common.entity.calculate.MicroBucket;
import com.dtstep.lighthouse.common.entity.stat.StatExtEntity;
import com.dtstep.lighthouse.common.entity.state.StatState;
import com.dtstep.lighthouse.common.entity.view.StatValue;
import com.dtstep.lighthouse.common.modal.MetaTable;
import com.dtstep.lighthouse.common.modal.Stat;
import com.dtstep.lighthouse.common.util.DateUtil;
import com.dtstep.lighthouse.common.util.StringUtil;
import com.dtstep.lighthouse.core.batch.BatchAdapter;
import com.dtstep.lighthouse.core.expression.embed.AviatorHandler;
import com.dtstep.lighthouse.core.rowkey.KeyGenerator;
import com.dtstep.lighthouse.core.rowkey.impl.DefaultKeyGenerator;
import com.dtstep.lighthouse.core.storage.common.CompareOperator;
import com.dtstep.lighthouse.core.storage.common.IndicatorGet;
import com.dtstep.lighthouse.core.storage.common.LdpGet;
import com.dtstep.lighthouse.core.storage.common.LdpIncrement;
import com.dtstep.lighthouse.core.storage.common.LdpPut;
import com.dtstep.lighthouse.core.storage.common.LdpResult;
import com.dtstep.lighthouse.core.storage.result.ResultStorageHandler;
import com.dtstep.lighthouse.core.storage.warehouse.WarehouseStorageEngineProxy;
import com.dtstep.lighthouse.core.wrapper.MetaTableWrapper;
import com.dtstep.lighthouse.core.wrapper.StatDBWrapper;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultResultStorageHandler
implements ResultStorageHandler<MicroBucket, StatValue> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultResultStorageHandler.class);
    private static final KeyGenerator keyGenerator = new DefaultKeyGenerator();

    @Override
    public void increment(List<MicroBucket> bucketList) throws Exception {
        Map<String, List<MicroBucket>> resultMap = bucketList.stream().collect(Collectors.groupingBy(MicroBucket::getMetaName));
        for (String metaName : resultMap.keySet()) {
            List<MicroBucket> list = resultMap.get(metaName);
            Map<String, List<MicroBucket>> subMap = list.stream().collect(Collectors.groupingBy(x -> x.getRowKey() + "_" + x.getColumn()));
            ArrayList ldpIncrements = Lists.newArrayList();
            for (String key : subMap.keySet()) {
                List<MicroBucket> subList = subMap.get(key);
                MicroBucket bucket = subList.get(0);
                String rowKey = bucket.getRowKey();
                String column = bucket.getColumn();
                long ttl = bucket.getTtl();
                long value = subList.stream().map(MicroBucket::getValue).mapToLong(x -> x).sum();
                if (logger.isDebugEnabled()) {
                    logger.debug("lighthouse debug,batch increment,statId:{},batchTime:{},meta:{},rowKey:{},dimens:{},column:{},functionIndex:{},value:{},ttl:{}", new Object[]{bucket.getStatId(), DateUtil.formatTimeStamp((long)bucket.getBatchTime(), (String)"yyyy-MM-dd HH:mm:ss"), bucket.getMetaName(), bucket.getRowKey(), bucket.getDimensValue(), bucket.getColumn(), bucket.getFunctionIndex(), value, bucket.getTtl()});
                }
                LdpIncrement ldpIncrement = LdpIncrement.with(rowKey, column, value, ttl);
                ldpIncrements.add(ldpIncrement);
            }
            try {
                WarehouseStorageEngineProxy.getInstance().increments(metaName, ldpIncrements);
            }
            catch (Exception ex) {
                logger.error("data increment exception!", (Throwable)ex);
            }
        }
    }

    @Override
    public void maxPut(List<MicroBucket> bucketList) throws Exception {
        Map<String, List<MicroBucket>> putMap = bucketList.stream().collect(Collectors.groupingBy(MicroBucket::getMetaName));
        for (String metaName : putMap.keySet()) {
            List<MicroBucket> events = putMap.get(metaName);
            Map<String, List<MicroBucket>> subMap = events.stream().collect(Collectors.groupingBy(x -> x.getRowKey() + "_" + x.getColumn()));
            ArrayList puts = Lists.newArrayList();
            for (String key : subMap.keySet()) {
                List<MicroBucket> subList = subMap.get(key);
                MicroBucket bucket = subList.get(0);
                String rowKey = bucket.getRowKey();
                String column = bucket.getColumn();
                long ttl = bucket.getTtl();
                long value = subList.stream().map(MicroBucket::getValue).mapToLong(x -> x).max().getAsLong();
                if (logger.isDebugEnabled()) {
                    logger.debug("lighthouse debug,batch maxPut,statId:{},batchTime:{},meta:{},rowKey:{},dimens:{},column:{},functionIndex:{},value:{},ttl:{}", new Object[]{bucket.getStatId(), DateUtil.formatTimeStamp((long)bucket.getBatchTime(), (String)"yyyy-MM-dd HH:mm:ss"), bucket.getMetaName(), bucket.getRowKey(), bucket.getDimensValue(), bucket.getColumn(), bucket.getFunctionIndex(), value, bucket.getTtl()});
                }
                LdpPut ldpPut = LdpPut.with(rowKey, column, value, ttl);
                puts.add(ldpPut);
            }
            try {
                WarehouseStorageEngineProxy.getInstance().putsWithCompare(metaName, CompareOperator.GREATER, puts);
            }
            catch (Exception ex) {
                logger.error("data put exception!", (Throwable)ex);
            }
        }
    }

    @Override
    public void minPut(List<MicroBucket> bucketList) throws Exception {
        Map<String, List<MicroBucket>> putMap = bucketList.stream().collect(Collectors.groupingBy(MicroBucket::getMetaName));
        for (String metaName : putMap.keySet()) {
            List<MicroBucket> events = putMap.get(metaName);
            Map<String, List<MicroBucket>> subMap = events.stream().collect(Collectors.groupingBy(x -> x.getRowKey() + "_" + x.getColumn()));
            ArrayList puts = Lists.newArrayList();
            for (String key : subMap.keySet()) {
                List<MicroBucket> subList = subMap.get(key);
                MicroBucket bucket = subList.get(0);
                String rowKey = bucket.getRowKey();
                String column = bucket.getColumn();
                long ttl = bucket.getTtl();
                long value = subList.stream().map(MicroBucket::getValue).mapToLong(x -> x).min().getAsLong();
                if (logger.isDebugEnabled()) {
                    logger.debug("lighthouse debug,batch minPut,statId:{},batchTime:{},meta:{},rowKey:{},dimens:{},column:{},functionIndex:{},value:{},ttl:{}", new Object[]{bucket.getStatId(), DateUtil.formatTimeStamp((long)bucket.getBatchTime(), (String)"yyyy-MM-dd HH:mm:ss"), bucket.getMetaName(), bucket.getRowKey(), bucket.getDimensValue(), bucket.getColumn(), bucket.getFunctionIndex(), value, bucket.getTtl()});
                }
                LdpPut ldpPut = LdpPut.with(rowKey, column, value, ttl);
                puts.add(ldpPut);
            }
            try {
                WarehouseStorageEngineProxy.getInstance().putsWithCompare(metaName, CompareOperator.LESSER, puts);
            }
            catch (Exception ex) {
                logger.error("data put exception!", (Throwable)ex);
            }
        }
    }

    @Override
    public void put(List<MicroBucket> bucketList) throws Exception {
        Map<String, List<MicroBucket>> putMap = bucketList.stream().collect(Collectors.groupingBy(MicroBucket::getMetaName));
        for (String metaName : putMap.keySet()) {
            List<MicroBucket> events = putMap.get(metaName);
            Map<String, List<MicroBucket>> tempMap = events.stream().collect(Collectors.groupingBy(x -> x.getRowKey() + "_" + x.getColumn()));
            ArrayList ldpPuts = Lists.newArrayList();
            for (String key : tempMap.keySet()) {
                List<MicroBucket> subList = tempMap.get(key);
                MicroBucket bucket = subList.get(0);
                String rowKey = bucket.getRowKey();
                String column = bucket.getColumn();
                long ttl = bucket.getTtl();
                long value = subList.get(0).getValue();
                if (logger.isDebugEnabled()) {
                    logger.debug("lighthouse debug,batch put,statId:{},batchTime:{},meta:{},rowKey:{},dimens:{},column:{},functionIndex:{},value:{},ttl:{}", new Object[]{bucket.getStatId(), DateUtil.formatTimeStamp((long)bucket.getBatchTime(), (String)"yyyy-MM-dd HH:mm:ss"), bucket.getMetaName(), bucket.getRowKey(), bucket.getDimensValue(), bucket.getColumn(), bucket.getFunctionIndex(), value, bucket.getTtl()});
                }
                LdpPut ldpPut = LdpPut.with(rowKey, column, value, ttl);
                ldpPuts.add(ldpPut);
            }
            try {
                WarehouseStorageEngineProxy.getInstance().puts(metaName, ldpPuts);
            }
            catch (Exception ex) {
                logger.error("data put exception!", (Throwable)ex);
            }
        }
    }

    @Override
    public StatValue query(StatExtEntity statExtEntity, String dimensValue, long batchTime) throws Exception {
        if (StringUtil.isEmpty((String)dimensValue)) {
            dimensValue = null;
        }
        LinkedHashMap<String, List<StatValue>> resultMap = this.queryWithDimensList(statExtEntity, dimensValue == null ? null : List.of(dimensValue), List.of(Long.valueOf(batchTime)));
        return MapUtils.isEmpty(resultMap) || CollectionUtils.isEmpty((Collection)((Collection)resultMap.get(dimensValue))) ? null : (StatValue)((List)resultMap.get(dimensValue)).get(0);
    }

    @Override
    public List<StatValue> query(StatExtEntity statExtEntity, String dimensValue, List<Long> batchTimeList) throws Exception {
        if (StringUtil.isEmpty((String)dimensValue)) {
            dimensValue = null;
        }
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(batchTimeList));
        LinkedHashMap<String, List<StatValue>> resultMap = this.queryWithDimensList(statExtEntity, dimensValue == null ? null : List.of(dimensValue), batchTimeList);
        return MapUtils.isEmpty(resultMap) || CollectionUtils.isEmpty((Collection)((Collection)resultMap.get(dimensValue))) ? null : (List)resultMap.get(dimensValue);
    }

    @Override
    public LinkedHashMap<String, StatValue> queryWithDimensList(StatExtEntity statExtEntity, List<String> dimensValueList, long batchTime) throws Exception {
        LinkedHashMap<String, List<StatValue>> dbMap = this.queryWithDimensList(statExtEntity, dimensValueList, List.of(Long.valueOf(batchTime)));
        LinkedHashMap<String, StatValue> resultMap = new LinkedHashMap<String, StatValue>();
        for (String key : dbMap.keySet()) {
            resultMap.put(key, dbMap.get(key).get(0));
        }
        return resultMap;
    }

    @Override
    public LinkedHashMap<String, List<StatValue>> queryWithDimensList(StatExtEntity statExtEntity, List<String> dimensValueList, List<Long> batchTimeList) throws Exception {
        String metaName;
        List statStates = statExtEntity.getTemplateEntity().getStatStateList();
        int resMeta = statExtEntity.getMetaId();
        if (statExtEntity.isBuiltIn()) {
            metaName = "ldp_system_result";
        } else {
            MetaTable metaTable = MetaTableWrapper.queryById(resMeta);
            metaName = metaTable.getMetaName();
        }
        if (dimensValueList != null) {
            Validate.isTrue((dimensValueList.size() <= 150000 ? 1 : 0) != 0);
        }
        ArrayList<LdpGet> getList = new ArrayList<LdpGet>();
        for (long batchTime : batchTimeList) {
            if (dimensValueList == null) {
                for (StatState statState : statStates) {
                    String aggregateKey = keyGenerator.resultKey((Stat)statExtEntity, statState.getFunctionIndex(), null, batchTime);
                    String[] keyArr = aggregateKey.split(";");
                    String key = keyArr[0];
                    String column = keyArr[1];
                    LdpGet ldpGet = LdpGet.with(key, column);
                    getList.add(ldpGet);
                }
            } else {
                for (String string : dimensValueList) {
                    for (StatState statState : statStates) {
                        String aggregateKey = keyGenerator.resultKey((Stat)statExtEntity, statState.getFunctionIndex(), string, batchTime);
                        String[] keyArr = aggregateKey.split(";");
                        String key = keyArr[0];
                        String column = keyArr[1];
                        LdpGet ldpGet = LdpGet.with(key, column);
                        getList.add(ldpGet);
                    }
                }
            }
            Validate.isTrue((getList.size() <= 150000 ? 1 : 0) != 0);
        }
        List<LdpResult<Long>> results = WarehouseStorageEngineProxy.getInstance().gets(metaName, getList, Long.class);
        Map<String, LdpResult<Long>> dbResultMap = results.stream().filter(x -> x.getData() != null).collect(Collectors.toMap(x -> x.getKey() + ";" + x.getColumn(), x -> x));
        LinkedHashMap<String, List<StatValue>> resultMap = new LinkedHashMap<String, List<StatValue>>();
        if (dimensValueList == null) {
            ArrayList<StatValue> valueList = new ArrayList<StatValue>();
            for (long batchTime : batchTimeList) {
                StatValue statValue = this.calculate(statExtEntity, null, batchTime, dbResultMap);
                valueList.add(statValue);
            }
            resultMap.put(null, valueList);
        } else {
            for (String string : dimensValueList) {
                ArrayList<StatValue> valueList = new ArrayList<StatValue>();
                for (long batchTime : batchTimeList) {
                    StatValue statValue = this.calculate(statExtEntity, string, batchTime, dbResultMap);
                    valueList.add(statValue);
                }
                resultMap.put(string, valueList);
            }
        }
        return resultMap;
    }

    @Override
    @Deprecated
    public LinkedHashMap<String, List<StatValue>> queryWithDimensList0(StatExtEntity statExtEntity, List<String> dimensValueList, List<Long> batchTimeList) throws Exception {
        Object compatibleResult;
        String metaName;
        List statStates = statExtEntity.getTemplateEntity().getStatStateList();
        int resMeta = statExtEntity.getMetaId();
        if (statExtEntity.isBuiltIn()) {
            metaName = "ldp_system_result";
        } else {
            MetaTable metaTable = MetaTableWrapper.queryById(resMeta);
            metaName = metaTable.getMetaName();
        }
        if (dimensValueList != null) {
            Validate.isTrue((dimensValueList.size() <= 150000 ? 1 : 0) != 0);
        }
        ArrayList<LdpGet> getList = new ArrayList<LdpGet>();
        ArrayList<LdpGet> compatibleGetList = new ArrayList<LdpGet>();
        HashMap<String, String> compatibleKeyMap = new HashMap<String, String>();
        for (long batchTime : batchTimeList) {
            if (dimensValueList == null) {
                for (StatState statState : statStates) {
                    LdpGet ldpGet;
                    String aggregateKey = keyGenerator.resultKey((Stat)statExtEntity, statState.getFunctionIndex(), null, batchTime);
                    String[] keyArr = aggregateKey.split(";");
                    String key = keyArr[0];
                    String column = keyArr[1];
                    String compatibleKey = this.getCompatibleKey(key);
                    if (StringUtil.isNotEmpty((String)compatibleKey)) {
                        ldpGet = LdpGet.with(compatibleKey, column);
                        compatibleGetList.add(ldpGet);
                        compatibleKeyMap.put(compatibleKey, key);
                    }
                    ldpGet = LdpGet.with(key, column);
                    getList.add(ldpGet);
                }
            } else {
                for (String string : dimensValueList) {
                    for (StatState statState : statStates) {
                        LdpGet ldpGet;
                        String aggregateKey = keyGenerator.resultKey((Stat)statExtEntity, statState.getFunctionIndex(), string, batchTime);
                        String[] keyArr = aggregateKey.split(";");
                        String key = keyArr[0];
                        String column = keyArr[1];
                        String compatibleKey = this.getCompatibleKey(key);
                        if (StringUtil.isNotEmpty((String)compatibleKey)) {
                            ldpGet = LdpGet.with(compatibleKey, column);
                            compatibleGetList.add(ldpGet);
                            compatibleKeyMap.put(compatibleKey, key);
                        }
                        ldpGet = LdpGet.with(key, column);
                        getList.add(ldpGet);
                    }
                }
            }
            Validate.isTrue((getList.size() <= 150000 ? 1 : 0) != 0);
        }
        List<LdpResult<Long>> results = WarehouseStorageEngineProxy.getInstance().gets(metaName, getList, Long.class);
        List<LdpResult<Long>> compatibleResults = WarehouseStorageEngineProxy.getInstance().gets(metaName, compatibleGetList, Long.class);
        Map<String, LdpResult<Long>> dbResultMap = results.stream().filter(x -> x.getData() != null).collect(Collectors.toMap(x -> x.getKey() + ";" + x.getColumn(), x -> x));
        Map<String, LdpResult> compatibleDBResultMap = compatibleResults.stream().filter(x -> x.getData() != null).collect(Collectors.toMap(x -> x.getKey() + ";" + x.getColumn(), x -> x));
        for (String compatibleAggregateKey : compatibleDBResultMap.keySet()) {
            compatibleResult = compatibleDBResultMap.get(compatibleAggregateKey);
            if (compatibleResult == null || (Long)((LdpResult)compatibleResult).getData() == 0L) continue;
            String[] keyArr = compatibleAggregateKey.split(";");
            String compatibleKey = keyArr[0];
            String column = keyArr[1];
            String mappingKey = (String)compatibleKeyMap.get(compatibleKey);
            ((LdpResult)compatibleResult).setKey(mappingKey);
            dbResultMap.put(mappingKey + ";" + column, (LdpResult<Long>)compatibleResult);
        }
        LinkedHashMap<String, List<StatValue>> linkedHashMap = new LinkedHashMap<String, List<StatValue>>();
        if (dimensValueList == null) {
            ArrayList<StatValue> valueList = new ArrayList<StatValue>();
            compatibleResult = batchTimeList.iterator();
            while (compatibleResult.hasNext()) {
                long batchTime = (Long)compatibleResult.next();
                StatValue statValue = this.calculate(statExtEntity, null, batchTime, dbResultMap);
                valueList.add(statValue);
            }
            linkedHashMap.put(null, valueList);
        } else {
            for (String dimensValue : dimensValueList) {
                ArrayList<StatValue> valueList = new ArrayList<StatValue>();
                for (long batchTime : batchTimeList) {
                    StatValue statValue = this.calculate(statExtEntity, dimensValue, batchTime, dbResultMap);
                    valueList.add(statValue);
                }
                linkedHashMap.put(dimensValue, valueList);
            }
        }
        return linkedHashMap;
    }

    private String getCompatibleKey(String key) {
        String[] arr = key.split("\\|");
        if (arr.length >= 2 && StringUtil.isNumber((String)arr[1])) {
            return arr[0] + "|" + arr[2];
        }
        return null;
    }

    public StatValue calculate(StatExtEntity statExtEntity, String dimensValue, long batchTime, Map<String, LdpResult<Long>> resultMap) {
        Object object;
        boolean invalidFlag = false;
        String formula = statExtEntity.getTemplateEntity().getCompleteStat();
        StatValue statValue = new StatValue();
        statValue.setBatchTime(batchTime);
        statValue.setDimensValue(dimensValue);
        statValue.setDisplayBatchTime(BatchAdapter.dateTimeFormat(statExtEntity.getTimeparam(), batchTime));
        long lastUpdateTime = 0L;
        HashMap<String, Object> envMap = new HashMap<String, Object>();
        int variableIndex = 97;
        List statStates = statExtEntity.getTemplateEntity().getStatStateList();
        ArrayList<String> statesValue = new ArrayList<String>();
        for (StatState statState : statStates) {
            LdpResult<Long> ldpResult;
            String stateBody = statState.getStateBody();
            String aggregateKey = keyGenerator.resultKey((Stat)statExtEntity, statState.getFunctionIndex(), dimensValue, batchTime);
            LdpResult<Long> ldpResult2 = ldpResult = resultMap == null || resultMap.get(aggregateKey) == null ? null : resultMap.get(aggregateKey);
            if (ldpResult == null) {
                invalidFlag = true;
                statesValue.add("0");
                continue;
            }
            BigDecimal value = BigDecimal.valueOf((Long)ldpResult.getData()).divide(BigDecimal.valueOf(1000.0), 3, RoundingMode.HALF_UP).stripTrailingZeros();
            String replaceId = String.valueOf((char)variableIndex);
            ++variableIndex;
            envMap.put(replaceId, value.toPlainString());
            statesValue.add(value.toPlainString());
            formula = formula.replace(stateBody, replaceId);
            if (lastUpdateTime >= ldpResult.getTimestamp()) continue;
            lastUpdateTime = ldpResult.getTimestamp();
        }
        statValue.setStatesValue(statesValue);
        if (!invalidFlag && (object = AviatorHandler.execute(formula, envMap)) != null) {
            if (object.getClass() == BigDecimal.class) {
                BigDecimal bigDecimal = ((BigDecimal)object).stripTrailingZeros();
                statValue.setValue((Object)bigDecimal.toPlainString());
            } else {
                statValue.setValue((Object)new BigDecimal(object.toString()).setScale(3, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString());
            }
        }
        statValue.setLastUpdateTime(lastUpdateTime);
        return statValue;
    }

    public LinkedHashMap<IndicatorGet, Object> query(List<IndicatorGet> indicators) throws Exception {
        LinkedHashMap<IndicatorGet, Object> resultMap = new LinkedHashMap<IndicatorGet, Object>();
        if (CollectionUtils.isEmpty(indicators)) {
            return resultMap;
        }
        HashMap<String, List> keyMap = new HashMap<String, List>();
        HashMap<Integer, StatExtEntity> statMap = new HashMap<Integer, StatExtEntity>();
        long current = System.currentTimeMillis();
        for (IndicatorGet indicatorGet : indicators) {
            int metaId;
            MetaTable metaTable;
            long batchTime;
            int statId = indicatorGet.getStatId();
            StatExtEntity statExtEntity = StatDBWrapper.queryById(statId);
            if (statExtEntity == null || (batchTime = indicatorGet.getBatchTime()) > current || (metaTable = MetaTableWrapper.queryById(metaId = statExtEntity.getMetaId().intValue())) == null) continue;
            statMap.put(statExtEntity.getId(), statExtEntity);
            String metaName = metaTable.getMetaName();
            int indicator = indicatorGet.getIndicatorIndex();
            String dimensValue = indicatorGet.getDimensValue();
            if (indicator == 0) {
                for (StatState statState : statExtEntity.getTemplateEntity().getStatStateList()) {
                    String rowKey = keyGenerator.resultKey((Stat)statExtEntity, statState.getFunctionIndex(), dimensValue, batchTime);
                    List list = keyMap.getOrDefault(metaName, new ArrayList());
                    list.add(rowKey);
                    keyMap.put(metaName, list);
                }
                continue;
            }
            String rowKey = keyGenerator.resultKey((Stat)statExtEntity, indicator - 1, dimensValue, batchTime);
            List list = keyMap.getOrDefault(metaName, new ArrayList());
            list.add(rowKey);
            keyMap.put(metaName, list);
        }
        HashMap<String, LdpResult<Long>> allResultMap = new HashMap<String, LdpResult<Long>>();
        for (Map.Entry entry : keyMap.entrySet()) {
            String metaName = (String)entry.getKey();
            HashSet<LdpGet> getSet = new HashSet<LdpGet>((int)((float)((List)entry.getValue()).size() / 0.75f) + 1);
            for (String rowKey : (List)entry.getValue()) {
                int idx = rowKey.indexOf(59);
                if (idx == -1) continue;
                String key = rowKey.substring(0, idx);
                String column = rowKey.substring(idx + 1);
                getSet.add(LdpGet.with(key, column));
            }
            ArrayList<LdpGet> getList = new ArrayList<LdpGet>(getSet);
            List<LdpResult<Long>> results = WarehouseStorageEngineProxy.getInstance().gets(metaName, getList, Long.class);
            Map<String, LdpResult> subResultMap = results.stream().filter(x -> x.getData() != null).collect(Collectors.toMap(x -> x.getKey() + ";" + x.getColumn(), x -> x));
            allResultMap.putAll(subResultMap);
        }
        for (IndicatorGet indicatorGet : indicators) {
            int indicator = indicatorGet.getIndicatorIndex();
            StatExtEntity statExtEntity = (StatExtEntity)statMap.get(indicatorGet.getStatId());
            if (indicator == 0) {
                StatValue statValue = this.calculate(statExtEntity, indicatorGet.getDimensValue(), indicatorGet.getBatchTime(), allResultMap);
                resultMap.put(indicatorGet, Double.parseDouble(statValue.getValue().toString()));
                continue;
            }
            String rowKey = keyGenerator.resultKey((Stat)statExtEntity, indicator - 1, indicatorGet.getDimensValue(), indicatorGet.getBatchTime());
            LdpResult ldpResult = (LdpResult)allResultMap.get(rowKey);
            if (ldpResult != null) {
                BigDecimal value = BigDecimal.valueOf((Long)ldpResult.getData()).divide(BigDecimal.valueOf(1000.0), 3, RoundingMode.HALF_UP).stripTrailingZeros();
                resultMap.put(indicatorGet, Double.parseDouble(value.toPlainString()));
                continue;
            }
            resultMap.put(indicatorGet, 0.0);
        }
        return resultMap;
    }
}

